<div class="page-content">
    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Students'); ?>
            </li>
            <li>
                <a href="<?php echo URL::base() . 'Teacher_Counseling'; ?>"><?php echo Lang::__('Counseling'); ?></a>
            </li>

            <li class="active"><?php echo $title; ?></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-md-6">
            <ul class="list list-icons list-dark mt-xlg">
                <li><?php echo Lang::__('name').': '.$Student_Info->Full_Name_Arabic; ?></li>
                <li><?php echo Lang::__('degree').': '.ORM::factory('Study_Degrees', $Student_Info->degree)->{'name_'.$lang}; ?></li>
                <li><?php echo Lang::__('study_type').': '.ORM::factory('Study_Types', $Student_Info->study_type)->{'name_'.$lang}; ?></li>
                <li><?php echo Lang::__('student_type').': '.ORM::factory('Students_Types', $Student_Info->student_type)->{'name_'.$lang}; ?></li>
                <li><?php echo Lang::__('academic_supervisor').': '.ORM::factory('User', $Student_Info->academic_supervisor)->{'name_'.$lang}; ?></li>
            </ul>
        </div>
        <div class="col-md-6">
            <ul class="list list-icons list-dark mt-xlg">
                <li><?php echo Lang::__('cumulative_average').': '.Lang::__("undefined"); ?></li>
                <li><?php echo Lang::__('college').': '.ORM::factory('Study_Majors', $Student_Info->major)->College->{'name_'.$lang}; ?></li>
                <li><?php echo Lang::__('major').': '.ORM::factory('Study_Majors', $Student_Info->major)->{'name_'.$lang}; ?></li>
                <?php if($Student_Info->study_type == 1 || $Student_Info->study_type == 3){ ?>
                    <li><?php echo Lang::__('current_level').': '.ORM::factory('Study_Levels', $Student_Info->level)->{'name_'.$lang}; ?></li>
                <?php } ?>
                <li><?php echo Lang::__('Academicyear').': '.$Current_Term->Academicyear->{'name_'.$lang}; ?></li>
                <li><?php echo Lang::__('Term').': '.$Current_Term->{'name_'.$lang}; ?></li>
                <?php
                $Study_Terms_Hours = ORM::factory('Study_Terms_Hours')->where('term', '=', $Current_Term->id)->where('degree', '=', $Student_Info->degree)->where('is_deleted', '=', NULL)->find();
                $min_hours = $Study_Terms_Hours->min_hours;
                $max_hours = $Study_Terms_Hours->max_hours;

                ?>
                <li><?php echo Lang::__('min_hours').': '.$min_hours; ?></li>
                <li><?php echo Lang::__('max_hours').': '.$max_hours; ?></li>
            </ul>
        </div>
    </div>
    <!-- END BREADCRUMBS -->
    <div class="row">
        <div class="col-md-12">
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-doc font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Sections registered on the term') . ' ' . $Current_Term->{'name_' . $lang}; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="AllRegSectionsTable" par1="<?php echo $Obj->username ?>" >
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="15%" class="text-center"> <?php echo Lang::__('section_no'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('major'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('course'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('course_code'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('teacher'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('credit_hours'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('Appointments'); ?> </th>
                                    <th width="30%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                         
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>