<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Stores'); ?>
            </li>
            <li>
                <a href="<?php echo URL::base() . 'Stores_Sales_Invoice'; ?>"><?php echo $title; ?></a>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                            <?php if ($Add) { ?>
                                <a class="btn btn-outline purple" href="<?php echo URL::base() . 'Stores_Sales_Invoice/AE/add'; ?>" > <i class="fa fa-plus"></i> <?php echo Lang::__('A_Sales_Invoice'); ?>  </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('transaction_no'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('store'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('type_of_recipient'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('Created_by'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Created_date'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td> </td>
                                   
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="transaction_no" placeholder="<?php echo Lang::__('transaction_no'); ?>"> 
                                    </td>
                                    <td class="text-center">
                                        <select name="store" class="form-control form-filter input-xs select2me" data-placeholder="<?php echo Lang::__('store'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Stores_Stores as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{"name_".$lang}; ?></option>
                                            <?php } ?>
                                        </select> 
                                    </td>
                                
                                    <td class="text-center">
                                        <select name="type_of_recipient" class="form-control form-filter input-xs select2me" data-placeholder="<?php echo Lang::__('type_of_recipient'); ?>">
                                            <option value=""></option>
                                            <option value="1"><?php echo Lang::__('Customer'); ?></option>
                                            <option value="2"><?php echo Lang::__('Employee'); ?></option>
                                            <option value="3"><?php echo Lang::__('Student'); ?></option>
                                            
                                        </select> 
                                    </td>
                                    
                                    <td class="text-center" >
                                        <input type="text" class="form-control form-filter input-sm" name="Created_by"  placeholder="<?php echo Lang::__('Created_by'); ?>">
                                    </td>
                                
                                    <td class="text-center">
                                        <div class="input-group date date-picker margin-bottom-5" data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="Created_date_From" placeholder="<?php echo Lang::__('From'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                        <div class="input-group date date-picker" data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="Created_date_to" placeholder="<?php echo Lang::__('To'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                    </td>
                               


                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>