<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Stores'); ?>
            </li>
            <li>
                <?php echo Lang::__('Goods Detection'); ?>
            </li>
            <li>
                <a class="active"><?php echo $title; ?></a>
            </li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                           
                        </div>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax" par1="<?php echo $type; ?>">
                            <thead>
                                <tr role="row" class="filter">
                                    <td class="text-center" colspan="10" >
                                        <div class="row" style="margin: 0;">
                                            <div class="display-block text-center form-horizontal">
                                                <?php if($type == 'employees'){ ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3"><?php echo Lang::__('employee'); ?></label>
                                                        <div class="col-md-9">
                                                            <select name="employee" class="form-control form-filter input-xs select2me" data-placeholder="<?php echo Lang::__('employee'); ?>">
                                                                <option value=""></option>
                                                                <?php foreach ($Employees as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->GetFullName($lang); ?></option>
                                                                <?php } ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php } ?>
                                                <?php if($type == 'suppliers'){ ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3"><?php echo Lang::__('supplier'); ?></label>
                                                        <div class="col-md-9">
                                                            <select name="supplier" class="form-control form-filter input-xs select2me" data-placeholder="<?php echo Lang::__('supplier'); ?>">
                                                                <option value=""></option>
                                                                <?php foreach ($Suppliers as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{"AccName_".$lang}; ?></option>
                                                                <?php } ?>
                                                            </select> 
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php } ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3"><?php echo Lang::__('Date Range'); ?></label>
                                                        <div class="col-md-9">
                                                            <div class="input-group input-large date-picker input-daterange" data-date-format="yyyy-mm-dd">
                                                                <input type="text" class="form-control form-filter" name="from_date" placeholder="<?php echo Lang::__('from_date'); ?>">
                                                                <span class="input-group-addon"> <?php echo Lang::__('to'); ?> </span>
                                                                <input type="text" class="form-control form-filter" name="to_date"  placeholder="<?php echo Lang::__('to_date'); ?>"> </div>
                                                            <!-- /input-group -->
                                                            <span class="help-block"> <?php echo Lang::__('Select date range'); ?> </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <div class="col-md-6">
                                                            <button type="button" class="btn btn-block blue-madison filter-submit-2"><?php echo Lang::__('Search'); ?></button>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <button type="button" class="btn btn-block yellow-casablanca filter-cancel"><?php echo Lang::__('Reset'); ?></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <tr role="row" class="heading">
                              
                                    <th width="10%" class="text-center"> <?php echo Lang::__('type'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('transaction_no'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('store'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Created_by'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Created_date'); ?> </th>
                                    <th width="5%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>