<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Library'); ?>
            </li>
            <li>
                <?php echo Lang::__('Library_manager'); ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn red btn-outline btn-circle" href="javascript:;" data-toggle="dropdown">
                                <i class="fa fa-share"></i>
                                <span class="hidden-xs"> <?php echo Lang::__('add_new'); ?> </span>
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <ul class="dropdown-menu pull-right">
                                    <li>
                                        <a href="<?php echo URL::base() . 'Library_Manager/AE/Book'; ?>"> <?php echo Lang::__('Book'); ?> </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo URL::base() . 'Library_Manager/AE/Thesis'; ?>"> <?php echo Lang::__('Thesis'); ?> </a>
                                    </li>
                                
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">

                                    <th width="18%" class="text-center"> <?php echo Lang::__('type'); ?> </th>
                                    <th width="18%" class="text-center"> <?php echo Lang::__('title'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('auther'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('public_number'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('category_no'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td class="text-center" style="padding: 10px 18px;">
                                        <select name="type" class="form-control input-xs select2me form-filter" data-placeholder="<?php echo Lang::__('category'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Library_Types as $value) { ?>
                                                <option value="<?php echo $value->id; ?>" ><?php echo $value->{"name_".$lang}; ?></option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center" >
                                        <input type="text" class="form-control form-filter input-sm" name="title">
                                    </td>
                                    <td class="text-center" >
                                        <input type="text" class="form-control form-filter input-sm" name="auther">
                                    </td>
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="public_number">
                                    </td>
                       
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="category_no">
                                    </td>

                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>