<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Human_Resources'); ?>
            </li>

            <li>
                <?php echo $title; ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-plus font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('import_data_into').' ' . $title; ?></span>
                    </div>
                    <div class="actions">
                        
                    </div>
                </div>
            <?php if ($Import_attendance_and_departure) { ?>
                <div class="portlet-body form">
                    <form id="SForm" class="form-horizontal"  role="form">
                        <div class="form-body">

                            <div class="form-group">
                                <label class="col-md-3 control-label"><?php echo Lang::__('Excel_File'); ?></label>
                                <div class="col-md-5">
                                    <input type="file" class=" file" name="excel_file" > 
                                    <span class="help-block"><?php echo Lang::__('Must_be_in_this_format'); ?> xls , xlsx</span>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-md-offset-3">
                                    <button type="submit" class="btn btn-default"><?php echo Lang::__('Send_Excel'); ?></button>
                                </div>
                            </div>
                            
                        </div>
                    </form>
                </div>
            <?php } ?>
        </div>
        </div>
    </div>
    <?php if($NotReviewed > 0){ ?>
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-warning">
                <?php echo Lang::__('Note: Some data in the Attendance and Displacement table is not yet reviewed, this data does not affect the accounts and the system until it is checked as a reviewed. The data count is:').' '.$NotReviewed; ?>
            </div>
        </div>
    </div>
    <?php } ?>
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                            <?php if ($Export_attendance_and_departure) { ?>
                                <a class="btn btn-outline purple" href="<?php echo URL::base() . 'Hr_Attendance/ExportData'; ?>" > <i class="fa fa-chevron-circle-down"></i> <?php echo Lang::__('Export_attendance_and_departure'); ?>  </a>
                            <?php } ?>
                            <?php if ($Review_attendance_and_departure) { ?>
                                <button class="btn btn-outline green ReviewAll" Dtitle="<?php echo Lang::__('confirmation'); ?>" Dcontent="<?php echo Lang::__('Are you sure you want to mark all the data in the attendance table as a reviewed'); ?>" confirmButton="<?php echo Lang::__('Yes'); ?>" cancelButton="<?php echo Lang::__("No"); ?>" >  <?php echo Lang::__('Submit_Review_ALL_Data'); ?>  </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('code'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('employee'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('date'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('clock_in'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('clock_out'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('late'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('early'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('absent'); ?> </th>
                                    <th width="8%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td> </td>
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="code" placeholder="<?php echo Lang::__('code'); ?>"/>
                                    </td>
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="name" placeholder="<?php echo Lang::__('name'); ?>"/>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group date date-picker margin-bottom-5" data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="date_From" placeholder="<?php echo Lang::__('From'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                        <div class="input-group date date-picker" data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="date_to" placeholder="<?php echo Lang::__('To'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group margin-bottom-5">
                                            <input type="text" name="clock_in_from"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('From'); ?>">
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="clock_in_to"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('To'); ?>">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group margin-bottom-5">
                                            <input type="text" name="clock_out_from"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('From'); ?>">
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="clock_out_to"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('To'); ?>">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group margin-bottom-5">
                                            <input type="text" name="late_from"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('From'); ?>">
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="late_to"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('To'); ?>">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group margin-bottom-5">
                                            <input type="text" name="early_from"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('From'); ?>">
                                        </div>
                                        <div class="input-group">
                                            <input type="text" name="early_to"  class="form-control form-filter input-sm timepicker-24" placeholder="<?php echo Lang::__('To'); ?>">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <select name="absent" class="select2me form-control form-filter" data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <option value="1"><?php echo Lang::__('Yes'); ?></option>
                                            <option value="2"><?php echo Lang::__('No'); ?></option>
                                        </select>
                                    </td>
                                    


                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>