<div class="page-content">
    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Financials'); ?>
            </li>
            <li>
                <a href="<?php echo URL::base() . 'Financials_Payments'; ?>"><?php echo Lang::__('Cost of terms'); ?></a>
            </li>

            <li class="active"><?php echo $title; ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">     
        <div class="col-md-12 ">
            <!-- BEGIN SAMPLE FORM PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-body form">
                    <form  class="form-horizontal" role="form">
                        <div class="form-body">
                            <?php if(isset($Current_Term)){ ?>
                            <h4 class="bg-green bg-font-green text-center" style="padding: 10px;"><?php echo $Current_Term->{'name_'.$lang}; ?> (<span><?php echo Lang::__('Current_term'); ?></span>)</h4>
                            <div class="form-group">
                                <label class="col-md-3 control-label"><?php echo Lang::__('cost'); ?> </label>
                                <div class="col-md-3">
                                    <p class="form-control-static"><?php echo Model_Financials_Payments::CalculateTermCost($User->id,$Current_Term); ?></p>
                                  
                                </div>
                            </div>   
                            <div class="form-group">
                                <label class="col-md-3 control-label"><?php echo Lang::__('Tracking algorithm algorithm'); ?> </label>
                                <div class="col-md-9">
                                    
                                    <?php
                                    $Debugging_texts = Model_Financials_Payments::CalculateTermCost($User->id,$Current_Term,TRUE,$lang);
                                    if(is_array($Debugging_texts)){
                                        echo '<div class="form-control-static">';
                                        echo '<div><span>'.Lang::__('Based on the algorithm specified in the system').'</span> </div>';
                                        foreach ($Debugging_texts['Rules'] as $Key=>$Value) {
                                            if($Value['class'] == 'not_active'){
                                                $class = 'font-red-mint';
                                            }elseif($Value['class'] == 'active'){
                                                $class = 'font-green sbold';
                                            }
                                        echo '<div><span class="'.$class.'">* '.Lang::__($Key).'</span></div>';
                                        echo !empty($Value['description'])?'<div>'.  Lang::__('Note').': '.$Value['description'].'</div>':NULL;
                                        }
                                        
                                        if(!empty($Debugging_texts['notes'])){
                                            foreach ($Debugging_texts['notes'] as $value) {
                                            echo '<div>* <span>'.$value.'</span></div>';
                                            }
                                           
                                        }
                                        
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                            </div>   
                            <?php } ?>
                            <?php foreach ($Students_Terms as $Students_Term) {
                                $Term = $Students_Term->Term;
                            ?>
                            <h4 class="bg-red-mint bg-font-red-mint text-center" style="padding: 10px;"><?php echo $Term->{'name_'.$lang}; ?></h4>
                            <div class="form-group">
                                <label class="col-md-3 control-label"><?php echo Lang::__('cost'); ?> </label>
                                <div class="col-md-3">
                                    <p class="form-control-static"><?php echo Model_Financials_Payments::CalculateTermCost($User->id,$Term); ?></p>
                                </div>
                            </div>    
                            <?php } ?>
                            
                            
                          
                        </div>
                        
                    </form>
                </div>
            </div>
            <!-- END SAMPLE FORM PORTLET-->
        </div>
    </div>
    
    <!-- END PAGE BASE CONTENT -->
</div>