<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Financials'); ?>
            </li>
            <li>
                <?php echo $title; ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                            <?php if ($Add) { ?>
                                <a class="btn btn-outline purple" href="<?php echo URL::base() . 'Financials_Sponsors/AE/add'; ?>" > <i class="fa fa-plus"></i> <?php echo Lang::__('add_new'); ?>  </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('name_ar'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('name_en'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('legalform'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('sponsor_type'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('email'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td> </td>
                                    <td class="text-center" colspan="2">
                                        <input type="text" class="form-control form-filter input-sm" name="name"> 
                                    </td>
                                    
                                    <td class="text-center">
                                        <?php $General_Legalforms = isset($General_Legalforms)?$General_Legalforms:ORM::factory('General_Legalforms')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control form-filter input-sm select2me" name="legalform"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($General_Legalforms as $Legalform) { ?>
                                            <option value="<?php echo $Legalform->id; ?>" <?php if(isset($Obj) && ($Obj->legalform == $Legalform->id)){ ?>selected=""<?php } ?>><?php echo $Legalform->{'name_'.$lang}; ?></option>
                                            <?php } ?>                                    
                                        </select>
                                    </td>
                                   
                                    <td class="text-center">
                                        <?php $Financials_Sponsors_Types = ORM::factory('Financials_Sponsors_Types')->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control form-filter input-sm select2me" name="sponsor_type"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Financials_Sponsors_Types as $Financials_Sponsors_Type) { ?>
                                            <option value="<?php echo $Financials_Sponsors_Type->id; ?>" <?php if(isset($Obj) && ($Obj->sponsor_type == $Financials_Sponsors_Type->id)){ ?>selected=""<?php } ?>><?php echo $Financials_Sponsors_Type->{'name_'.$lang}; ?></option>
                                            <?php } ?>                                    
                                        </select> 
                                    </td>
                                 
                       
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="email"> 
                                    </td>

                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>