<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Financials'); ?>
            </li>
            <li>
                <?php echo $title; ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                           
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('Code'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('Name'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('Working Days'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Late Hours'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Absent Days'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('basic_salary'); ?> </th>
                                </tr>
                                
                            </thead>
                            <tbody> </tbody>
                            <tfoot>
                                <tr role="row" class="filter">
                                    <td colspan="7" class="text-center form-horizontal">
                                        <div class="display-block">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('College'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $Study_Colleges = ORM::factory('Study_Colleges')->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="college"  data-placeholder="<?php echo Lang::__('college'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($Study_Colleges as $Study_College) { ?>
                                                            <optgroup label="<?php echo $Study_College->{'name_'.$lang} ?>">
                                                                <?php
                                                                $Study_Majors = $Study_College->Majors->where('is_deleted','=',NULL)->find_all();
                                                                foreach ($Study_Majors as $Major) { ?>
                                                                <option value="<?php echo $Major->id; ?>"><?php echo $Major->{'name_'.$lang}; ?></option>
                                                                <?php } ?>
                                                            </optgroup>    
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('Employee'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $Employees = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="employee"  data-placeholder="<?php echo Lang::__('Employee'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($Employees as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_first_'.$lang}.' '.$value->{'name_father_'.$lang}.' '.$value->{'name_grandfather_'.$lang}.' '.$value->{'name_last_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('Department'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $Departments = ORM::factory('General_Hr_Departments')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="department" data-placeholder="<?php echo Lang::__('Department'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($Departments as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('Cost_Center'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $Financials_Costcenters = ORM::factory('Financials_Costcenter')->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="cost_center" data-placeholder="<?php echo Lang::__('Cost_Center'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($Financials_Costcenters as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('Bank'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $General_Banks = ORM::factory('General_Banks')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="bank" data-placeholder="<?php echo Lang::__('Bank'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($General_Banks as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('salary_status'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <select class="form-control form-filter input-sm select2me" name="salary_status" data-placeholder="<?php echo Lang::__('salary_status'); ?>">
                                                            <option value=""></option>
                                                            <option value="1"><?php echo Lang::__('Disbursed'); ?></option>
                                                            <option value="2"><?php echo Lang::__('Not_disbursed'); ?></option>
                                                            <option value="3"><?php echo Lang::__('Calculated_salary'); ?></option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <div class="col-md-12  form-control-static">
                                                        <div class="mt-checkbox-list">
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" value="1" name="" />
                                                                 <?php echo Lang::__('Hide zero Net Salaries employee'); ?>
                                                                
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('Section'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $General_Hr_Sections = ORM::factory('General_Hr_Sections')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="section" data-placeholder="<?php echo Lang::__('Section'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($General_Hr_Sections as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('Gender'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $General_Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="gender" data-placeholder="<?php echo Lang::__('Gender'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($General_Genders as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('position'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $General_Hr_Positions = ORM::factory('General_Hr_Positions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="position" data-placeholder="<?php echo Lang::__('Position'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($General_Hr_Positions as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('employee_type'); ?>
                                                    </div>
                                                    <div class="col-md-9">
                                                        <?php $General_Hr_Employee_Types = ORM::factory('General_Hr_Employee_Types')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                                        <select class="form-control form-filter input-sm select2me" name="employee_type" data-placeholder="<?php echo Lang::__('employee_type'); ?>">
                                                            <option value=""></option>
                                                            <?php foreach ($General_Hr_Employee_Types as $value) { ?>
                                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-3 control-label">
                                                        <?php echo Lang::__('date'); ?>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <select class="form-control form-filter input-sm select2me" name="year" data-placeholder="<?php echo Lang::__('year'); ?>">
                                                            <option value=""></option>
                                                            <?php $CurrentGyear = intval(Date('Y')); ?>
                                                            <?php for ($x = $CurrentGyear;$x>= 2010;$x--){  ?>
                                                            <option value="<?php echo $x; ?>"><?php echo $x; ?></option>    
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                   
                                                    <div class="col-md-4">
                                                        <select class="form-control form-filter input-sm select2me" name="month" data-placeholder="<?php echo Lang::__('month'); ?>">
                                                            <option value=""></option>
                                                            <?php for ($x = 1;$x <= 12;$x++){  ?>
                                                            <option value="<?php echo $x; ?>"><?php echo $x; ?></option>    
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                
                                                <div class="form-group">
                                                    <div class="col-md-6">
                                                        <button type="button" class="btn btn-block blue-madison filter-submit"><?php echo Lang::__('Search'); ?></button>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <button type="button" class="btn btn-block yellow-casablanca filter-cancel"><?php echo Lang::__('Reset'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block blue-hoki"><?php echo Lang::__('Print'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block grey-cascade"><?php echo Lang::__('Delete Calculated Salaries For Selected Month'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block blue-hoki"><?php echo Lang::__('Delete Posted Salaries from Accounts'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block grey-cascade"><?php echo Lang::__('Show none calculated salaries only'); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <div class="col-md-6  form-control-static">
                                                        <div class="mt-checkbox-list">
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" value="1" name="" />
                                                                 <?php echo Lang::__('select_all'); ?>
                                                                
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6  form-control-static">
                                                        <div class="mt-checkbox-list">
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" value="1" name="" />
                                                                 <?php echo Lang::__('With attendance'); ?>
                                                                
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block grey-cascade"><?php echo Lang::__('Calculate Salary'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block blue-hoki"><?php echo Lang::__('Salary Slip'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block grey-cascade"><?php echo Lang::__('Mark Salary paid only'); ?></button>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <button type="button" class="btn btn-block blue-hoki"><?php echo Lang::__('Post salaries to accounts'); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>