<?php

class Model_Study_Sections extends ORM {

    protected $_table_name = 'study_sections';
    protected $_belongs_to = array(
        'Course' => array('model' => 'Study_Courses', 'foreign_key' => 'course'),
        'Term' => array('model' => 'Study_Terms', 'foreign_key' => 'term'),
        'Room' => array('model' => 'Study_Rooms', 'foreign_key' => 'room'),
        'Teacher' => array('model' => 'User', 'foreign_key' => 'teacher'),
        'Major' => array('model' => 'Study_Majors', 'foreign_key' => 'major'),
        'Gender' => array('model' => 'General_Genders', 'foreign_key' => 'gender'),
    );
    protected $_has_many = array(
        'Study_Sections_Dates' => array('model' => 'Study_Sections_Dates', 'foreign_key' => 'section'),
        'Students_Sections' => array('model' => 'Students_Sections', 'foreign_key' => 'section'),
        'Students_Participates' => array('model' => 'Students_Participates', 'foreign_key' => 'section_id'),
        'Students_Infractions' => array('model' => 'Students_Infractions', 'foreign_key' => 'section_id'),
        'Students_Absents' => array('model' => 'Students_Absents', 'foreign_key' => 'section_id'),
        'Students_Notes' => array('model' => 'Students_Notes', 'foreign_key' => 'section_id'),
        'Chapters' => array('model' => 'Study_Sections_Chapters', 'foreign_key' => 'section_id'),
    );

    public function rules() {
        return array(
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

}
