<?php

class Model_Students_Types extends ORM {

    protected $_table_name = 'students_types';
    protected $_belongs_to = array(
        'Study_Type' => array('model' => 'Study_Types', 'foreign_key' => 'study_type'),
    );
    protected $_has_many = array(
        'Financials_Fees_Courses' => array('model' => 'Financials_Fees_Courses', 'foreign_key' => 'student_type'),
        'Financials_Discounts' => array('model' => 'Financials_Discounts', 'foreign_key' => 'student_type'),
        'Students_Applications' => array('model' => 'Students_Applications', 'foreign_key' => 'student_type'),
    );

    public function rules() {
        return array(
            'name_ar' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
            ),
            'name_en' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
            ),
            'study_type' => array(
                array('not_empty'),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

}
