<?php

class Model_Stores_Inventory extends ORM {

    protected $_table_name = 'stores_inventory';
    protected $_belongs_to = array(
        'Category' => array('model' => 'General_Stores_Categories', 'foreign_key' => 'category'),
        'Store' => array('model' => 'General_Stores_Stores', 'foreign_key' => 'store'),
        'Unit' => array('model' => 'General_Stores_Units', 'foreign_key' => 'unit'),
    );
    protected $_has_many = array(
        'Purchase_Elements' => array('model' => 'Stores_Purchase_Elements', 'foreign_key' => 'item'),
        'Goods_Receipts_Vitems' => array('model' => 'Stores_Goods_Receipts_Vitems', 'foreign_key' => 'item'),
        'Goods_Delivery_Vitems' => array('model' => 'Stores_Goods_Delivery_Vitems', 'foreign_key' => 'item'),
        'Goods_Elimination_Vitems' => array('model' => 'Stores_Goods_Elimination_Vitems', 'foreign_key' => 'item'),
        'Sales_Invoice_Vitems' => array('model' => 'Stores_Sales_Invoice_Vitems', 'foreign_key' => 'item'),
        'Stocktaking_Elements' => array('model' => 'Stores_Stocktaking_Process_Elements', 'foreign_key' => 'item'),
        'Goods_Transfer_Vitems' => array('model' => 'Stores_Goods_Transfer_Vitems', 'foreign_key' => 'item'),
        'Goods_Transfer_Transfared' => array('model' => 'Stores_Goods_Transfer_Vitems', 'foreign_key' => 'new_item'),
    );

    public function rules() {
        return array(
            'id' => array(
                array('Model_Stores_Inventory::OneOfTow', array(':field', ':validation', ':value')),
            ),
            'sales_price' => array(
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'min_qty' => array(
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'max_qty' => array(
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'commision_percentage' => array(
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'service_item' => array(
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
                array('Model_Stores_Inventory::NoValuesForServices', array(':field', ':validation', ':value')),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function AdminRules($ORM, $Filtered_array = NULL) {
        // في الجكويري يوجد تخصيص في حال تم تحديد المنتج ك خدمة
        $RulesJquery = array(
            'name_ar' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'name_en' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'shelf' => array(
                'maxlength' => 255,
            ),
            'barcode' => array(
                'maxlength' => 255,
                'required' => TRUE,
            ),
            'category' => array(
                'required' => TRUE,
            ),
            'unit' => array(
                'required' => TRUE,
            ),
            'sales_price' => array(
                'number' => TRUE,
                'required' => TRUE,
            ),
            'min_qty' => array(
                'number' => TRUE,
            ),
            'max_qty' => array(
                'number' => TRUE,
            ),
            'store' => array(
            //'required' => TRUE,
            ),
            'cost' => array(
                'number' => TRUE,
                'required' => TRUE,
            ),
            'commision' => array(
                'number' => TRUE,
            ),
            'commision_percentage' => array(
                'range' => [0, 100],
            ),
            'service_item' => array(
            //'number' => TRUE,
            ),
        );

        //If item is service
        //ملاحظة هامة ... لتعديل الحقول يجب التعديل في الكونترولر وتعديل الجكويري ايضا
        if (!empty($Filtered_array)) {
            if (isset($Filtered_array['service_item']) && $Filtered_array['service_item']) {
                unset($RulesJquery['cost']);
                unset($RulesJquery['unit']);
            }
        }
        //End if item is service

        return $RulesJquery;
    }

    /*
     * لتحقق من وجود اما عمولة او نسبة عمولة وليس الاثنين او لا شيء
     */

    public static function OneOfTow($field, $validation, $id) {
        $data = $validation->data();

        if (!empty($data['commision']) && !empty($data['commision_percentage'])) {
            $validation->error($field, 'You_must_specify_either_commision_or_pers_commision');
        }
    }

    public static function NoValuesForServices($field, $validation, $id) {
        $data = $validation->data();


        if (!empty($data['service_item'])) {
            if (!empty($data['cost']) || !empty($data['unit'])) {
                $validation->error($field, 'service_item_dont_have_value_of_some_entered_feilds');
            }
        }
    }

    /*
     * لحساب الكمية الحالية من المنتج
     */

    public static function CurrentQty($Inventory_ORM) {
        $TotalQty = 0;

        

        $Purchase_Elements = $Inventory_ORM->Purchase_Elements->where('is_deleted', '=', NULL)->find_all();
        foreach ($Purchase_Elements as $value) {
            $TotalQty += $value->quantity;
        }
        
        $Goods_Receipts_Vitems = $Inventory_ORM->Goods_Receipts_Vitems->where('is_deleted', '=', NULL)->find_all();
        foreach ($Goods_Receipts_Vitems as $value) {
            $TotalQty += $value->quantity;
        }
      
        $Goods_Delivery_Vitems = $Inventory_ORM->Goods_Delivery_Vitems->where('is_deleted', '=', NULL)->find_all();
        foreach ($Goods_Delivery_Vitems as $value) {
            $TotalQty -= $value->quantity;
        }

        $Goods_Elimination_Vitems = $Inventory_ORM->Goods_Elimination_Vitems->where('is_deleted', '=', NULL)->find_all();
        foreach ($Goods_Elimination_Vitems as $value) {
            $TotalQty -= $value->quantity;
        }

        $Goods_Transfer_Vitems = $Inventory_ORM->Goods_Transfer_Vitems->where('is_deleted', '=', NULL)->find_all();
        foreach ($Goods_Transfer_Vitems as $value) {
            $TotalQty -= $value->quantity;
        }
        //حساب الكميات المنقولة 
        $Goods_Transfer_Transfared = $Inventory_ORM->Goods_Transfer_Transfared->where('is_deleted', '=', NULL)->find_all();
        foreach ($Goods_Transfer_Transfared as $value) {
            $TotalQty += $value->quantity;
        }

        $Sales_Invoice_Vitems = $Inventory_ORM->Sales_Invoice_Vitems->where('is_deleted', '=', NULL)->find_all();
        foreach ($Sales_Invoice_Vitems as $value) {
            $TotalQty -= $value->quantity;
        }

        $Stores_Stocktaking_Process_Elements = $Inventory_ORM->Stocktaking_Elements->where('stocktake', '=', 1)->where('is_deleted', '=', NULL)->find_all();
        foreach ($Stores_Stocktaking_Process_Elements as $value) {
            $TotalQty += $value->qty_diff;
        }

        
        return $TotalQty;
    }

    public function RCurrentQty() {

        return Model_Stores_Inventory::CurrentQty($this);
    }

}
