<?php

class Model_Stores_Goods_Delivery_Voucher extends ORM {

    protected $_table_name = 'stores_goods_delivery_voucher';
    protected $_belongs_to = array(
        'Store' => array('model' => 'General_Stores_Stores', 'foreign_key' => 'store'),
        'Customer' => array('model' => 'Accounting_Accounts', 'foreign_key' => 'customer'),
        'Hr_Employment_Application' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'employee'),
        'Created_by_User' => array('model' => 'User', 'foreign_key' => 'Created_by'),
        'Last_Update_by_User' => array('model' => 'User', 'foreign_key' => 'last_update_by'),
        'Deleted_By_User' => array('model' => 'User', 'foreign_key' => 'deleted_by'),
    );
    protected $_has_many = array(
        'Items' => array('model' => 'Stores_Goods_Delivery_Vitems', 'foreign_key' => 'voucher_id'),
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'store' => array(
                array('not_empty'),
            ),
            'type_of_recipient' => array(
                array('not_empty'),
            ),
            'Created_date' => array(
                array('not_empty'),
            ),
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

   public static function OneOfTow($field, $validation, $id) {
        $data = $validation->data();
        if ($id == 1 && empty($data['customer'])) {
            $validation->error('customer', 'Required');
        }
        if ($id == 2 && empty($data['employee'])) {
            $validation->error('employee', 'Required');
        }
    }

}
