<?php

class Model_Permissions_Groups extends ORM {

    protected $_table_name = 'permissions_groups';
    protected $_belongs_to = array(
    );
    protected $_has_many = array(
        'Permissions_Relations_Groubs' => array('model' => 'Permissions_Relations', 'foreign_key' => 'groub'),
        'Permissions_Relations_Roles' => array('model' => 'Permissions_Relations', 'foreign_key' => 'role'),
        'Roles' => array(
            'model' => 'Role',
            'through' => 'permissions_groups_roles_relations',
            'far_key' => 'role',
            'foreign_key' => 'groub',
        ),
        
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'name_ar' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
            ),
            'name_en' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
            ),
          
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    /*
     * Jquery Plugin Rules when admin add/modify row...
     */

    public static function AdminRules($ORM) {

        $RulesJquery = array(
            'name_ar' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'name_en' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            
        );

        return $RulesJquery;
    }


}
