<?php

class Model_Library_Manager extends ORM
{

    protected $_table_name = 'library_manager';
    protected $_belongs_to = array(
        'Type' => array('model' => 'Library_Types', 'foreign_key' => 'type'),
    );
    protected $_has_many = array();

    public function rules()
    {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        $A = array_merge_recursive($Auto_arr, array(
            'type' => array(
                array('not_empty'),
            ),
        ));
        return $A;
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules()
    {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id)
    {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function AdminRules($ORM, $Filtered_array = NULL)
    {
        // في الجكويري يوجد تخصيص حسب نوع الكتاب او الرسالة
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        if ($ORM->loaded()) {
            $type = $ORM->type;
        } else {

            if ($par2 == 1) {
                $type = 1;
            }
            if ($par2 == 2) {
                $type = 2;
            }
        }

        $ForAllRoles = array(
            'title' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'auther' => array(
                //'required' => TRUE,
                'maxlength' => 255,
            ),
            'public_number' => array(
                //'required' => TRUE,
                'maxlength' => 255,
            ),
            'category_no' => array(
                //'required' => TRUE,
                'maxlength' => 255,
            ),

            'pdf_file' => array(
                //'required' => empty($ORM->id_copy) ? TRUE : FALSE,
                'accept' => "pdf",
                'filesize' => 5 * 1000000, //B
            ),
            'cover_image' => array(
                //'required' => empty($ORM->id_copy) ? TRUE : FALSE,
                'accept' => "jpg|jpeg|png|gif",
                'filesize' => 5 * 1000000, //B
            ),
        );
        $RulesJquery_1 = array();
        if ($type == 1) {
            $RulesJquery_1 = array(


                'isbn' => array(
                   // 'required' => TRUE,
                    'maxlength' => 255,
                ),
                'topic_of_book' => array(
                   // 'required' => TRUE,
                    'maxlength' => 255,
                ),

                'part_number' => array(
                   // 'required' => TRUE,
                    'number' => TRUE,
                    'maxlength' => 255,
                ),
                'place_of_book' => array(
                  //  'required' => TRUE,
                    'maxlength' => 255,
                ),

                'publisher' => array(
                  //  'required' => TRUE,
                    'maxlength' => 255,
                ),
                'serial' => array(
                  //  'required' => TRUE,
                    'maxlength' => 255,
                ),
                'place_of_publication' => array(
                   // 'required' => TRUE,
                    'maxlength' => 255,
                ),
                'date_of_publication' => array(
                   // 'required' => TRUE,
                    'date' => TRUE,
                    'maxlength' => 255,
                ),
                'edition' => array(
                   // 'required' => TRUE,
                    'number' => TRUE,
                    'maxlength' => 255,
                ),
                'number_of_pages' => array(
                   // 'required' => TRUE,
                    'number' => TRUE,
                    'maxlength' => 255,
                ),


            );
        } elseif ($type == 2) {
            $RulesJquery_1 = array(


                'degree' => array(
                    //'required' => TRUE,
                    'maxlength' => 255,
                ),
                'supervisor' => array(
                    //'required' => TRUE,
                    'maxlength' => 255,
                ),
                'major' => array(
                    //'required' => TRUE,
                    'maxlength' => 255,
                ),
                'hand_graduation' => array(
                    //'required' => TRUE,
                    'maxlength' => 255,
                ),
                'date_of_thesis' => array(
                    //'required' => TRUE,
                    'maxlength' => 255,
                ),

                'summary_book' => array(
                    //'required' => TRUE,
                    'maxlength' => 255,
                ),

            );
        }

        $RulesJquery = array_merge_recursive($ForAllRoles, $RulesJquery_1);


        return $RulesJquery;
    }


}
