<?php

class Model_Hr_Rewards extends ORM {

    protected $_table_name = 'hr_rewards';
    protected $_belongs_to = array(
        'Employment_Applications' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'employee'),
        'Reward_Type' => array('model' => 'General_Hr_Rewards_Types', 'foreign_key' => 'reward_type'),
        'Approved_By' => array('model' => 'User', 'foreign_key' => 'approved_by'),
    );
    protected $_has_many = array(
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'employee' => array(
                array('not_empty'),
                array('Model_Hr_Rewards::is_employee', array(':field', ':validation', ':value')),
            ),
            'reward_type' => array(
                array('not_empty'),
            ),
            'amount' => array(
                array('not_empty'),
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'starting_due_month' => array(
                array('numeric'),
                array('range', array(':value', 1, 12)),
            ),
            'starting_due_year' => array(
                array('numeric'),
                array('date'),
            ),
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    /*
     * Jquery Plugin Rules when admin add/modify row...
     */

    public static function AdminRules($ORM) {

        $RulesJquery = array(
            'employee' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
            'reward_type' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
            'amount' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
            'starting_due_month' => array(
                'number' => TRUE,
                'range' => [1, 12]
            ),
            'starting_due_year' => array(
                'number' => TRUE,
                'date' => TRUE,
            ),
            'reason' => array(
            ),
        );

        return $RulesJquery;
    }

    public static function is_employee($field, $validation, $id) {
        $data = $validation->data();
        if (!empty($data['employee'])) {
            $Employees = ORM::factory('Hr_Employment_Applications', $data['employee']);
            if (!($Employees->loaded() && ($Employees->app_status == 1) && empty($Employees->is_deleted))) {
                $validation->error('employee', 'Not_Loaded_In_Database');
            }
        }
    }

}
