<?php

class Model_Hr_Allowances_Relations extends ORM {

    protected $_table_name = 'hr_allowances_relations';
    protected $_belongs_to = array(
        'Allowances_Type' => array('model' => 'Hr_Allowances_Types', 'foreign_key' => 'type'),
        'Employee_Application' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'employee'),
    );
    protected $_has_many = array(
        //'Allowances_Relations' => array('model' => 'Hr_Allowances_Relations', 'foreign_key' => 'type'),
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'id' => array(
                array('Model_Hr_Allowances_Relations::Not_P_exist', array(':field', ':validation', ':value')),
            ),
            'type' => array(
                array('not_empty'),
                array('numeric'),
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'employee' => array(
                array('not_empty'),
                array('numeric'),
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function Not_P_exist($field, $validation, $id) {
        if (empty($id)) {
            $data = $validation->data();
            $P = ORM::factory('Hr_Allowances_Relations')
                    ->where('type', '=', $data['type'])
                    ->where('employee', '=', $data['employee'])
                    ->where('is_deleted', '=', NULL)
                    ->find();
            if ($P->loaded()) {
                $validation->error($field, 'Relationship_already_exists');
            }
        }
    }

}
