<?php

class Model_Financials_Accounts extends ORM {

    protected $_table_name = 'accounting_accounts';

    public function rules() {
        return array(
            'AccNo' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
                array(array($this, 'unique'), array('AccNo', ':value')),
            ),
            'AccName_ar' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
                array(array($this, 'unique'), array('AccName_ar', ':value')),
            ),
            'AccName_en' => array(
                array('max_length', array(':value', 255)),
            ),
            'ParentNo' => array(
                array('not_empty'),
                array('numeric'),
                array(array($this, 'Move_on_account_Happen')),
            ),
            'Selling_price' => array(
                array('numeric'),
            ),
            'CreditLimit' => array(
                array('numeric'),
            ),
            'AccType' => array(
                array('numeric'),
            ),
        );
    }
    protected $_belongs_to = array(
        'Parent' => array('model' => 'Financials_Accounts', 'foreign_key' => 'ParentNo'),
        'Created_User' => array('model' => 'User', 'foreign_key' => 'Created_by'),
    );
    protected $_has_many = array(
        'Childs' => array('model' => 'Financials_Accounts', 'foreign_key' => 'ParentNo'),
        'Employment_Applications' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'account_id'),
    );

    public function Move_on_account_Happen($ParentNo) {
        if($ParentNo == 0){
            return TRUE;
        }else{
            $obj = ORM::factory('Financials_Accounts', $ParentNo);
        $move_happen = Accounts::Move_on_account($obj);
        if($move_happen === FALSE){
            return TRUE;
        }
        else{
            return FALSE;
        }
        }
        
}
}