<?php

class Model_Accounting_Payments extends ORM {

    protected $_table_name = 'accounting_payments';
    protected $_belongs_to = array(
        'Term' => array('model' => 'Study_Terms', 'foreign_key' => 'term'),
        'Discount' => array('model' => 'Financials_Discounts', 'foreign_key' => 'Discount'),
        'Student' => array('model' => 'User', 'foreign_key' => 'student'),
        //'accounting_accounts' => array('model' => 'accounting_accounts', 'foreign_key' => 'student'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        return array(
            'id' => array(
                array('Model_Accounting_Payments::CheckTotalPaid', array(':validation', ':value')),
            ),
            
            'Cash' => array(
                array('numeric'),
            ),
            'Bank_Transfer' => array(
                array('numeric'),
            ),
            'ATM' => array(
                array('numeric'),
            ),
            'Cheque' => array(
                array('numeric'),
                array('Model_Accounting_Payments::CheckChequeDetails', array(':validation', ':value')),
            ),
        );
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckTotalPaid($validation, $id) {
        $data = $validation->data();
        $Total = $data['Cash'] + $data['Bank_Transfer'] + $data['ATM'] + $data['Cheque'];
        if (empty($Total)) {
            if (empty($data['discount_percent']) && empty($data['discount_amount'])) {
                $validation->error('Cash', 'All_Fields_Empty');
            }
        }
    }

    public static function CheckChequeDetails($validation, $id) {
        $data = $validation->data();
        if (!empty($data['Cheque'])) {
            if (empty($data['check_bank'])) {
                $validation->error('check_bank', 'Required');
            }
            if (empty($data['check_number'])) {
                $validation->error('check_number', 'Required');
            }
            if (empty($data['check_maturity_date'])) {
                $validation->error('check_maturity_date', 'Required');
            }
        } else {

            if ((!empty($data['check_bank'])) || (!empty($data['check_number'])) || (!empty($data['check_maturity_date']))) {
                $validation->error('Cheque', 'Required');
            }
        }
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CheckStudent($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded() && ($R->user_groub == 3)) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CalculateStudentBalance($Student_Id) {
        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

        $AllPrevCost = 0; //التكلفة الاجمالية السابقة لجميع الفصول التي سجلها الطالب
        $AllPrevTerms = ORM::factory('Students_Terms')
                ->where('student', '=', $Student_Id)
                ->where('is_deleted', '=', NULL)
                ->find_all();
        foreach ($AllPrevTerms as $value) {
            $AllPrevCost+= $value->cost;
        }

        $AllPrevPays = 0; // اجمالي اللي دفعه 
        $AllPrevPayments = ORM::factory('Accounting_Payments')
                ->where('student', '=', $Student_Id)
                ->where('is_deleted', '=', NULL)
                ->find_all();
        foreach ($AllPrevPayments as $value) {
            $AllPrevPays+= $value->Cash + $value->Bank_Transfer + $value->ATM + $value->Cheque;
        }

        return $AllPrevPays - $AllPrevCost;
    }

    public static function CalculateStudentPay($Student_Id, $Term) {
        $Total_Pays = 0;
        $AllPayOnThisTerm = ORM::factory('Accounting_Payments')
                ->where('student', '=', $Student_Id)
                ->where('term', '=', $Term->id)
                ->find_all();
        foreach ($AllPayOnThisTerm as $value) {
            $Total_Pays+= $value->Cash + $value->Bank_Transfer + $value->ATM + $value->Cheque;
        }
        return $Total_Pays;
    }

    public static function Check_min_Payment($Current_Term_Cost, $Term, $student_id) {
        $min_To_pay = $Current_Term_Cost;


        if ($Current_Term_Cost <= 0) {
            $min_To_pay = 0;
            return $min_To_pay;
        } else {
            $Student = ORM::factory('User', $student_id);
            $Student_Profile = $Student->Student_Information;
            $major_orm = $Student_Profile->Major;
            $study_type = $Student_Profile->study_type;
            $student_type = $Student_Profile->student_type;
            $study_degree = $Student_Profile->degree;

            $major = $major_orm->id;
            $college = $major_orm->College->id;

            $Financials_Manminpayment_Custom = ORM::factory('Financials_Manminpayment_Custom')
                    ->where('student', '=', $Student->id)
                    ->where('term', '=', $Term->id)
                    ->where('is_deleted', '=', NULL)
                    ->find();

            if ($Financials_Manminpayment_Custom->loaded()) {
                $mandatory_percent = $Financials_Manminpayment_Custom->mandatory_percent;
                if (!empty($mandatory_percent)) {
                    $min_To_pay = ($mandatory_percent * $Current_Term_Cost) / 100;
                }
            } else {
                $Financials_Manminpayment = ORM::factory('Financials_Manminpayment')
                        ->and_where_open()
                        ->or_where_open()
                        ->where('term', '=', $Term->id)
                        ->where('major', '=', $major)
                        ->or_where_close()
                        ->or_where_open()
                        ->where('term', '=', $Term->id)
                        ->where('degree', '=', $study_degree)
                        ->or_where_close()
                        ->or_where_open()
                        ->where('term', '=', $Term->id)
                        ->where('degree', '=', NULL)
                        ->where('major', '=', NULL)
                        ->or_where_close()
                        ->and_where_close()
                        ->where('is_deleted', '=', NULL)
                        ->find();

                if ($Financials_Manminpayment->loaded()) {
                    $mandatory_percent = $Financials_Manminpayment->mandatory_percent;
                    if (!empty($mandatory_percent)) {
                        $min_To_pay = ($mandatory_percent * $Current_Term_Cost) / 100;
                    }
                }
            }
            return $min_To_pay;
        }
    }

    public static function CalculateTermCost($Student_Id, $Term, $Debugging_mode = FALSE, $lang = 'ar') {

        $study_type = NULL; //مراحل او عادي
        $student_type = NULL; //نوع الطالب
        $study_degree = NULL; //بكالوريوس،ماستر،تحضيري
        $major = NULL; //التخصص
        $college = NULL; //الكلية

        $Total_Price = 0;
        $Debugging_texts = array(
            'notes' => array(),
            'Rules' => array(
                'Only_student_type_determined' => array(
                    'class' => 'not_active',
                    'description' => '',
                ),
                'Only_degree_determined' => array(
                    'class' => 'not_active',
                    'description' => '',
                ),
                'Only_college_determined' => array(
                    'class' => 'not_active',
                    'description' => '',
                ),
                'Only_major_determined' => array(
                    'class' => 'not_active',
                    'description' => '',
                ),
                'Only_course_determined' => array(
                    'class' => 'not_active',
                    'description' => '',
                ),
            ),
        );
        $Student = ORM::factory('User', $Student_Id);
        if ($Student->loaded()) {
            $Student_Profile = ORM::factory('Students_Applications')->where('student_id', '=', $Student->id)->find();
            if ($Student_Profile->loaded()) {
                $major_orm = ORM::factory('Study_Majors', $Student_Profile->major);



                $study_type = $Student_Profile->study_type;
                $student_type = $Student_Profile->student_type;
                $study_degree = $Student_Profile->degree;
                $major = $major_orm->id;
                $college = $major_orm->College->id;

                $Debugging_texts['Rules']['Only_college_determined']['description'] = Lang::__('The student college is') . ': ' . $major_orm->College->{'name_' . $lang};
                $Debugging_texts['Rules']['Only_major_determined']['description'] = Lang::__('The student major is') . ': ' . $major_orm->{'name_' . $lang};
                $Debugging_texts['Rules']['Only_student_type_determined']['description'] = Lang::__('The student type is') . ': ' . $Student_Profile->Student_Type->{'name_' . $lang};
                $Debugging_texts['Rules']['Only_degree_determined']['description'] = Lang::__('The Study degree is') . ': ' . $Student_Profile->Study_Degree->{'name_' . $lang};

                //بداية الحساب
                $student_type_o = ORM::factory('Financials_Fees_Courses')
                        ->where('college', '=', NULL)
                        ->where('student_type', '!=', NULL)
                        ->where('student_type', '=', $student_type)
                        ->where('level', '=', NULL)
                        ->where('major', '=', NULL)
                        ->where('course', '=', NULL)
                        ->where('department', '=', NULL)
                        ->where('degree', '=', NULL)
                        ->where('is_deleted', '=', NULL)
                        ->find();
                //اذا وجد سعر لنوع الطالب فقط يعتبر هو السعر المطلوب
                if ($student_type_o->loaded()) {
                    $Debugging_texts['Rules']['Only_student_type_determined']['class'] = 'active';
                    if ($study_type == 1) {
                        $Total_Price += $student_type_o->level_price;
                    } elseif ($study_type == 2) {
                        $Total_Price += $student_type_o->course_price;
                    }
                } else {
                    $study_degree_o = ORM::factory('Financials_Fees_Courses')
                            ->where('college', '=', NULL)
                            ->where('student_type', '=', NULL)
                            ->where('level', '=', NULL)
                            ->where('major', '=', NULL)
                            ->where('course', '=', NULL)
                            ->where('department', '=', NULL)
                            ->where('degree', '!=', NULL)
                            ->where('degree', '=', $study_degree)
                            ->where('is_deleted', '=', NULL)
                            ->find();
                    //اذا وجد سعر للدرجة فقط يعتبر هو السعر المطلوب
                    if ($study_degree_o->loaded()) {
                        $Debugging_texts['Rules']['Only_degree_determined']['class'] = 'active';
                        if ($study_type == 1) {
                            $Total_Price += $study_degree_o->level_price;
                        } elseif ($study_type == 2) {
                            $Total_Price += $study_degree_o->course_price;
                        }
                    } else {
                        $College_Price = ORM::factory('Financials_Fees_Courses')
                                ->where('college', '!=', NULL)
                                ->where('college', '=', $college)
                                ->where('student_type', '=', NULL)
                                ->where('level', '=', NULL)
                                ->where('major', '=', NULL)
                                ->where('course', '=', NULL)
                                ->where('department', '=', NULL)
                                ->where('degree', '=', NULL)
                                ->where('is_deleted', '=', NULL)
                                ->find();
                        //اذا وجد سعر للكلية فقط يعتبر هو السعر المطلوب
                        if ($College_Price->loaded()) {
                            $Debugging_texts['Rules']['Only_college_determined']['class'] = 'active';
                            if ($study_type == 1) {
                                $Total_Price += $College_Price->level_price;
                            } elseif ($study_type == 2) {
                                $Total_Price += $College_Price->course_price;
                            }
                        } else {
                            $major_Price = ORM::factory('Financials_Fees_Courses')
                                    ->where('college', '=', NULL)
                                    ->where('student_type', '=', NULL)
                                    ->where('level', '=', NULL)
                                    ->where('major', '!=', NULL)
                                    ->where('major', '=', $major)
                                    ->where('course', '=', NULL)
                                    ->where('department', '=', NULL)
                                    ->where('degree', '=', NULL)
                                    ->where('is_deleted', '=', NULL)
                                    ->find();
                            //اذا وجد سعر التخصص فقط يعتبر هو السعر المطلوب
                            if ($major_Price->loaded()) {
                                $Debugging_texts['Rules']['Only_major_determined']['class'] = 'active';
                                if ($study_type == 1) {
                                    $Total_Price += $major_Price->level_price;
                                } elseif ($study_type == 2) {
                                    $Total_Price += $major_Price->course_price;
                                }
                            } else {
                                $AllStudSections = ORM::factory('Students_Sections')
                                        ->where('student', '=', $Student->id)
                                        ->where('term', '=', $Term->id)
                                        ->find_all();
                                foreach ($AllStudSections as $Section) {
                                    $course_Price = ORM::factory('Financials_Fees_Courses')
                                            ->where('college', '=', NULL)
                                            ->where('student_type', '=', NULL)
                                            ->where('level', '=', NULL)
                                            ->where('major', '=', NULL)
                                            ->where('course', '!=', NULL)
                                            ->where('course', '=', $Section->Section->Course->id)
                                            ->where('department', '=', NULL)
                                            ->where('degree', '=', NULL)
                                            ->where('is_deleted', '=', NULL)
                                            ->find();
                                    if ($course_Price->loaded()) {
                                        $Debugging_texts['Rules']['Only_course_determined']['class'] = 'active';
                                        if ($study_type == 1) {
                                            $Total_Price += $course_Price->level_price;
                                        } elseif ($study_type == 2) {
                                            $Total_Price += $course_Price->course_price;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            //فحص في حال وجود خصم للطالب
            $Discount = ORM::factory('Financials_Discount_Students')
                    ->where('student', '=', $Student->id)
                    ->where('term', '=', $Term->id)
                    ->where('is_deleted', '=', NULL)
                    ->find();
            if ($Discount->loaded()) {
                $Amonut_Of_Descount = 0;
                if (!empty($Discount->percent)) {
                    $Amonut_Of_Descount = $Total_Price * $Discount->percent / 100;
                }
                if (!empty($Discount->amount)) {
                    $Amonut_Of_Descount = $Discount->amount;
                }
                array_push($Debugging_texts['notes'], Lang::__('Total student discounts are') . ' ' . $Amonut_Of_Descount);
                $Total_Price-= $Amonut_Of_Descount;
            }
        }
        if ($Debugging_mode) {
            return $Debugging_texts;
        } else {
            return $Total_Price;
        }
    }

}
