<?php

class Model_Accounting_Links extends ORM {

    protected $_table_name = 'accounting_links';
    protected $_belongs_to = array(
        'Account' => array('model' => 'Financials_Accounts', 'foreign_key' => 'account_id'),
    );
    protected $_has_many = array(
       // 'Financials_Payments' => array('model' => 'Financials_Payments', 'foreign_key' => 'Discount'),
    );

    public function rules() {
        return array(
          
        );
    }
    
    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

}
