<?php

class Model_Accounting_Accounts_Trans extends ORM {

    protected $_table_name = 'accounting_accounts_trans';

    public function rules() {
        return array(
            'Gregorian_date' => array(
                array('not_empty'),
                array('date'),
            ),
        );
    }

    /*
     * حاليا الفنكشن يعمل على اضافة قيود فقط وليس تعديلها
     */

    public static function TransToDB($Data_Array, $ORM = NULL, $OnlineUser) {
        $results = array();

        try {
            if (empty($ORM)) {
                $ORM = ORM::factory('Accounting_Accounts_Trans');
            }
            //في حال كان القيد مرحل لا يمكن تعديله
            if (($ORM->loaded() && empty($ORM->Posted)) || !$ORM->loaded()) {

                if ($ORM->loaded()) {
                    $ORM->last_update_by = $OnlineUser->id;
                    $ORM->Last_Modify_date = date("Y-m-d H:i:s");
                } else {
                    $ORM->Created_by = $OnlineUser->id;
                    $ORM->Created_date = date("Y-m-d H:i:s");
                }

                if (isset($Data_Array['Details']) && is_array($Data_Array['Details'])) {
                    $CheckDetails = Model_Accounting_Accounts_Trans::CheckDetails($Data_Array['Details']);
                    if ($CheckDetails === TRUE) {

                        $ORM->branchno = isset($Data_Array['branchno']) ? $Data_Array['branchno'] : NULL;
                        $ORM->transno = isset($Data_Array['transno']) ? $Data_Array['transno'] : NULL;
                        $ORM->transYear = isset($Data_Array['transYear']) ? $Data_Array['transYear'] : NULL;
                        $ORM->BranchSubno = isset($Data_Array['BranchSubno']) ? $Data_Array['BranchSubno'] : NULL;
                        $ORM->Gregorian_date = isset($Data_Array['Gregorian_date']) ? $Data_Array['Gregorian_date'] : NULL;
                        $ORM->Hijri_date = isset($Data_Array['Hijri_date']) ? $Data_Array['Hijri_date'] : NULL;
                        $ORM->amount = isset($Data_Array['amount']) ? $Data_Array['amount'] : NULL;
                        $ORM->Description = isset($Data_Array['Description']) ? $Data_Array['Description'] : NULL;
                        $ORM->Posted = isset($Data_Array['Posted']) ? $Data_Array['Posted'] : NULL;
                        $ORM->Post_By = isset($Data_Array['Post_By']) ? $Data_Array['Post_By'] : NULL;
                        $ORM->PostDate = isset($Data_Array['PostDate']) ? $Data_Array['PostDate'] : NULL;
                        $ORM->Reversedno = isset($Data_Array['Reversedno']) ? $Data_Array['Reversedno'] : NULL;
                        $ORM->ReversedYear = isset($Data_Array['ReversedYear']) ? $Data_Array['ReversedYear'] : NULL;
                        $ORM->ReversedBranch = isset($Data_Array['ReversedBranch']) ? $Data_Array['ReversedBranch'] : NULL;
                        $ORM->CostCenterno = isset($Data_Array['CostCenterno']) ? $Data_Array['CostCenterno'] : NULL;

                        if ($ORM->save()) {
                            $i = 1;
                            $success = 0;
                            foreach ($Data_Array['Details'] as $Detail) {
                                $VaRnAME = 'DetORM' . $i;
                                $$VaRnAME = ORM::factory('Accounting_Accounts_Transdetail');
                                $$VaRnAME->transYear = isset($Detail['transYear']) ? $Detail['transYear'] : NULL;
                                $$VaRnAME->AccYear = isset($Detail['AccYear']) ? $Detail['AccYear'] : NULL;
                                $$VaRnAME->posted = isset($Detail['posted']) ? $Detail['posted'] : NULL;
                                $$VaRnAME->TransNo = $ORM->id;
                                $$VaRnAME->AccNo = isset($Detail['AccNo']) ? $Detail['AccNo'] : NULL;
                                $$VaRnAME->debit = isset($Detail['debit']) ? $Detail['debit'] : NULL;
                                $$VaRnAME->credit = isset($Detail['credit']) ? $Detail['credit'] : NULL;
                                $$VaRnAME->Description = isset($Detail['Description']) ? $Detail['Description'] : NULL;
                                $$VaRnAME->PreDebitBal = isset($Detail['PreDebitBal']) ? $Detail['PreDebitBal'] : NULL;
                                $$VaRnAME->PreCreditBal = isset($Detail['PreCreditBal']) ? $Detail['PreCreditBal'] : NULL;
                                $$VaRnAME->CostCenterno = isset($Detail['CostCenterno']) ? $Detail['CostCenterno'] : NULL;
                                if ($$VaRnAME->save()) {
                                    $success++;
                                }

                                $i++;
                            }
                        }
                    } else {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => General::ArrayToString($CheckDetails)
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('Trans_Details_Not_Inserted')
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('you_cant_modify_posted_trans')
                );
            }
        } catch (ORM_Validation_Exception $e) {
            //لحذف المدخلات التي تم اضافتها في حال حصل خطأ
            $i = 1;
            foreach ($Data_Array['Details'] as $Detail) {
                $VaRnAME = 'DetORM' . $i;
                $$VaRnAME->delete();
            }
            $ORM->delete();
            //End delete records
            $errors = $e->errors('');
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
            );
        }

        if (!array_key_exists('Errors', $results)) {
            $results['Success'] = array(
                'Trans' => $ORM->id,
            );
        }
        return $results;
    }

    public static function CheckDetails($Details) {

        $errors = array();
        $total_debit = 0;
        $total_Credit = 0;
        if (count($Details) <= 0) {
            array_push($errors, Lang::__('Trans_Details_Not_Inserted'));
        }
        foreach ($Details as $Detail) {
            $total_debit += $Detail['debit'];
            $total_Credit += $Detail['credit'];
            if (!is_numeric(intval($Detail['debit']))) {
                array_push($errors, Lang::__('debit_not_numeric'));
            }
            if (!is_numeric(intval($Detail['credit']))) {
                array_push($errors, Lang::__('credit_not_numeric'));
            }
            if (empty($Detail['AccNo'])) {
                array_push($errors, Lang::__('You_must_enter_account'));
            }
            if (empty(intval($Detail['debit'])) && empty(intval($Detail['credit']))) {
                array_push($errors, Lang::__('debit_and_credit_should_not_be_same_0'));
            }
            if (intval($Detail['debit']) > 0 && intval($Detail['credit']) > 0) {
                array_push($errors, Lang::__('debit_of_credit_must_be_equal_0'));
            }
            if (intval($Detail['debit']) < 0 || intval($Detail['credit']) < 0) {
                array_push($errors, Lang::__('You_cant_enter_value_less_than_0'));
            }
        }
        $diff_deb_cre = $total_debit - $total_Credit;
        if ($total_debit <= 0 && $total_Credit <= 0) {
            array_push($errors, Lang::__('You_must_enter_details'));
        } elseif ($diff_deb_cre != 0) {
            array_push($errors, Lang::__('the_difference_between_the_sum_of_the_creditor_and_the_debtor_is_not_equal_to_zero'));
        }

        if (count($errors) > 0) {
            return $errors;
        } else {
            return TRUE;
        }
    }

}
