<?php

class Model_Accounting_Accounts extends ORM {

    protected $_table_name = 'accounting_accounts';
    protected $_belongs_to = array(
        'Parent' => array('model' => 'Accounting_Accounts', 'foreign_key' => 'ParentNo'),
        'Created_User' => array('model' => 'User', 'foreign_key' => 'Created_by'),
        'Bank' => array('model' => 'General_Banks', 'foreign_key' => 'bank'),
    );
    protected $_has_many = array(
        'Childs' => array('model' => 'Accounting_Accounts', 'foreign_key' => 'ParentNo'),
        'Employment_Applications' => array('model' => 'Hr_Employment_Applications', 'foreign_key' => 'account_id'),
        'Stores_Goods_Delivery_Vouchers' => array('model' => 'Stores_Goods_Delivery_Voucher', 'foreign_key' => 'customer'),
        'Stores_Goods_Receipts_Vouchers' => array('model' => 'Stores_Goods_Receipts_Voucher', 'foreign_key' => 'supplier'),
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'AccNo' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
                array(array($this, 'unique'), array('AccNo', ':value')),
            ),
            'AccName_ar' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
                array(array($this, 'unique'), array('AccName_ar', ':value')),
               // array('Model_Rules::arabiandNumbersconly', array(':field', ':validation', ':value')),
            ),
            'AccName_en' => array(
                array('not_empty'),
                array('max_length', array(':value', 255)),
                array(array($this, 'unique'), array('AccName_en', ':value')),
                //array('Model_Rules::englishAndNumbersonly', array(':field', ':validation', ':value')),
            ),
            'ParentNo' => array(
                array(array($this, 'Move_on_account_Happen')),
            ),
            'Selling_price' => array(
                array('numeric'),
            ),
            'CreditLimit' => array(
                array('not_empty'),
                array('numeric'),
            ),
            'AccType' => array(
                array('numeric'),
            ),
        ));
    }

  

    public function Move_on_account_Happen($ParentNo) {
        if (empty($ParentNo)) {
            return TRUE;
        } else {
            $obj = ORM::factory('Accounting_Accounts', $ParentNo);
            $move_happen = Accounts::Move_on_account($obj);
            if ($move_happen === FALSE) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

}
