<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Teacher_Sections extends Controller_Template_Base {

    public $View_Sections = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->View_Sections = $this->Browse_Current_class_schedule = ($this->user_online->IsTeacher() == TRUE);
    }

    public function action_index() {
        if ($this->View_Sections) {
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            if ($Current_Term->loaded()) {
                $title = Lang::__('Sections of') . ' ' . $this->user_online->{'name_' . $this->lang} . ' - ' . $Current_Term->{'name_' . $this->lang};

                $this->template->title = $title;
                $this->template->layout = new View('system/teacher/sections/view_all');
                $this->template->layout->title = $title;
                $this->template->layout->lang = $this->lang;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('undefined_current_term');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        if ($this->View_Sections) {
            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Study_Sections')
                    ->where('is_deleted', '=', NULL)
                    ->where('teacher', '=', $this->user_online->id)
                    ->where('term', '=', ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value))
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['term'])) {
                    $All_ORM->where('term', '=', $post['term']);
                }
                if (!empty($post['course'])) {
                    $All_ORM->where('course', '=', $post['course']);
                }
                if (!empty($post['room'])) {
                    $All_ORM->where('room', '=', $post['room']);
                }
                if (!empty($post['teacher'])) {
                    $All_ORM->where('teacher', '=', $post['teacher']);
                }
                if (!empty($post['gender'])) {
                    if ($post['gender'] == 'n') {
                        $All_ORM->where('gender', '=', NULL);
                    } else {
                        $All_ORM->where('gender', '=', $post['gender']);
                    }
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {


                $Appointments = '';
                $AllCurrentDateOfSection = ORM::factory('Study_Sections_Dates')->where('section', '=', $value->id)->find_all();
                foreach ($AllCurrentDateOfSection as $CurrentSTime) {
                    $Start = explode(':', $CurrentSTime->start);
                    $Stime = '';
                    if (isset($Start[0]) && isset($Start[1])) {
                        $Stime = $Start[0] . ':' . $Start[1];
                    }
                    $EndT = explode(':', $CurrentSTime->end);
                    $Etime = '';
                    if (isset($EndT[0]) && isset($EndT[1])) {
                        $Etime = $EndT[0] . ':' . $EndT[1];
                    }
                    $Appointments .= $CurrentSTime->day . ' ' . $Stime . ' - ' . $Etime . '</br>';
                }

                $buttons = '';
                $buttons .= '<a href="' . URL::base() . 'Teacher_Sections/ViewStudents/' . $value->id . '" class="btn btn-xs yellow">' . Lang::__('view_students') . '</a>';
                $buttons .= '<a href="' . URL::base() . 'Teacher_Educational/Chapters/' . $value->id . '" class="btn btn-xs green">' . Lang::__('Chapters') . '</a>';
                $buttons .= '<a href="' . URL::base() . 'Teacher_Quarterlyplan/index/' . $value->id . '" class="btn btn-xs purple-studio">' . Lang::__('The quarterly plan') . '</a>';

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->Course->{'name_' . $this->lang},
                    $value->Course->course_code,
                    $value->Room->{'name'},
                    $value->section_no,
                    empty($value->gender) ? Lang::__('Male and Female') : $value->Gender->{'name_' . $this->lang},
                    $Appointments,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * View students of section
     */

    public function action_ViewStudents() {
        if ($this->View_Sections) {
            $section = ORM::factory('Study_Sections', $this->request->param('par1'));
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

            if ($Current_Term->loaded() && ($section->term == $Current_Term->id) && ($section->teacher == $this->user_online->id)) {
                $title = Lang::__('view_student_of_section') . ' ' . $section->id;

                $this->template->title = $title;
                $this->template->layout = new View('system/teacher/sections/students_of_section');
                $this->template->layout->title = $title;
                $this->template->layout->lang = $this->lang;
                $this->template->layout->section = $section;
                $this->template->layout->Current_Term = $Current_Term;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * اجاكس عرض طلاب شعبة ما
     */

    public function action_GetStudents() {
        if ($this->View_Sections) {

            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable


            $par1 = !empty($post['par1']) ? $post['par1'] : NULL;

            $Section = ORM::factory('Study_Sections', $par1);
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = $Section->Students_Sections
                    ->where('is_deleted', '=', NULL)
                    ->where('state', '=', 3) //يعني انه مسجل الشعبة
                    ->where('term', '=', ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value))
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
//                if (!empty($post['term'])) {
//                    $All_ORM->where('term', '=', $post['term']);
//                }
//                if (!empty($post['course'])) {
//                    $All_ORM->where('course', '=', $post['course']);
//                }
//                if (!empty($post['room'])) {
//                    $All_ORM->where('room', '=', $post['room']);
//                }
//                if (!empty($post['teacher'])) {
//                    $All_ORM->where('teacher', '=', $post['teacher']);
//                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $Add_Buttons = '';
                $Details_Buttons = '';

                $Add_Buttons .= '<button class="btn btn-xs purple-medium OpenModal" par1="add" student_id="' . $value->student . '" section="' . $value->section . '" type="Participate" data-toggle="modal"> <i class="fa fa-plus"></i> ' . Lang::__('Participate') . '</button>';
                $Add_Buttons .= '<button class="btn btn-xs blue-steel OpenModal" par1="add" student_id="' . $value->student . '" section="' . $value->section . '" type="Infraction" data-toggle="modal"> <i class="fa fa-plus"></i> ' . Lang::__('Infraction') . '</button>';
                $Add_Buttons .= '<button class="btn btn-xs grey-gallery OpenModal" par1="add" student_id="' . $value->student . '" section="' . $value->section . '" type="Note" data-toggle="modal"> <i class="fa fa-plus"></i> ' . Lang::__('Note') . '</button>';
                $Add_Buttons .= '<button class="btn btn-xs grey-salt OpenModal" par1="add" student_id="' . $value->student . '" section="' . $value->section . '" type="Absent" data-toggle="modal"> <i class="fa fa-plus"></i>  ' . Lang::__('Absent') . '</button>';
                
                $CountParticipates = ORM::factory('Students_Participates')->where('student_id', '=', $value->student)->where('section_id', '=', $value->section)->where('is_deleted', '=', NULL)->count_all();
                $CountNotes = ORM::factory('Students_Notes')->where('student_id', '=', $value->student)->where('section_id', '=', $value->section)->where('is_deleted', '=', NULL)->count_all();
                $CountAbsents = ORM::factory('Students_Absents')->where('student_id', '=', $value->student)->where('section_id', '=', $value->section)->where('is_deleted', '=', NULL)->count_all();
                $CountInfractions = ORM::factory('Students_Infractions')->where('student_id', '=', $value->student)->where('section_id', '=', $value->section)->where('is_deleted', '=', NULL)->count_all();
                
                $Details_Buttons .= '<a href="javascript:void(0);" class="btn btn-xs purple-medium Setmonitor">'.Lang::__('Participates').(!empty($CountParticipates)?' ('.$CountParticipates.') ':NULL).'</a>';
                $Details_Buttons .= '<a href="javascript:void(0);" class="btn btn-xs blue-steel Setmonitor">'.Lang::__('Infractions').(!empty($CountInfractions)?' ('.$CountInfractions.') ':NULL).'</a>';
                $Details_Buttons .= '<a href="javascript:void(0);" class="btn btn-xs grey-gallery Setmonitor">'.Lang::__('Notes').(!empty($CountNotes)?' ('.$CountNotes.') ':NULL).'</a>';
                $Details_Buttons .= '<a href="javascript:void(0);" class="btn btn-xs grey-salt Setmonitor">'.Lang::__('Absents').(!empty($CountAbsents)?' ('.$CountAbsents.') ':NULL).'</a>';
                
                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->Student->{'name_' . $this->lang},
                    $Add_Buttons,
                    $Details_Buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * مودل يعرض فورم اضافة او تعديل غياب او مخالفة او مشاركة او ملاحظة
     */

    public function action_AEActivityModal() {

        $id = $this->request->param('id');

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $type = !empty($Filtered_array['type']) ? mb_strtolower($Filtered_array['type']) : NULL;
        $student_id = !empty($Filtered_array['student_id']) ? mb_strtolower($Filtered_array['student_id']) : NULL;
        $section_id = !empty($Filtered_array['section']) ? mb_strtolower($Filtered_array['section']) : NULL;
        $Student = ORM::factory('User', $student_id);
        if (in_array($type, array('participate', 'infraction', 'note', 'absent'))) {

            switch ($type) {
                case 'participate':
                    $Obj = ORM::factory('Students_Participates', $id);
                    break;
                case 'infraction':
                    $Obj = ORM::factory('Students_Infractions', $id);
                    break;
                case 'note':
                    $Obj = ORM::factory('Students_Notes', $id);
                    break;
                case 'absent':
                    $Obj = ORM::factory('Students_Absents', $id);
                    break;

                default:
                    break;
            }

            $process_type = Lang::__('add') . ' ' . Lang::__('participate');
            if ($Obj->loaded()) {
                $process_type = Lang::__('modify');
            }
            if (TRUE) {

                $view = View::factory('system/teacher/activites/AE');
                if ($Obj->loaded()) {
                    $view->set('Obj', $Obj);
                }
                $view->set('title', $process_type);
                $view->set('lang', $this->lang);
                $view->set('type', $type);
                $view->set('Student', $Student);
                $view->set('section_id', $section_id);
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
                $this->response->body($view);
            }
        }
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = empty($Filtered_array['id']) ? NULL : $Filtered_array['id'];
        $type = empty($Filtered_array['type']) ? NULL : $Filtered_array['type'];

        if (in_array($type, array('participate', 'infraction', 'note', 'absent'))) {

            switch ($type) {
                case 'participate':
                    $ORM = ORM::factory('Students_Participates', $id);
                    $results['Rules'] = Model_Students_Participates::TeacherRules($ORM);
                    break;
                case 'infraction':
                    $ORM = ORM::factory('Students_Infractions', $id);
                    $results['Rules'] = Model_Students_Infractions::TeacherRules($ORM);
                    break;
                case 'note':
                    $ORM = ORM::factory('Students_Notes', $id);
                    $results['Rules'] = Model_Students_Notes::TeacherRules($ORM);
                    break;
                case 'absent':
                    $ORM = ORM::factory('Students_Absents', $id);
                    $results['Rules'] = Model_Students_Absents::TeacherRules($ORM);
                    break;

                default:
                    break;
            }

            
        }



        echo json_encode($results);
    }

    /*
     * حفظ المخالفات او الملاحظات او المشاركات او الغيابات للطلبة
     */

    public function action_ActivityToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $id = empty($Filtered_array['id']) ? NULL : $Filtered_array['id'];
        $type = empty($Filtered_array['type']) ? NULL : $Filtered_array['type'];
        $student_id = empty($Filtered_array['student_id']) ? NULL : $Filtered_array['student_id'];
        $section_id = empty($Filtered_array['section_id']) ? NULL : $Filtered_array['section_id'];


        switch ($type) {
            case 'participate':
                $objj = ORM::factory('Students_Participates', $id);
                break;
            case 'infraction':
                $objj = ORM::factory('Students_Infractions', $id);
                break;
            case 'note':
                $objj = ORM::factory('Students_Notes', $id);
                break;
            case 'absent':
                $objj = ORM::factory('Students_Absents', $id);
                break;

            default:
                break;
        }

        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $objj->student_id = $student_id;
            $objj->section_id = $section_id;
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }
        
        $Jquery_Rules = $objj->TeacherRules($objj, $Filtered_array);
        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $Jquery_Rules);
        
        $objj->values($Filtered_array);

        try {
            if ($objj->save($extra_rules)) {


                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

}
