<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Teacher_Quarterlyplan extends Controller_Template_Base {

    public $IsTeacher = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->IsTeacher = $this->Browse_Current_class_schedule = ($this->user_online->IsTeacher() == TRUE);
    }

    public function action_index() {
        if ($this->IsTeacher) {
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            if ($Current_Term->loaded()) {

                //يجب ان تكون الشعبة تتبع للفصل الحالي وغير محذوفة وايضا تتبع لمعلمها
                $Section = ORM::factory('Study_Sections')->where('id', '=', $this->request->param('par1'))->where('teacher', '=', $this->user_online->id)->where('term', '=', $Current_Term->id)->where('is_deleted', '=', NULL)->find();

                if ($Section->loaded()) {
                    $title = Lang::__('chapters of') . ' ' . Lang::__('Section_s') . ' ' . $Section->id . ' (' . $Section->Course->{'name_' . $this->lang} . ')';

                    $this->template->title = $title;
                    $this->template->layout = new View('system/teacher/sections/chapters/view_all');
                    $this->template->layout->title = $title;
                    $this->template->layout->Section = $Section;
                    $this->template->layout->lang = $this->lang;
                } else {
                    $this->template->layout = new View('system/show_msg');
                    $this->template->layout->class_color = 'danger';
                    $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
                }
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('undefined_current_term');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AEChapters() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'Add_new_Chapter';
        $Obj = ORM::factory('Study_Sections_Chapters', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
            $Section = $Obj->Section;
        } else {
            $Section = ORM::factory('Study_Sections')->where('id', '=', $par2)->where('is_deleted', '=', NULL)->find();
        }

        if (($Section->loaded() && $Section->teacher == $this->user_online->id) && ((!$Obj->loaded()) || ($Obj->loaded && ($Obj->is_deleted == NULL)))) {
            $this->template->layout = new View('system/teacher/sections/chapters/AEChapter');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }
            $this->template->layout->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Section = $Section;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }
    
     public function action_ChapterToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Study_Sections_Chapters', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $objj->section_id = $par2;
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }


        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {



                $results['Success'] = array(
                    'title' => Lang::__('Done'),
                    'content' => Lang::__('Saved_successfully'),
                    'redirect' => URL::base().'Teacher_Educational/Chapters/'.$objj->Section->id,
                );
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
            );
        }
        echo json_encode($results);
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Study_Rooms', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

   

    public function action_GetChapters() {
        if ($this->IsTeacher) {
            $post = $this->request->post();
            $Section_id = !empty($post['par1']) ? $post['par1'] : NULL;
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            $Section = ORM::factory('Study_Sections')->where('id', '=', $Section_id)->where('teacher', '=', $this->user_online->id)->where('term', '=', $Current_Term->id)->where('is_deleted', '=', NULL)->find();
            if ($Section->loaded()) {
                $order = $post['order']; //Get how table order from datatable
                /*
                 * All coulums will shown in table
                 */
                $ALL_coulums = array(
                    1 => "id",
                );

                $All_ORM = $Section->Chapters
                        ->where('is_deleted', '=', NULL)
                        ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


                $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
                $C_Acti_status = "OK";

                /*
                 * If Action exists
                 */
                if (isset($post['customActionName'])) {
                    switch ($post['customActionName']) {
                        case 'Delete':

                            break;


                        default:
                            break;
                    }
                }


                /*
                 * if search exists
                 */
                if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
              
                }

                /*
                 * Paging
                 */
                $All_ORM->reset(FALSE);
                $iTotalRecords = $All_ORM->count_all();

                $iDisplayLength = intval($post['length']);
                $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
                $iDisplayStart = intval($post['start']);
                $sEcho = intval($post['draw']);

                $records = array();
                $records["data"] = array();

                $end = $iDisplayStart + $iDisplayLength;
                $end = $end > $iTotalRecords ? $iTotalRecords : $end;

                $All_ORM->offset($iDisplayStart);
                $All_ORM->limit($iDisplayLength);


                /*
                 * Prepare JSON Array
                 */
                foreach ($All_ORM->find_all() as $value) {
                    $buttons = '';

                    $records["data"][] = array(
                        '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                        $value->name,
                        $value->description,
                        $buttons,
                    );
                }
                if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                    $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                    $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
                }

                $records["draw"] = $sEcho;
                $records["recordsTotal"] = $iTotalRecords;
                $records["recordsFiltered"] = $iTotalRecords;

                echo json_encode($records);
            }
        }
    }

}
