<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Teacher_Counseling extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Browse_Current_class_schedule = FALSE;
    public $Approve_nonReg_Section_For_Student = FALSE;
    public $Delete_section_prior_to_the_adoption = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        //$this->Add = ($this->user_online->IsTeacher()) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Students_Types')));
        $this->Browse = ($this->user_online->IsTeacher()) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Students_Types')));
        //$this->Edit = ($this->user_online->IsTeacher()) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Students_Types')));
        //$this->Delete = ($this->user_online->IsTeacher()) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Students_Types')));

        $this->Browse_Current_class_schedule = ($this->user_online->IsTeacher() == TRUE) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_Current_class_schedule')));
        $this->Approve_nonReg_Section_For_Student = ($this->user_online->IsTeacher() == TRUE) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Approve_nonReg_Section_For_Student')));
        $this->Delete_section_prior_to_the_adoption = ($this->user_online->IsTeacher() == TRUE) ? TRUE : $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_section_prior_to_the_adoption')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Counseling');
            $this->template->title = $title;
            $this->template->layout = new View('system/teacher/counseling/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Current_class_schedule() {

        $par1 = mb_strtolower($this->request->param('par1')); // StudentUsername

        $Obj = ORM::factory('User')
                ->where(DB::expr('lower(username)'), '=', mb_strtolower($par1))
                ->find();
        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

        if (($this->Browse_Current_class_schedule || $this->Approve_nonReg_Section_For_Student || $this->Delete_section_prior_to_the_adoption) && $Obj->loaded() && ($Obj->Student_Information->academic_supervisor == $this->user_online->id) && $Current_Term->loaded() && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/teacher/counseling/Current_class_schedule');

            $this->template->layout->Obj = $Obj;
            $title = $Obj->{'name_' . $this->lang};
            $this->template->layout->title = $title;
            $this->template->layout->Student_Info = $Obj->Student_Information;
            $this->template->title = $title;

            $this->template->layout->Current_Term = $Current_Term;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }



    public function action_Custom_Student_Hour() {

        $par1 = mb_strtolower($this->request->param('par1')); // StudentUsername

        $Obj = ORM::factory('User')
                ->where(DB::expr('lower(username)'), '=', mb_strtolower($par1))
                ->find();
        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

        if (($this->Browse_Current_class_schedule) && $Obj->loaded() && ($Obj->Student_Information->academic_supervisor == $this->user_online->id) && $Current_Term->loaded() && ($Obj->is_deleted == NULL)) {

            $this->template->layout = new View('system/teacher/counseling/custom_student_hour');

            $this->template->layout->Obj = $Obj;
            $title = $Obj->{'name_' . $this->lang};
            $this->template->layout->title = $title;
            $this->template->layout->Student_Info = $Obj->Student_Information;
            $this->template->title = $title;

            $this->template->layout->Current_Term = $Current_Term;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetStudentSections() {

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $Student = ORM::factory('User')
                ->where(DB::expr('lower(user.username)'), '=', mb_strtolower($par1))
                ->find();
        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

        if (($this->Browse_Current_class_schedule || $this->Approve_nonReg_Section_For_Student || $this->Delete_section_prior_to_the_adoption) && $Student->loaded() && ($Student->Student_Information->academic_supervisor == $this->user_online->id) && $Current_Term->loaded() && ($Student->is_deleted == NULL)) {

            $AllStudSections = ORM::factory('Students_Sections')
                    ->where('is_deleted', '=', NULL)
                    ->where('student', '=', $Student->id)
                    ->where('term', '=', $Current_Term->id)
                    ->find_all();
            $AllRegSecIds = array(0);
            $Approved_Sections = 0;
            foreach ($AllStudSections as $value) {
                array_push($AllRegSecIds, $value->section);

                if ($value->state == 2) {
                    $Approved_Sections++;
                }
            }


            $post = $this->request->post();
            $order = isset($post['order']) ? $post['order'] : NULL; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Study_Sections')
                    ->where('id', 'IN', $AllRegSecIds)
                    ->where('is_deleted', '=', NULL);

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['term'])) {
                    $All_ORM->where('term', '=', $post['term']);
                }
                if (!empty($post['course'])) {
                    $All_ORM->where('course', '=', $post['course']);
                }
                if (!empty($post['room'])) {
                    $All_ORM->where('room', '=', $post['room']);
                }
                if (!empty($post['teacher'])) {
                    $All_ORM->where('teacher', '=', $post['teacher']);
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $Appointments = '';
                $AllCurrentDateOfSection = ORM::factory('Study_Sections_Dates')->where('section', '=', $value->id)->find_all();
                foreach ($AllCurrentDateOfSection as $CurrentSTime) {
                    $Start = explode(':', $CurrentSTime->start);
                    $Stime = '';
                    if (isset($Start[0]) && isset($Start[1])) {
                        $Stime = $Start[0] . ':' . $Start[1];
                    }
                    $EndT = explode(':', $CurrentSTime->end);
                    $Etime = '';
                    if (isset($EndT[0]) && isset($EndT[1])) {
                        $Etime = $EndT[0] . ':' . $EndT[1];
                    }
                    $Appointments.= $CurrentSTime->day . ' ' . $Stime . ' - ' . $Etime . '</br>';
                }
                $buttons = '';

                $StudSections = ORM::factory('Students_Sections')
                        ->where('student', '=', $Student->id)
                        ->where('term', '=', $Current_Term->id)
                        ->where('section', '=', $value->id)
                        ->where('is_deleted', '=', NULL)
                        ->find();

                if ($StudSections->state == NULL) {
                    $buttons.= '<span class="font-red-haze">' . Lang::__('No request for advice') . '</span>';
                } elseif ($StudSections->state == 1) {
                    $buttons.='<button par1="' . $value->id . '" par2="' . $Student->id . '" class="btn btn-sm green Approve"><i class="fa fa-check"></i> ' . Lang::__('Approve') . ' </button>';
                    //$buttons.='<a par1="' . $value->id . '" par2="' . $Student->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_reject_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-sm red Delete"> ' . Lang::__('Reject') . '</a>';
                    $buttons .= '<button type="button" class="btn btn-sm red-mint ReJectSection" par1="' . $StudSections->id . '" Dtitle="' . Lang::__('confirmation') . '" Dcontent="' . Lang::__('If you wish to continue with the reject section').' <span class=\'font-green-soft font-lg\'>'.$value->Course->{'name_'.$this->lang} .'</span> '.Lang::__('For_Student').' <span class=\'font-purple-seance font-lg\'>'.$Student->{'name_'.$this->lang}.'</span> '.Lang::__('Click submit you can also leave a note in the field below') . '" PHold="'.Lang::__('Notes').'" Submit_Btn="'.Lang::__('Reject').'" Cancel_Btn="' . Lang::__('Cancel') . '"> ' . Lang::__('Reject') . '</button>';
                    
                } elseif ($StudSections->state == 2) {
                    $buttons.='<a par1="' . $value->id . '" par2="' . $Student->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-sm red Delete"> ' . Lang::__('Delete') . '</a>';
                } elseif ($StudSections->state == 3) {
                    $buttons.= '<span class="font-green-jungle">' . Lang::__('Registered') . '</span>';
                }elseif ($StudSections->state == 4) {
                    $buttons.= '<span class="font-red-thunderbird">' . Lang::__('rejected_by') .' '.$StudSections->Rejecter->{'name_'.$this->lang}.'. '.Lang::__('Note').': '.$StudSections->rejected_note. '</span>';
                }



                $Course = ORM::factory('Study_Courses', $value->course);
                $records["data"][] = array(
                    $value->section_no,
                    ORM::factory('Study_Majors', $value->major)->{'name_' . $this->lang},
                    $Course->{'name_' . $this->lang},
                    $Course->course_code,
                    $value->Teacher->{"name_".$this->lang},
                    $Course->credit_hours,
                    $Appointments,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;







            echo json_encode($records);
        }
    }

    public function action_DeleteSectionRel() {
        $results = array();

        if ($this->Delete_section_prior_to_the_adoption) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

            $Student_id = $Filtered_array['student'];

            $Obj = ORM::factory('Study_Sections', $Filtered_array['id']);
            if ($Obj->loaded()) {
                $StudSections = ORM::factory('Students_Sections')
                        ->where('is_deleted', '=', NULL)
                        ->where('student', '=', $Student_id)
                        ->where('term', '=', $Current_Term->id)
                        ->where('section', '=', $Obj->id)
                        ->find();
                if ($StudSections->loaded()) {
                    if ($StudSections->state == NULL || $StudSections->state == 1 || $StudSections->state == 2) {
                        $StudSections->rejected_by = $this->user_online->id;
                        $StudSections->rejected_date = date("Y-m-d H:i:s");
                        $StudSections->state = 4;
                        if ($StudSections->update()) {
                            $results['Resp'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => Lang::__('Deletion has been successfully'),
                                'life' => '2000', //1000 is 1 second
                                'text' => '',
                            );
                        }
                    } elseif ($StudSections->state == 3) {
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('You can not delete section'),
                        );
                    }
                } else {
                    $results['Resp'] = array(
                        'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Error'),
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Not_found_the_desired_item'),
                    );
                }
            } else {
                $results['Resp'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Error'),
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
        echo json_encode($results);
    }

    public function action_ApproveSection() {
        $results = array();

        if ($this->Approve_nonReg_Section_For_Student) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

            $Student_id = $Filtered_array['student'];

            $Obj = ORM::factory('Study_Sections', $Filtered_array['id']);
            if ($Obj->loaded()) {
                $StudSections = ORM::factory('Students_Sections')
                        ->where('is_deleted', '=', NULL)
                        ->where('student', '=', $Student_id)
                        ->where('term', '=', $Current_Term->id)
                        ->where('section', '=', $Obj->id)
                        ->find();
                if ($StudSections->loaded()) {
                    if ($StudSections->state == NULL || $StudSections->state == 1) {
                        $StudSections->state = 2;

                        if ($StudSections->update()) {
                            $results['Resp'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => Lang::__('Section has been approved successfully'),
                                'life' => '2000', //1000 is 1 second
                                'text' => '',
                            );
                        }
                    } elseif ($StudSections->state == 3 || $StudSections->state == 2) {
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('This section had been approved'),
                        );
                    }elseif ($StudSections->state == 4) {
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('This section is rejected in advance'),
                        );
                    }
                } else {
                    $results['Resp'] = array(
                        'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Error'),
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Not_found_the_desired_item'),
                    );
                }
            } else {
                $results['Resp'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Error'),
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Students_Applications')
                ->where('academic_supervisor', '=', $this->user_online->id)
                ->where('students_applications.is_deleted', '=', NULL)
                ->order_by('students_applications.' . $ALL_coulums[$order[0]['column']], $order[0]['dir'])
                ->with("User")
        ;


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $ids = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_Delete($value) === FALSE) {
                            array_push($ids, $value);
                        }
                    }

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (isset($post['name'])) {
                $Name = $post['name'];
                $All_ORM->where(DB::expr('lower(Full_Name_Arabic)'), 'LIKE', mb_strtolower("%$Name%"));
            }
            if (isset($post['student_id'])) {
                $student_id = $post['student_id'];
                $All_ORM->where(DB::expr('lower(User.username)'), 'LIKE', mb_strtolower("%$student_id%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;



        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Browse_Current_class_schedule) ? $buttons.='<a href="' . URL::base() . 'Teacher_Counseling/Current_class_schedule/' . $value->User->username . '" class="btn btn-xs default"><i class="fa fa-table"></i> ' . Lang::__('Current_class_schedule') . '</a>' : NULL;

            ($this->Browse_Current_class_schedule) ? $buttons.='<a href="' . URL::base() . 'Teacher_Counseling/Custom_Student_Hour/' . $value->User->username . '" class="btn btn-xs blue"><i class="fa fa-arrow-circle-o-up"></i> ' . Lang::__('Custom_Student_Hour') . '</a>' : NULL;


            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->User->username,
                $value->User->{'name_' . $this->lang},
                Lang::__("undefined"),
                $Current_Term->{'name_'.$this->lang},
                $value->User->Student_Information->Major->{'name_'.$this->lang},
                $value->User->Student_Information->Study_Degree->{'name_'.$this->lang},
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }
    
    
    public function action_ReJectSection() {
        $results = array();

        if ($this->Browse_Current_class_schedule) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            
            $par1 = isset($Filtered_array['par1'])?$Filtered_array['par1']:NULL;
            $notes = isset($Filtered_array['notes'])?$Filtered_array['notes']:NULL;
            
                $StudSections = ORM::factory('Students_Sections')
                        ->where('is_deleted', '=', NULL)
                        ->where('id', '=', $par1)
                        ->find();
                if ($StudSections->loaded()) {
                    if ($StudSections->state == NULL || $StudSections->state == 1) {
                        $StudSections->state = 4;
                        $StudSections->rejected_by = $this->user_online->id;
                        $StudSections->rejected_date = date("Y-m-d H:i:s");
                        $StudSections->rejected_note = $notes;

                        if ($StudSections->update()) {
                            $results['Resp'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => Lang::__('Section has been rejected successfully'),
                                'life' => '2000', //1000 is 1 second
                                'text' => '',
                            );
                        }
                    } elseif ($StudSections->state == 3 || $StudSections->state == 2) {
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('This section had been approved'),
                        );
                    }elseif ($StudSections->state == 4) {
                        $results['Resp'] = array(
                            'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => Lang::__('Error'),
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('This section is rejected in advance'),
                        );
                    }
                } else {
                    $results['Resp'] = array(
                        'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Error'),
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Not_found_the_desired_item'),
                    );
                }
            
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
        echo json_encode($results);
    }

}
