<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Tags extends Controller_Template_Site {

    public function action_view() {
        $GET_V = Search::action_Filtered_array($this->request->query());

        $tag_id = $this->request->param('par1');
        $T = ORM::factory('Tags', $tag_id);
        if ($T->loaded()) {
            $Tags = ORM::factory('Relations')
                    ->where('description', '=', 'Advs_Tags')
                    ->where('tag', '=', $tag_id)
                    ->find_all();
            $adv_array = array();
            foreach ($Tags as $value) {
                array_push($adv_array, $value->Advs);
            }
            ////////////////////
            //first calc average count
            $Advs = ORM::factory('Advs');
            $Advs->where('id', 'IN', $adv_array);
            $Advs->where('is_active', '=', 1);
            $Advs->where('Show_for_Visitors', '=', 1);
            $Advs->and_where_open();
            $Advs->or_where('expiration_date', '>=', date("Y-m-d"));
            $Advs->or_where('expiration_date', '=', NULL);
            $Advs->and_where_close();

            $Advs->reset(FALSE); // useful to keep the existing query conditions for another query
            //you can change items_per_page
            $num = ORM::factory('Variables', 17)->value;

            //you can configure routes and custom routes params
            $pagination = Pagination::factory(array(
                        'total_items' => $Advs->count_all(),
                        'items_per_page' => $num,
                            //'current_page'   => Request::current()->param("page"),
                            )
                    )->route_params(array(
                'directory' => Request::current()->directory(),
                'controller' => Request::current()->controller(),
                'action' => Request::current()->action(),
                "par1" => NULL,
                "par2" => NULL,
                    )
            );
            //now select from your DB using calculated offset
            $ToShowAdvs = $Advs->order_by("id", "DESC")
                    ->limit($pagination->items_per_page)
                    ->offset($pagination->offset)
                    ->find_all();

            ////////////////////
            $this->template->layout = new View('site/Tags');
            $this->template->layout->Advs = $ToShowAdvs;
            $this->template->layout->pagination = $pagination;

            $this->template->layout->T = $T;
            $this->template->layout->Tags = $Tags;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->title = Lang::__('error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

}

// End Tags
