<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Students_Interviews extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        //$this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Students_Interviews')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Students_Interviews')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Students_Interviews')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Students_Interviews')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Students_Interviews');
            $this->template->title = $title;
            $this->template->layout = new View('system/students/interviews/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Students_Applications')
                ->where('interview_date', '!=', NULL)
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (!empty($post['interview_date_From'])) {
                $All_ORM->where('interview_date', '>=', $post['interview_date_From']);
            }
            if (!empty($post['interview_date_to'])) {
                $new_interview_date_to = new DateTime($post['interview_date_to']);
                $new_interview_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('interview_date', '<=', $new_interview_date_to->format('Y-m-d H:i:s'));
            }
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(Full_Name_Arabic)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(Full_Name_English)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['ba_GPA'])) {
                $ba_GPA = $post['ba_GPA'];
                $All_ORM->where(DB::expr('lower(ba_GPA)'), 'LIKE', mb_strtolower("%$ba_GPA%"));
            }
            if (!empty($post['ba_Major'])) {
                $ba_Major = $post['ba_Major'];
                $All_ORM->where(DB::expr('lower(ba_Major)'), 'LIKE', mb_strtolower("%$ba_Major%"));
            }
        }


        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);

        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit && empty($value->interview_state)) ? $buttons .= '<a href="' . URL::base() . 'Students_Interviews/Review/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Review') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteInterview() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_cancel_int_date_and_cancel_approval') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Cancel the interview date') . '</a>' : NULL;

            $InterviewState = NULL;
            if (!empty($value->interview_state)) {
                if ($value->interview_state == 'reject') {
                    $InterviewState = Lang::__('The request was rejected after the interview');
                } elseif ($value->interview_state == 'accept' && !empty($value->student_id)) {
                    $InterviewState = Lang::__('The request was accepted after the interview and student now have membership');
                }
            }
            $buttons .= $InterviewState;
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->Full_Name_Arabic,
                $value->Full_Name_English,
                $value->ba_Major,
                $value->ba_GPA,
                $value->interview_date,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_Review() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $Obj = ORM::factory('Students_Applications', $par1);

        if (($this->Edit) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/students/interviews/Review');
            $this->template->layout->title = Lang::__('Students_Interviews') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->title = Lang::__('Students_Interviews') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->layout->Obj = $Obj;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_ReviewToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        $themam = ORM::factory('Accounting_Links', 4); //ذمم الطلاب
        $Okhra = ORM::factory('Accounting_Links', 3); //ايرادات الاخرى
        if ($themam->loaded() && !empty($themam->account_id) && $Okhra->loaded() && !empty($Okhra->account_id)) {
            $objj = ORM::factory('Students_Applications', $par1);
            if ($objj->loaded()) {
                $objj->values($Filtered_array);
                try {
                    $extra_rules = Validation::factory($Filtered_array);
                    $extra_rules->rule('interview_state', 'not_empty');

                    if ($objj->save($extra_rules)) {
                        if ($objj->interview_state == 'reject') {
                            //تسجيل العملية في سجلات التقارير
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 5;
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();


                            $objj->id_can_order_other = 1;
                            $objj->update();

                            $note_type = 'note-success';
                            $text = Lang::__('Admission application rejected for student') . ' (' . $objj->Full_Name_Arabic . ') ';
                        } elseif ($objj->interview_state == 'accept') {
                            if (empty($objj->student_id)) {


                                //اذا ما في مقابلة، يتم انشاء عضوية للطالب مباشرة
                                $Groub = ORM::factory('Usersgroub', 3); // Student
                                $password = Text::random('nozero', rand(8, 8));

                                $username = $objj->GenerateAcadimicNo();

                                $User = ORM::factory('User');
                                $User->username = $username;
                                $User->password = $password;
                                $User->email = $objj->Email;
                                $User->user_groub = $Groub->id;
                                $User->name_ar = $objj->Full_Name_Arabic;
                                $User->name_en = $objj->Full_Name_English;
                                $User->Created_by = $this->user_online->id;
                                $User->Created_date = date("Y-m-d H:i:s");
                                if ($User->save()) {
                                    // Grant user login role
                                    $User->add('roles', ORM::factory('Role', array('name' => 'login')));

                                    $objj->Initial_Approval = 2;
                                    $objj->student_id = $User->id;
                                    $objj->password = $password;
                                    if ($objj->app_type == 'ba') {
                                        $objj->level = ORM::factory('Variables', 79)->value;
                                    } elseif ($objj->app_type == 'ma') {
                                        $objj->level = ORM::factory('Variables', 80)->value;
                                    }
                                    if ($objj->save()) {
                                        //تسجيل العملية في سجلات التقارير
                                        $Log = ORM::factory('Students_Logs');
                                        $Log->operation = 6;
                                        $Log->ref_id = $objj->id;
                                        $Log->ref1_id = $User->id;
                                        $Log->Created_by = $this->user_online->id;
                                        $Log->Created_date = date("Y-m-d H:i:s");
                                        $Log->save();

                                        $note_type = 'note-success';
                                        $text = Lang::__('The membership of the new student to the student creation') . ' (' . $objj->Full_Name_Arabic . ') ' . Lang::__('The user name is') . ' (' . $username . ') ' . Lang::__('The password is') . ' (' . $password . ') ';
                                    }
                                }
                            }
                        }

                        $results['Success'] = array(
                            'note_type' => (isset($note_type)) ? $note_type : 'note-danger',
                            'text' => (isset($text)) ? $text : Lang::__('An error occurred while trying to process the request'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Students claims are not linked to any accounting account')
            );
        }

        echo json_encode($results);
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Students_Applications', $Filtered_array['id']);

            $CheckDeleteInterview = $Obj->CheckDeleteInterview();
            if ($CheckDeleteInterview === TRUE) {
                try {
                    $Obj->Initial_Approval = 1;
                    $Obj->interview_date = NULL;
                    $Obj->interview_state = NULL;
                    $Obj->interview_notes = NULL;
                    if ($Obj->save()) {
                        //تسجيل العملية في سجلات التقارير
                        $Log = ORM::factory('Students_Logs');
                        $Log->operation = 17;
                        $Log->ref_id = $Obj->id;
                        $Log->Created_by = $this->user_online->id;
                        $Log->Created_date = date("Y-m-d H:i:s");
                        $Log->save();
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Interview date has been deleted successfully, and thus were canceled principled consent request student admission'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteInterview)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteInterview),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

}
