<?php

defined('SYSPATH') or die('No direct script access.');
require DOCROOT . 'classes/PhpSpreadsheet/autoload.php';

class Controller_Students_Admissionapps extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Reject_Student_Applications = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        //$this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Admission_Applications')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Admission_Applications')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Admission_Applications')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Admission_Applications')));
        $this->Reject_Student_Applications = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Reject_Student_Applications')));
    }

    public function action_excel_non_complete_app() {

        $headerstyleArray = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'top' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ),
            ),
        );

        $NormalstyleArray = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'top' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ),
            ),
        );

        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $worksheet = $spreadsheet->getActiveSheet();

        $Feilds = array(
            1 => 'Created_date',
            2 => 'app_id',
            3 => 'app_password',
            4 => 'Full_Name_Arabic',
            5 => 'Full_Name_English',
            6 => 'Mobile',
            7 => 'Phone',
            8 => 'Email',
            9 => 'Address',
            10 => 'ip_of_application',
            11 => 'ID_No',
            12 => 'browser',
            13 => 'os',
            14 => 'device',
            15 => 'stepA',
            16 => 'stepB',
            17 => 'stepC',
            18 => 'stepD',
            19 => 'stepE',
            20 => 'stepF',
        ); //To Start Keys From 1 not 0

        foreach ($Feilds as $key => $value) {
            $alphapet = General::getNameFromNumber($key);
            if($value == "stepA"){
                $nn = 'A - '. Lang::__('Applicant info');
            }elseif($value == "stepB"){
                $nn = 'B - '. Lang::__('Sponsor information');
            }elseif($value == "stepC"){
                $nn = 'C - '. Lang::__('Study History');
            }elseif($value == "stepD"){
                $nn = 'D - '. Lang::__('Gardian information');
            }elseif($value == "stepE"){
                $nn = 'E - '. Lang::__('Employment information');
            }elseif($value == "stepF"){
                $nn = 'F - '. Lang::__('Required documents');
            }
            else{
                $nn = Lang::__($value);
            }
            $worksheet->getCell($alphapet . '1')->setValue($nn)->getStyle($alphapet . '1')->applyFromArray($headerstyleArray);
            $Feilds[$alphapet] = $value; //To change key to alphapet
            unset($Feilds[$key]);
        }

        $Students_Applications = ORM::factory('Students_Applications')->where('finished', '=', NULL)->find_all();
        $k = 2;
        foreach ($Students_Applications as $Attendance) {
            $User = $Attendance->User;
            $Rejected_By = $Attendance->Rejected_By;
            $Student_Type = $Attendance->Student_Type;
            foreach ($Feilds as $alpha => $col_name) {
                if ($col_name == 'code') {
                    $val = $Attendance->$col_name;
                } elseif ($col_name == 'username') {
                    $val = $User->username;
                } elseif ($col_name == 'finished') {
                    $val = empty($Attendance->finished) ? Lang::__('No') : Lang::__('Yes');
                }elseif ($col_name == 'is_deleted') {
                    $val = empty($Attendance->is_deleted) ? Lang::__('No') : Lang::__('Yes').' - '.$Attendance->deleted_By->{'name_'.$this->lang}.' ('.$Attendance->deleted_date.')';
                } elseif ($col_name == 'study_type') {
                    $val = $Attendance->Study_Type->{'name_' . $this->lang};
                } elseif ($col_name == 'student_type') {
                    $val = $Student_Type->{'name_' . $this->lang};
                } elseif ($col_name == 'degree') {
                    $val = $Attendance->Study_Degree->{'name_' . $this->lang};
                } elseif ($col_name == 'level') {
                    $val = $Attendance->Level->{'name_' . $this->lang};
                }elseif ($col_name == 'Nationality') {
                    $val = $Attendance->Nationalitie->{'name_' . $this->lang};
                }elseif ($col_name == 'major') {
                    $val = $Attendance->Major->{'name_' . $this->lang};
                }elseif ($col_name == 'academic_supervisor') {
                    $val = $Attendance->Academic_Supervisor->{'name_' . $this->lang};
                } elseif ($col_name == 'amount_paid') {
                }elseif ($col_name == 'academic_supervisor') {
                    $val = $Attendance->Academic_Supervisor->{'name_' . $this->lang};
                } elseif ($col_name == 'amount_paid') {
                    if ($Attendance->amount_paid == 1) {
                        $val = Lang::__('No');
                    } elseif ($Attendance->amount_paid == 2) {
                        $val = Lang::__('Yes');
                    }
                }elseif ($col_name == 'Initial_Approval') {
                    if ($Attendance->Initial_Approval == 1) {
                        $val = Lang::__('No');
                    } elseif ($Attendance->Initial_Approval == 2) {
                        $val = Lang::__('Yes');
                    }
                }elseif (in_array($col_name,array('stepA','stepB','stepC','stepD','stepE','stepF'))) {
                    switch ($col_name) {
                        case 'stepA':
                            $Str_Alph = "A";
                        break;
                        case 'stepB':
                            $Str_Alph = "B";
                            break;
                        case 'stepC':
                            $Str_Alph = "C";
                            break;
                        case 'stepD':
                            $Str_Alph = "D";
                            break;
                        case 'stepE':
                            $Str_Alph = "E";
                            break;
                        case 'stepF':
                            $Str_Alph = "F";
                            break;
                        default:
                    }

                    $St = ORM::factory('Students_Applications_Steps')->where('step','=',$Str_Alph)->where("student_application_id","=",$Attendance->id)->find();

                    //$St =  $Attendance->Steps_Finished->where('step','=',$Str_Alph)->find();

                   if($St->loaded()){
                       $val = 'تم تقديم البيانات بتاريخ ' . $St->Created_date;
                   }else{
                       $val = 'غير مكتمل';
                   }

                } else {
                    $val = $Attendance->$col_name;
                }

                $worksheet->getCell($alpha . $k)->setValue($val)->getStyle($alpha . $k)->applyFromArray($NormalstyleArray);
            }

            $k++;
        }
        foreach ($Feilds as $alpha => $col_name) {
            $worksheet->getColumnDimension($alpha)->setAutoSize(true);
        }

        $Success_Files = array();
        $directory = 'files/reports/' . date('Y') . '/' . date("m") . '/';
        $directory_D = DOCROOT . str_replace("\\", "/", $directory);
        if (!file_exists($directory_D)) {
            mkdir($directory_D, 0777, true);
        }
        $ext = 'xlsx';
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, ucfirst($ext));

        if ($writer->save($directory . $filename) === NULL) {
            $date_to_delete = date('Y-m-d', strtotime(date('Y-m-d') . ' + 90 days'));
            echo $directory . $filename;
        }



        $spreadsheet->disconnectWorksheets(); //Clearing a Workbook from memory
        unset($spreadsheet); //Clearing a Workbook from memory
    }

    public function action_excel() {

        $headerstyleArray = array(
            'font' => array(
                'bold' => true,
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'top' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ),
            ),
        );

        $NormalstyleArray = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'top' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ),
            ),
        );

        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $worksheet = $spreadsheet->getActiveSheet();

        $Feilds = array(
            1 => 'app_id',
            2 => 'Full_Name_Arabic',
            3 => 'Full_Name_English',
            4 => 'username',
            5 => 'finished',
            6 => 'study_type',
            7 => 'student_type',
            8 => 'degree',
            9 => 'level',
            10 => 'amount_to_pay',
            11 => 'amount_paid',
            12 => 'Cash',
            13 => 'Bank_Transfer',
            14 => 'ATM',
            15 => 'Cheque',
            16 => 'major',
            17 => 'academic_supervisor',
            18 => 'Initial_Approval',
            19 => 'ip_of_application',
            20 => 'Academic_Number',
            21 => 'ID_No',
            22 => 'Nationality',
            23 => 'browser',
            24 => 'os',
            25 => 'device',
            26 => 'is_deleted',
        ); //To Start Keys From 1 not 0

        foreach ($Feilds as $key => $value) {
            $alphapet = General::getNameFromNumber($key);

            $worksheet->getCell($alphapet . '1')->setValue(Lang::__($value))->getStyle($alphapet . '1')->applyFromArray($headerstyleArray);
            $Feilds[$alphapet] = $value; //To change key to alphapet
            unset($Feilds[$key]);
        }

        $Students_Applications = ORM::factory('Students_Applications')->where('app_type', '=', 'ba')->find_all();
        $k = 2;
        foreach ($Students_Applications as $Attendance) {
            $User = $Attendance->User;
            $Rejected_By = $Attendance->Rejected_By;
            $Student_Type = $Attendance->Student_Type;
            foreach ($Feilds as $alpha => $col_name) {
                if ($col_name == 'code') {
                    $val = $Employee->$col_name;
                } elseif ($col_name == 'username') {
                    $val = $User->username;
                } elseif ($col_name == 'finished') {
                    $val = empty($Attendance->finished) ? Lang::__('No') : Lang::__('Yes');
                }elseif ($col_name == 'is_deleted') {
                    $val = empty($Attendance->is_deleted) ? Lang::__('No') : Lang::__('Yes').' - '.$Attendance->deleted_By->{'name_'.$this->lang}.' ('.$Attendance->deleted_date.')';
                } elseif ($col_name == 'study_type') {
                    $val = $Attendance->Study_Type->{'name_' . $this->lang};
                } elseif ($col_name == 'student_type') {
                    $val = $Student_Type->{'name_' . $this->lang};
                } elseif ($col_name == 'degree') {
                    $val = $Attendance->Study_Degree->{'name_' . $this->lang};
                } elseif ($col_name == 'level') {
                    $val = $Attendance->Level->{'name_' . $this->lang};
                }elseif ($col_name == 'Nationality') {
                    $val = $Attendance->Nationalitie->{'name_' . $this->lang};
                }elseif ($col_name == 'major') {
                    $val = $Attendance->Major->{'name_' . $this->lang};
                }elseif ($col_name == 'academic_supervisor') {
                    $val = $Attendance->Academic_Supervisor->{'name_' . $this->lang};
                } elseif ($col_name == 'amount_paid') {
                }elseif ($col_name == 'academic_supervisor') {
                    $val = $Attendance->Academic_Supervisor->{'name_' . $this->lang};
                } elseif ($col_name == 'amount_paid') {
                    if ($Attendance->amount_paid == 1) {
                        $val = Lang::__('No');
                    } elseif ($Attendance->amount_paid == 2) {
                        $val = Lang::__('Yes');
                    }
                }elseif ($col_name == 'Initial_Approval') {
                    if ($Attendance->Initial_Approval == 1) {
                        $val = Lang::__('No');
                    } elseif ($Attendance->Initial_Approval == 2) {
                        $val = Lang::__('Yes');
                    }
                } else {
                    $val = $Attendance->$col_name;
                }

                $worksheet->getCell($alpha . $k)->setValue($val)->getStyle($alpha . $k)->applyFromArray($NormalstyleArray);
            }

            $k++;
        }
        foreach ($Feilds as $alpha => $col_name) {
            $worksheet->getColumnDimension($alpha)->setAutoSize(true);
        }

        $Success_Files = array();
        $directory = 'files/attendance/' . date('Y') . '/' . date("m") . '/';
        $directory_D = DOCROOT . str_replace("\\", "/", $directory);
        if (!file_exists($directory_D)) {
            mkdir($directory_D, 0777, true);
        }
        $ext = 'xlsx';
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, ucfirst($ext));

        if ($writer->save($directory . $filename) === NULL) {
            $date_to_delete = date('Y-m-d', strtotime(date('Y-m-d') . ' + 90 days'));
            echo $directory . $filename;
        }



        $spreadsheet->disconnectWorksheets(); //Clearing a Workbook from memory
        unset($spreadsheet); //Clearing a Workbook from memory
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Admission applications');
            $this->template->title = $title;
            $this->template->layout = new View('system/students/admission_applications/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Browse() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $Obj = ORM::factory('Students_Applications', $par1);

        if (($Obj->loaded()) && ($this->Add || $this->Browse || $this->Delete || $this->Edit) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/students/admission_applications/Browse');
            $title = Lang::__('Admission application') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->layout->Obj = $Obj;
            $this->template->layout->Documents = $Obj->Documents->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->title = $title;
            $this->template->title = $title;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Payment() {

        $par1 = $this->request->param('par1');

        $Obj = ORM::factory('Students_Applications', $par1);

        if ($Obj->loaded() && ($Obj->amount_paid == 1) && $this->Edit && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/students/admission_applications/Payment');

            $this->template->layout->Obj = $Obj;

            $this->template->layout->title = Lang::__('Restrict Payment') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->title = Lang::__('Restrict Payment') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * انشاء دفعة مالية لطلب الالتحاق
     */

    public function action_PaymentToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        $Okhra = ORM::factory('Accounting_Links', 3); //الايرادات الاخرى
        $themam = ORM::factory('Accounting_Links', 4); //ذمم الطلاب
        $Cash_Link = ORM::factory('Accounting_Links', 5); //الصندوق النقدي
        $Point_of_sale_Link = ORM::factory('Accounting_Links', 6); //نقطة بيع
        $Bank_remittances_Link = ORM::factory('Accounting_Links', 7); //بنك الشيكات والحوالات
        if ((!empty($themam->account_id)) && (!empty($Okhra->account_id)) && (!empty($Cash_Link->account_id)) && (!empty($Point_of_sale_Link->account_id)) && (!empty($Bank_remittances_Link->account_id))) {
            $objj = ORM::factory('Students_Applications', $par1);
            if ($objj->loaded()) {
                $Currentamount_paid = $objj->amount_paid;
                $CurrentDiscount = $objj->Discount;
                $CurrentCash = $objj->Cash;
                $CurrentBank_Transfer = $objj->Bank_Transfer;
                $CurrentATM = $objj->ATM;
                $CurrentCheque = $objj->Cheque;

                $objj->Discount = $Filtered_array['Discount'];
                $objj->Cash = $Filtered_array['Cash'];
                $objj->Bank_Transfer = $Filtered_array['Bank_Transfer'];
                $objj->ATM = $Filtered_array['ATM'];
                $objj->Cheque = $Filtered_array['Cheque'];

                $objj->check_bank = $Filtered_array['check_bank'];
                $objj->check_number = $Filtered_array['check_number'];
                $objj->check_maturity_date = $Filtered_array['check_maturity_date'];


                $extra_rules = Validation::factory($Filtered_array);
                $extra_rules->rule('Discount', 'numeric');
                $extra_rules->rule('Cash', 'numeric');
                $extra_rules->rule('Bank_Transfer', 'numeric');
                $extra_rules->rule('ATM', 'numeric');
                $extra_rules->rule('Cheque', 'numeric');

                if (!empty($Filtered_array['Cheque'])) {
                    $extra_rules->rule('check_bank', 'not_empty');
                    $extra_rules->rule('check_number', 'not_empty');
                    $extra_rules->rule('check_maturity_date', 'not_empty');
                }
                //$objj->values($Filtered_array);
                try {
                    if ($objj->save($extra_rules)) {

                        if ($CurrentDiscount != $objj->Discount) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 7;
                            $Log->old_int_val = $CurrentDiscount;
                            $Log->new_int_val = $objj->Discount;
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        }
                        if ($CurrentCash != $objj->Cash) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 8;
                            $Log->old_int_val = $CurrentCash;
                            $Log->new_int_val = $objj->Cash;
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        }
                        if ($CurrentBank_Transfer != $objj->Bank_Transfer) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 9;
                            $Log->old_int_val = $CurrentBank_Transfer;
                            $Log->new_int_val = $objj->Bank_Transfer;
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        }
                        if ($CurrentATM != $objj->ATM) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 10;
                            $Log->old_int_val = $CurrentATM;
                            $Log->new_int_val = $objj->ATM;
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        }
                        if ($CurrentCheque != $objj->Cheque) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 11;
                            $Log->old_int_val = $CurrentCheque;
                            $Log->new_int_val = $objj->Cheque;
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        }

                        $Total_amount_paid = $objj->Cash + $objj->Bank_Transfer + $objj->ATM + $objj->Cheque;
                        $amount_to_pay_after_discount = $objj->amount_to_pay - (($objj->amount_to_pay * $objj->Discount) / 100);
                        $Remaining_amount = $amount_to_pay_after_discount - $Total_amount_paid;

                        if ($Remaining_amount <= 0) {
                            if ($objj->amount_to_pay > 0) {
                                //انشاء قيد مالي

                                $Trans_Array1 = array(
                                    'branchno' => NULL,
                                    'transno' => NULL,
                                    'transYear' => Date('Y'),
                                    'BranchSubno' => NULL,
                                    'Gregorian_date' => date("Y-m-d"),
                                    'Hijri_date' => General::ConvertDateToHegri(date("Y-m-d")),
                                    'amount' => $objj->amount_to_pay,
                                    'Description' => '(' . $objj->ID_No . ') ' . $objj->Full_Name_Arabic . ' - ' . $objj->Full_Name_English,
                                    'Posted' => 1,
                                    'Post_By' => $this->user_online->id,
                                    'PostDate' => date("Y-m-d H:i:s"),
                                    'Reversedno' => NULL,
                                    'ReversedYear' => NULL,
                                    'ReversedBranch' => NULL,
                                    'CostCenterno' => NULL,
                                    'Details' => array(
                                        array(
                                            'transYear' => Date('Y'),
                                            'AccYear' => NULL,
                                            'posted' => 1,
                                            'TransNo' => NULL,
                                            'AccNo' => $themam->account_id,
                                            'debit' => $objj->amount_to_pay,
                                            'credit' => NULL,
                                            'Description' => NULL,
                                            'PreDebitBal' => NULL,
                                            'PreCreditBal' => NULL,
                                            'CostCenterno' => NULL,
                                        ),
                                        array(
                                            'transYear' => Date('Y'),
                                            'AccYear' => NULL,
                                            'posted' => 1,
                                            'TransNo' => NULL,
                                            'AccNo' => $Okhra->account_id,
                                            'debit' => NULL,
                                            'credit' => $objj->amount_to_pay,
                                            'Description' => NULL,
                                            'PreDebitBal' => NULL,
                                            'PreCreditBal' => NULL,
                                            'CostCenterno' => NULL,
                                        ),
                                    ),
                                );
                                $ToDB = Model_Accounting_Accounts_Trans::TransToDB($Trans_Array1, NULL, $this->user_online);

                                //انهاء انشاء قيد مالي
                                //بداية انشاء قيد مالي

                                $Trans_Array = array(
                                    'branchno' => NULL,
                                    'transno' => NULL,
                                    'transYear' => Date('Y'),
                                    'BranchSubno' => NULL,
                                    'Gregorian_date' => date("Y-m-d"),
                                    'Hijri_date' => General::ConvertDateToHegri(date("Y-m-d")),
                                    'amount' => $objj->amount_to_pay,
                                    'Description' => '(' . $objj->ID_No . ') ' . $objj->Full_Name_Arabic . ' - ' . $objj->Full_Name_English,
                                    'Posted' => 1,
                                    'Post_By' => $this->user_online->id,
                                    'PostDate' => date("Y-m-d H:i:s"),
                                    'Reversedno' => NULL,
                                    'ReversedYear' => NULL,
                                    'ReversedBranch' => NULL,
                                    'CostCenterno' => NULL,
                                    'Details' => array(),
                                );
                                if (!empty($objj->Cash)) {
                                    array_push($Trans_Array['Details'], array(
                                        'transYear' => Date('Y'),
                                        'AccYear' => NULL,
                                        'posted' => 1,
                                        'TransNo' => NULL,
                                        'AccNo' => $Cash_Link->account_id,
                                        'debit' => $objj->Cash,
                                        'credit' => NULL,
                                        'Description' => NULL,
                                        'PreDebitBal' => NULL,
                                        'PreCreditBal' => NULL,
                                        'CostCenterno' => NULL,
                                    ));
                                }
                                if (!empty($objj->Bank_Transfer)) {
                                    array_push($Trans_Array['Details'], array(
                                        'transYear' => Date('Y'),
                                        'AccYear' => NULL,
                                        'posted' => 1,
                                        'TransNo' => NULL,
                                        'AccNo' => $Bank_remittances_Link->account_id,
                                        'debit' => $objj->Bank_Transfer,
                                        'credit' => NULL,
                                        'Description' => NULL,
                                        'PreDebitBal' => NULL,
                                        'PreCreditBal' => NULL,
                                        'CostCenterno' => NULL,
                                    ));
                                }
                                if (!empty($objj->ATM)) {
                                    array_push($Trans_Array['Details'], array(
                                        'transYear' => Date('Y'),
                                        'AccYear' => NULL,
                                        'posted' => 1,
                                        'TransNo' => NULL,
                                        'AccNo' => $Point_of_sale_Link->account_id,
                                        'debit' => $objj->ATM,
                                        'credit' => NULL,
                                        'Description' => NULL,
                                        'PreDebitBal' => NULL,
                                        'PreCreditBal' => NULL,
                                        'CostCenterno' => NULL,
                                    ));
                                }
                                if (!empty($objj->Cheque)) {
                                    array_push($Trans_Array['Details'], array(
                                        'transYear' => Date('Y'),
                                        'AccYear' => NULL,
                                        'posted' => 1,
                                        'TransNo' => NULL,
                                        'AccNo' => $Bank_remittances_Link->account_id,
                                        'debit' => $objj->Cheque,
                                        'credit' => NULL,
                                        'Description' => NULL,
                                        'PreDebitBal' => NULL,
                                        'PreCreditBal' => NULL,
                                        'CostCenterno' => NULL,
                                    ));
                                }
                                array_push($Trans_Array['Details'], array(
                                    'transYear' => Date('Y'),
                                    'AccYear' => NULL,
                                    'posted' => 1,
                                    'TransNo' => NULL,
                                    'AccNo' => $themam->account_id,
                                    'debit' => NULL,
                                    'credit' => $objj->amount_to_pay,
                                    'Description' => NULL,
                                    'PreDebitBal' => NULL,
                                    'PreCreditBal' => NULL,
                                    'CostCenterno' => NULL,
                                ));
                                $TransToDB = Model_Accounting_Accounts_Trans::TransToDB($Trans_Array, NULL, $this->user_online);
                                //انهاء انشاء قيد مالي
                            }
                            if (isset($TransToDB) && isset($ToDB)) {
                                if (array_key_exists('Success', $TransToDB) && array_key_exists('Success', $ToDB)) {
                                    $objj->amount_paid = 2;
                                    $objj->save();
                                } elseif (array_key_exists('Errors', $TransToDB)) {
                                    $results['Errors'] = $TransToDB['Errors'];
                                } elseif (array_key_exists('Errors', $ToDB)) {
                                    $results['Errors'] = $ToDB['Errors'];
                                }
                            } else {
                                $objj->amount_paid = 2;
                                $objj->save();
                            }
                        } else {
                            $objj->amount_paid = 1;
                            $objj->save();
                        }


                        if ($Currentamount_paid == 1 && $objj->amount_paid == 2) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 1; //تحديد رسوم طلب التحاق كمدفوعة
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        } elseif ($Currentamount_paid == 2 && $objj->amount_paid == 1) {
                            $Log = ORM::factory('Students_Logs');
                            $Log->operation = 2; //تحديد رسوم طلب التحاق كغير مدفوعه
                            $Log->ref_id = $objj->id;
                            $Log->Created_by = $this->user_online->id;
                            $Log->Created_date = date("Y-m-d H:i:s");
                            $Log->save();
                        }

                        $results['Success'] = array(
                            'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => '',
                            'life' => '2000', //1000 is 1 second
                            'text' => Lang::__('Saved_successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                }
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('In linking accounts please make sure to link') . ' ' . $themam->{'name_' . $this->lang} . ' ' . $Okhra->{'name_' . $this->lang} . ' ' . $Cash_Link->{'name_' . $this->lang} . ' ' . $Point_of_sale_Link->{'name_' . $this->lang} . ' ' . $Bank_remittances_Link->{'name_' . $this->lang}
            );
        }
        echo json_encode($results);
    }

    public function action_Initial_Approval() {

        $par1 = $this->request->param('par1');

        $Obj = ORM::factory('Students_Applications', $par1);

        if ($Obj->loaded() && empty($Obj->rejected) && $this->Edit && ($Obj->is_deleted == NULL) && empty($Obj->student_id) && $Obj->Initial_Approval == 1) {
            $this->template->layout = new View('system/students/admission_applications/Initial_Approval');
            $interview = FALSE;
            switch ($Obj->app_type) {
                case 'ba':

                    $interview = (mb_strtolower(ORM::factory('Variables', 75)->value) == 'yes') ? TRUE : FALSE;

                    break;
                case 'ma':

                    $interview = (mb_strtolower(ORM::factory('Variables', 76)->value) == 'yes') ? TRUE : FALSE;

                    break;


                default:
                    break;
            }

            $this->template->layout->Obj = $Obj;
            $this->template->layout->Reject_Student_Applications = $this->Reject_Student_Applications;
            $this->template->layout->interview = $interview;
            $this->template->layout->title = Lang::__('Initial Approval') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->title = Lang::__('Initial Approval') . ' - ' . $Obj->Full_Name_Arabic;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Initial_ApprovalToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $themam = ORM::factory('Accounting_Links', 4); //ذمم الطلاب
        $Okhra = ORM::factory('Accounting_Links', 3); //ايرادات الاخرى
        if ($themam->loaded() && !empty($themam->account_id) && $Okhra->loaded() && !empty($Okhra->account_id)) {

            $objj = ORM::factory('Students_Applications', $par1);
            if ($objj->loaded() && empty($objj->rejected) && empty($objj->student_id) && empty($objj->is_deleted) && ($objj->Initial_Approval == 1)) {

                if ($Filtered_array['study_type'] == 1) {

                    if ($objj->app_type == 'ba') {
                        $level_id = ORM::factory('Variables', 79)->value;
                    } elseif ($objj->app_type == 'ma') {
                        $level_id = ORM::factory('Variables', 80)->value;
                    }
                    if (isset($level_id)) {
                        $Level = ORM::factory('Study_Levels', $level_id);
                    }
                }

                if ($Filtered_array['study_type'] == 2 || (isset($Level) && $Level->loaded())) {

                    $objj->values($Filtered_array);
                    try {
                        $interview = FALSE; //المقابلة
                        switch ($objj->app_type) {
                            case 'ba':
                                $interview = (mb_strtolower(ORM::factory('Variables', 75)->value) == 'yes') ? TRUE : FALSE;
                                break;
                            case 'ma':
                                $interview = (mb_strtolower(ORM::factory('Variables', 76)->value) == 'yes') ? TRUE : FALSE;
                                break;
                            default:
                                break;
                        }
                        $extra_rules = Validation::factory($Filtered_array);
                        if ($interview) {
                            $extra_rules->rule('interview_date', 'not_empty');
                        }
                        $extra_rules->rule('study_type', 'not_empty');
                        $extra_rules->rule('degree', 'not_empty');

                        if ($objj->save($extra_rules)) {
                            if ($interview) {

                                $objj->Initial_Approval = 2;
                                if ($objj->save()) {
                                    //تسجيل العملية في سجلات التقارير
                                    $Log = ORM::factory('Students_Logs');
                                    $Log->operation = 4;
                                    $Log->ref_id = $objj->id;
                                    $Log->Created_by = $this->user_online->id;
                                    $Log->Created_date = date("Y-m-d H:i:s");
                                    $Log->save();

                                    $note_type = 'note-success';
                                    $text = Lang::__('It is scheduled to interview the student') . ' (' . $objj->Full_Name_Arabic . ') ' . Lang::__('On_Date') . ' (' . $objj->interview_date . ') ';
                                }
                            } else {
                                if (empty($objj->student_id)) {


                                    //اذا ما في مقابلة، يتم انشاء عضوية للطالب مباشرة
                                    $Groub = ORM::factory('Usersgroub', 3); // Student
                                    $password = Text::random('nozero', rand(8, 8));

                                    $username = $objj->GenerateAcadimicNo();

                                    $User = ORM::factory('User');
                                    $User->username = $username;
                                    $User->password = $password;
                                    $User->email = $objj->Email;
                                    $User->user_groub = $Groub->id;
                                    $User->name_ar = $objj->Full_Name_Arabic;
                                    $User->name_en = $objj->Full_Name_English;
                                    $User->Created_by = $this->user_online->id;
                                    $User->Created_date = date("Y-m-d H:i:s");
                                    if ($User->save()) {
                                        // Grant user login role
                                        $User->add('roles', ORM::factory('Role', array('name' => 'login')));
                                        $objj->Initial_Approval = 2;
                                        $objj->student_id = $User->id;
                                        $objj->password = $password;

                                        if (isset($Level) && $Level->loaded()) {
                                            $objj->level = $Level->id;
                                        }


                                        if ($objj->save()) {
                                            //تسجيل العملية في سجلات التقارير
                                            $Log = ORM::factory('Students_Logs');
                                            $Log->operation = 3;
                                            $Log->ref_id = $objj->id;
                                            $Log->ref1_id = $User->id;
                                            $Log->Created_by = $this->user_online->id;
                                            $Log->Created_date = date("Y-m-d H:i:s");
                                            $Log->save();

                                            $note_type = 'note-success';
                                            $text = Lang::__('The membership of the new student to the student creation') . ' (' . $objj->Full_Name_Arabic . ') ' . Lang::__('The user name is') . ' (' . $username . ') ' . Lang::__('The password is') . ' (' . $password . ') ';
                                        }
                                    }
                                }
                            }

                            $results['Success'] = array(
                                'note_type' => (isset($note_type)) ? $note_type : 'note-danger',
                                'text' => (isset($text)) ? $text : Lang::__('An error occurred while trying to process the request'),
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('An error has occurred possibly the default phase is not specified in the registry settings')
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Students claims are not linked to any accounting account')
            );
        }



        echo json_encode($results);
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Students_Applications', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            $img->save($directory . $filename, 100);
            $img->resize($width, $height, Image::INVERSE);
            $img->save($directory_thumbs . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

    public function action_AppApproval() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;
        $par2 = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;
        $notes = !empty($Filtered_array['notes']) ? $Filtered_array['notes'] : NULL;

        $objj = ORM::factory('Students_Applications', $par1);

        if ($objj->loaded()) {
            try {
                if ($par2 == 'reject'  && $objj->CanRejected() && $this->Reject_Student_Applications) {
                    $objj->id_can_order_other = 1;
                    $objj->rejected = 1;
                    $objj->rejected_date = date("Y-m-d H:i:s");
                    $objj->rejected_by = $this->user_online->id;
                    $objj->rejected_notes = $notes;
                    if ($objj->update()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Application rejected successfully'),
                            'redirect' => URL::base() . 'Students_Admissionapps'
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        }

        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Students_Applications')
                ->where('is_deleted', '=', NULL)
                ->where('student_id', '=', NULL)
                ->where('finished', '=', 1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */

        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            if (!empty($post['Created_date_From'])) {
                $All_ORM->where('Created_date', '>=', $post['Created_date_From']);
            }
            if (!empty($post['Created_date_to'])) {
                $new_Created_date_to = new DateTime($post['Created_date_to']);
                $new_Created_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('Created_date', '<=', $new_Created_date_to->format('Y-m-d H:i:s'));
            }
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(Full_Name_Arabic)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(Full_Name_English)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['ID_No'])) {
                $ID_No = $post['ID_No'];
                $All_ORM->where(DB::expr('lower(ID_No)'), 'LIKE', mb_strtolower("%$ID_No%"));
            }
            if (!empty($post['ba_Major'])) {
                $ba_Major = $post['ba_Major'];
                $All_ORM->where(DB::expr('lower(ba_Major)'), 'LIKE', mb_strtolower("%$ba_Major%"));
            }
            if (!empty($post['app_type'])) {
                $All_ORM->where('app_type', '=', $post['app_type']);
            }
        }

        /*
         * Paging
         */

        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);

        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit || $this->Browse || $this->Add || $this->Delete) ? $buttons .= '<a href="' . URL::base() . 'Students_Admissionapps/Browse/' . $value->id . '" class="btn btn-xs blue-soft"><i class="fa fa-binoculars"></i> ' . Lang::__('Browse') . '</a>' : NULL;
            ($this->Edit && ($value->amount_paid == 1)) ? $buttons .= '<a href="' . URL::base() . 'Students_Admissionapps/Payment/' . $value->id . '" class="btn btn-xs green-sharp"><i class="fa fa-credit-card"></i> ' . Lang::__('Restrict Payment') . '</a>' : NULL;
            ($this->Edit && ($value->amount_paid == 2) && $value->Initial_Approval == 1 && empty($value->rejected) && empty($value->interview_date)) ? $buttons .= '<a href="' . URL::base() . 'Students_Admissionapps/Initial_Approval/' . $value->id . '" class="btn btn-xs green-dark"><i class="fa fa-check"></i> ' . Lang::__('initial approval') . '</a>' : NULL;

            //($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            ($this->Reject_Student_Applications && $value->CanRejected()) ? $buttons .= '<button type="button" class="btn btn-xs red-mint app_affect" par1="' . $value->id . '" par2="reject" Dtitle="' . Lang::__('confirmation') . '" Dcontent="' . Lang::__('If you wish to continue with the reject application process').' '.$value->FullName($this->lang).' '.Lang::__('Click submit you can also leave a note in the field below') . '" PHold="'.Lang::__('Notes').'" Submit_Btn="'.Lang::__('Submit').'" Cancel_Btn="' . Lang::__('Cancel') . '"> ' . Lang::__('Reject_application') . '</button>' : NULL;

            $App_Status = Lang::__('undefined');
            if ($value->amount_paid == 1) {
                $App_Status = Lang::__('Waiting to pay finance charges');
            } elseif ($value->amount_paid == 2) {

                if (empty($value->interview_date)) {
                    if ($value->rejected == 1) {
                        $App_Status = Lang::__('The request was reject by') . ' ' . $value->Rejected_By->{'name_' . $this->lang};
                        $App_Status .= ' ' . Lang::__('in_date') . ' ' . $value->rejected_date;
                        if (!empty($value->rejected_notes)) {
                            $App_Status .= ' </br>' . Lang::__('notes') . ': ' . nl2br($value->rejected_notes);
                        }
                    } elseif ($value->Initial_Approval == 2) {
                        $App_Status = Lang::__('The request was accepted without interview');
                    } else {
                        $App_Status = Lang::__('The request wait Initial Approval');
                    }
                } else {
                    if (empty($value->interview_state)) {
                        $App_Status = Lang::__('interview need to review');
                    } elseif ($value->interview_state == 'reject') {
                        $App_Status = Lang::__('The request was rejected after the interview');
                    } elseif ($value->interview_state == 'accept' && !empty($value->student_id)) {
                        $App_Status = Lang::__('The request was accepted after the interview and student now have membership');
                    }
                }
            }

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                Lang::__($value->app_type),
                $value->Created_date,
                $value->ID_No,
                $value->Full_Name_Arabic,
                date_diff(date_create($value->Date_of_Birth), date_create('today'))->y,
                $App_Status . $value->interview_state,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
