<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Student_Portal extends Controller_Template_Site {

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        if (empty($this->user_online)) {
            $this->redirect('/', 302);
        } else {
            if ($this->user_online->user_groub != 3) {
                $this->redirect('/', 302);
            }
        }
    }

    public function action_Academic_Registration() {
        $Student_Info = $this->user_online->Student_Information;
        $this->template->layout = new View('site/student/academic_registration');
        $this->template->layout->lang = $this->lang;
        $this->template->layout->Obj = $Student_Info;
        $this->template->layout->RemainCourses = $Student_Info->GetRemainCourses();
        $this->template->layout->Student_Terms = $this->user_online->Student_Terms->where('is_deleted','=',NULL)->find_all();
    }
    public function action_MyProfile() {
        $user = $this->user_online;
        $profile = $user->Student_Information;
        $this->template->layout = new View('site/student/profile');
        $this->template->layout->lang = $this->lang;
        $this->template->layout->Obj = $profile;
        $this->template->layout->Documents = $profile->Documents->where('is_deleted', '=', NULL)->find_all();
    }

    /*
     * شاشة عرض نموذج معادلة المواد للطالب
     */

    public function action_Courses_Equation() {
        $user = $this->user_online;
        $profile = $user->Student_Information;
        $this->template->layout = new View('site/student/courses_equation');
        $this->template->layout->lang = $this->lang;
        $this->template->layout->Obj = $profile;
        $this->template->layout->user_online = $this->user_online;

        $this->template->layout->Courses = $profile->GetStudentCourses();
    }

    /*
     * Save Data From action_Courses_Equation() function
     */

    public function action_Courses_Equation_ToDB() {
        $results = array();
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $user = $this->user_online;
        $profile = $user->Student_Information;

        $Courses = $profile->GetStudentCourses();
        try {
            foreach ($Courses as $Course) {
                $SCE = ORM::factory('Students_Courses_Equations')
                        ->where('course_id', '=', $Course->id)
                        ->where('student_id', '=', $this->user_online->id)
                        ->find();
                if (!empty($Filtered_array['C' . $Course->id]) || !empty($Filtered_array['M' . $Course->id])) {
                    $SCE->course_id = $Course->id;
                    $SCE->state = 1; //بانتظار الموافقة
                    $SCE->student_id = $this->user_online->id;
                    $SCE->equivalent_course = isset($Filtered_array['C' . $Course->id]) ? $Filtered_array['C' . $Course->id] : NULL;
                    $SCE->equivalent_course_mark = isset($Filtered_array['C' . $Course->id]) ? $Filtered_array['C' . $Course->id] : NULL;

                    if (!$SCE->loaded()) {
                        $SCE->Created_by = $this->user_online->id;
                        $SCE->Created_date = date("Y-m-d H:i:s");
                    } else {
                        $SCE->last_update_by = $this->user_online->id;
                        $SCE->last_update_date = date("Y-m-d H:i:s");
                    }

                    $SCE->save();
                }
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
            );
        }
        if (empty($results['Errors'])) {
            $results['Success'] = array(
                'title' => Lang::__('Done'),
                'content' => Lang::__('The request has been successfully saved The application will be reviewed by the Admissions and Registration Department'),
            );
        }
        echo json_encode($results);
    }

    public function action_index() {

        $this->template->layout = new View('site/student/portal');
        $this->template->layout->lang = $this->lang;
    }

    public function action_male() {

        $this->template->layout = new View('site/student/male');
        $this->template->layout->lang = $this->lang;
    }

}
