<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Stocktaking extends Controller_Template_Base {

    public $Add_Continuous = FALSE;
    public $Edit_Continuous = FALSE;
    public $Browse_Continuous = FALSE;
    public $Delete_Continuous = FALSE;
    public $Add_Periodic = FALSE;
    public $Edit_Periodic = FALSE;
    public $Browse_Periodic = FALSE;
    public $Delete_Periodic = FALSE;
    public $Add_bpbalance = FALSE;
    public $Edit_bpbalance = FALSE;
    public $Browse_bpbalance = FALSE;
    public $Delete_bpbalance = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add_Continuous = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Continuous_Stocktaking')));
        $this->Edit_Continuous = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Continuous_Stocktaking')));
        $this->Browse_Continuous = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Continuous_Stocktaking')));
        $this->Delete_Continuous = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Continuous_Stocktaking')));

        $this->Add_Periodic = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Periodic_Stocktaking')));
        $this->Edit_Periodic = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Periodic_Stocktaking')));
        $this->Browse_Periodic = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Periodic_Stocktaking')));
        $this->Delete_Periodic = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Periodic_Stocktaking')));

        $this->Add_bpbalance = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Add_bpbalance')));
        $this->Edit_bpbalance = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Edit_bpbalance')));
        $this->Browse_bpbalance = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_bpbalance')));
        $this->Delete_bpbalance = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_bpbalance')));
    }

    public function action_index() {
        $type = mb_strtolower($this->request->param('par1'));
        $p_id = intval($this->request->param('par2'));
        if (in_array($type, array('periodic', 'continuous', 'bpbalance'))) {

            if (($type == 'bpbalance' && ($this->Add_bpbalance || $this->Edit_bpbalance || $this->Browse_bpbalance || $this->Delete_bpbalance)) || ($type == 'periodic' && ($this->Add_Periodic || $this->Edit_Periodic || $this->Browse_Periodic || $this->Delete_Periodic)) || ($type == 'continuous' && ($this->Add_Continuous || $this->Edit_Continuous || $this->Browse_Continuous || $this->Delete_Continuous))) {
                if ($type == 'periodic') {
                    $title = Lang::__('periodic_stocktaking');
                } elseif ($type == 'continuous') {
                    $title = Lang::__('continuous_stocktaking');
                } elseif ($type == 'bpbalance') {
                    $title = Lang::__('bpbalance');
                }
                $Stocktaking_Process = ORM::factory('Stores_Stocktaking_Process', $p_id);

                $this->template->title = $title;
                $this->template->layout = new View('system/stores/stocktaking/view_all');
                $this->template->layout->title = $title;
                $this->template->layout->lang = $this->lang;
                $this->template->layout->type = $type;
                if ($Stocktaking_Process->loaded()) {
                    $this->template->layout->Stocktaking_Process = $Stocktaking_Process;
                }
                $this->template->layout->Stores_Categories = ORM::factory('General_Stores_Categories')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_GetData() {


        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        $records = array();
        $records["data"] = array();
        $sEcho = intval($post['draw']);
        if ((!empty($post['par2'])) || (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter')) {
            $Stocktaking_Process = ORM::factory('Stores_Stocktaking_Process', $post['par2']);
            if ($Stocktaking_Process->loaded() && $Stocktaking_Process->stocktake == 1) {
                /*
                 * All coulums will shown in table
                 */
                $ALL_coulums = array(
                    1 => "id",
                );
                $All_ORM = $Stocktaking_Process->Elements
                        ->where('is_deleted', '=', NULL)
                        ->where('stocktake', '=', 1)
                        ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);




                $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
                $C_Acti_status = "OK";




                /*
                 * if search exists
                 */

//
//            if (!empty($post['Created_by'])) {
//                $Created_by = $post['Created_by'];
//                $All_ORM->and_where_open();
//                $All_ORM->or_where(DB::expr('lower(Created_by_User.name_ar)'), 'LIKE', mb_strtolower("%$Created_by%"));
//                $All_ORM->or_where(DB::expr('lower(Created_by_User.name_en)'), 'LIKE', mb_strtolower("%$Created_by%"));
//                $All_ORM->and_where_close();
//            }

                /*
                 * Paging
                 */

                $All_ORM->reset(FALSE);
                $iTotalRecords = $All_ORM->count_all();

                $iDisplayLength = intval($post['length']);
                $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
                $iDisplayStart = intval($post['start']);




                $end = $iDisplayStart + $iDisplayLength;
                $end = $end > $iTotalRecords ? $iTotalRecords : $end;

                $All_ORM->offset($iDisplayStart);
                $All_ORM->limit($iDisplayLength);

                /*
                 * Prepare JSON Array
                 */
                foreach ($All_ORM->find_all() as $value) {

                    $records["data"][] = array(
                        $value->Item->id,
                        $value->Item->{'name_' . $this->lang},
                        $value->Item->cost,
                        0,
                        $value->qty_before_stocktaking,
                        $value->qty,
                        $value->qty_diff,
                        $value->cost_after_stocktaking - $value->cost_before_stocktaking,
                    );
                }
                if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                    $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                    $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
                }

                $records["recordsTotal"] = $iTotalRecords;
                $records["recordsFiltered"] = $iTotalRecords;
            }
        }
        $records["draw"] = $sEcho;

        if (!isset($records["recordsTotal"])) {
            $records["recordsTotal"] = 0;
            $records["recordsFiltered"] = 0;
        }

        echo json_encode($records);
    }

    public function action_Stocktaking_Modal() {
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $type = !empty($Filtered_array['type']) ? strtolower($Filtered_array['type']) : NULL;
        $store = !empty($Filtered_array['store']) ? strtolower($Filtered_array['store']) : NULL;
        $category = !empty($Filtered_array['category']) ? strtolower($Filtered_array['category']) : NULL;

        //Edit Vars
        $Stocktaking_Id = !empty($Filtered_array['Stocktaking_Id']) ? strtolower($Filtered_array['Stocktaking_Id']) : NULL;
        $Stocktaking_Process = ORM::factory('Stores_Stocktaking_Process', $Stocktaking_Id);
        if ($Stocktaking_Process->loaded()) {
            $store = $Stocktaking_Process->store_id;
            $category = $Stocktaking_Process->categorie_id;
            if ($Stocktaking_Process->type == 1) {
                $type = 'periodic';
            } elseif ($Stocktaking_Process->type == 2) {
                $type = 'continuous';
            } elseif ($Stocktaking_Process->type == 3) {
                $type = 'bpbalance';
            }
        }


        $Stores_Categorie = ORM::factory('General_Stores_Categories')->where('id', '=', $category)->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find();
        $Stores_Store = ORM::factory('General_Stores_Stores')->where('id', '=', $store)->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find();


        if (((!$Stocktaking_Process->loaded()) && $this->Add_Continuous || $type == 'continuous') || ((!$Stocktaking_Process->loaded()) && $this->Add_Periodic || $type == 'periodic') || (($Stocktaking_Process->loaded()) && $this->Edit_Continuous || $type == 'continuous') || (($Stocktaking_Process->loaded()) && $this->Edit_Periodic || $type == 'periodic') || ((!$Stocktaking_Process->loaded()) && $this->Add_bpbalance || $type == 'bpbalance') || ((!$Stocktaking_Process->loaded()) && $this->Add_bpbalance || $type == 'bpbalance')) {
            if ($Stores_Store->loaded() || $type == 'continuous') {

                $view = View::factory('system/stores/stocktaking/stocktaking');

                $view->set('title', Lang::__('Stocktaking') . ' - ' . $Stores_Store->{'name_' . $this->lang});

                if (!$Stocktaking_Process->loaded()) {
                    $Vars = ORM::factory('Stores_Inventory')->where('is_deleted', '=', NULL);
                    if (!empty($Stores_Categorie->id)) {
                        $Vars = $Vars->where('category', '=', $Stores_Categorie->id);
                    }
                    if (!empty($Stores_Store->id)) {
                        $Vars = $Vars->where('store', '=', $Stores_Store->id);
                    }
                    if ($type == 'continuous') {
                        $Vars = $Vars->limit(10)->order_by(DB::expr('RAND()'));
                    }
                } else {
                    $invs = array(0);
                    $Stocktakings_Elements = $Stocktaking_Process->Elements->where('is_deleted', '=', NULL)->find_all();
                    foreach ($Stocktakings_Elements as $value) {
                        array_push($invs, $value->item);
                    }
                    $Vars = ORM::factory('Stores_Inventory')->where('id', 'IN', $invs);
                }

                $view->set('Stores_Inventory', $Vars->find_all());

                if ($Stocktaking_Process->loaded()) {
                    $view->set('Obj', $Stocktaking_Process);
                }

                if ($Stores_Store->loaded()) {
                    $view->set('Store', $Stores_Store);
                }

                $view->set('type', $type);
                if ($Stores_Categorie->loaded()) {
                    $view->set('Categorie', $Stores_Categorie);
                }
                $view->set('lang', $this->lang);
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('Please specify the store'));
                $this->response->body($view);
            }
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    public function action_StocktakingToDB() {
        $results = array();
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $ref = !empty($Filtered_array['ref']) ? $Filtered_array['ref'] : NULL;

        $SMsg = '';
        $Stocktake = FALSE;

        if (isset($Filtered_array['Save'])) {
            $SMsg = Lang::__('These Stocktaking data have been successfully saved, as this process will not affect the quantities');
        }
        if (isset($Filtered_array['Stocktake'])) {
            $Stocktake = TRUE;
            $SMsg = Lang::__('These Stocktaking data have been successfully saved, as this process will affect the quantities');
        }

        $Stocktaking_Process = ORM::factory('Stores_Stocktaking_Process', $ref);

        if ($Stocktaking_Process->loaded() && $Stocktaking_Process->stocktake == 1) {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Inventory Stocktake already exists')
            );
        } else {
            if (!$Stocktaking_Process->loaded()) {
                $Stocktaking_Process->Created_by = $this->user_online->id;
                $Stocktaking_Process->Created_date = date("Y-m-d H:i:s");

                $Stocktaking_Process->store_id = !empty($Filtered_array['store']) ? $Filtered_array['store'] : NULL;
                $Stocktaking_Process->categorie_id = !empty($Filtered_array['category']) ? $Filtered_array['category'] : NULL;
                $type = NULL;
                if (isset($Filtered_array['type']) && $Filtered_array['type'] == 'periodic') {
                    $type = 1;
                } elseif (isset($Filtered_array['type']) && $Filtered_array['type'] == 'continuous') {
                    $type = 2;
                } elseif (isset($Filtered_array['type']) && $Filtered_array['type'] == 'bpbalance') {
                    $type = 3;
                }
                $Stocktaking_Process->type = $type;
            } else {
                $Stocktaking_Process->last_update_by = $this->user_online->id;
                $Stocktaking_Process->last_update_date = date("Y-m-d H:i:s");
            }
            if ($Stocktake == TRUE) {
                $Stocktaking_Process->stocktake = 1;
                $Stocktaking_Process->stocktake_date = date("Y-m-d H:i:s");
                $Stocktaking_Process->stocktake_by = $this->user_online->id;
            }
            try {
                if ($Stocktaking_Process->save()) {

                    $actual_qty = !empty($Filtered_array['actual_qty']) ? $Filtered_array['actual_qty'] : array();

                    foreach ($actual_qty as $Stores_Inventory => $qty) {
                        $Element = ORM::factory('Stores_Stocktaking_Process_Elements')
                                ->where('stocktaking_id', '=', $Stocktaking_Process->id)
                                ->where('is_deleted', '=', NULL)
                                ->where('item', '=', $Stores_Inventory)
                                ->find();
                        $Stores_Inventory_Obj = ORM::factory('Stores_Inventory', $Stores_Inventory);
                        if (!$Element->loaded()) {
                            $Element->Created_by = $this->user_online->id;
                            $Element->Created_date = date("Y-m-d H:i:s");

                            $Element->stocktaking_id = $Stocktaking_Process->id;
                            $Element->item = $Stores_Inventory;
                        } elseif ($qty != $Element->qty) {
                            $Element->last_update_by = $this->user_online->id;
                            $Element->last_update_date = date("Y-m-d H:i:s");
                        }

                        if ($Stocktake == TRUE) {
                            $RCurrentQty = $Stores_Inventory_Obj->RCurrentQty();
                            $Element->stocktake = 1;
                            $Element->qty_before_stocktaking = $RCurrentQty;
                            if (is_numeric($qty)) {
                                $diff_qry = $qty - $RCurrentQty;
                                $Element->qty_diff = $diff_qry;
                                $Element->cost_before_stocktaking = $RCurrentQty * $Stores_Inventory_Obj->cost;
                                $Element->cost_after_stocktaking = $diff_qry * $Stores_Inventory_Obj->cost;
                            }
                            $Element->stocktake_date = date("Y-m-d H:i:s");
                            $Element->stocktake_by = $this->user_online->id;
                        }
                        if (!is_numeric($qty)) {
                            $qty = NULL;
                        }
                        $Element->qty = $qty;
                        $Element->save();
                    }

                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => $SMsg
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        }



        echo json_encode($results);
    }

    public function action_Previous_Stocktake() {

        if ($this->Browse_Continuous || $this->Browse_Periodic) {
            $title = Lang::__('previous stocktake');
            $this->template->title = $title;
            $this->template->layout = new View('system/stores/stocktaking/view_previous_stocktake');
            $this->template->layout->title = $title;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Stores_Categories = ORM::factory('General_Stores_Categories')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetPrevious_StocktakeData() {

        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Stores_Stocktaking_Process')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['type'])) {
                $All_ORM->where('type', '=', $post['type']);
            }
            if (!empty($post['store'])) {
                $All_ORM->where('store_id', '=', $post['store']);
            }
            if (!empty($post['category'])) {
                $All_ORM->where('categorie_id', '=', $post['category']);
            }
            if (!empty($post['stocktake'])) {
                if (is_numeric($post['stocktake'])) {
                    $All_ORM->where('stocktake', '=', $post['stocktake']);
                } elseif ($post['stocktake'] == 'saved') {
                    $All_ORM->where('stocktake', '=', NULL);
                }
            }

            if (!empty($post['stocktake_date_from'])) {
                $All_ORM->where('stocktake_date', '>=', $post['stocktake_date_from']);
            }
            if (!empty($post['stocktake_date_to'])) {
                $new_stocktake_date_to = new DateTime($post['stocktake_date_to']);
                $new_stocktake_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('stocktake_date', '<=', $new_stocktake_date_to->format('Y-m-d H:i:s'));
            }

            if (!empty($post['created_date_from'])) {
                $All_ORM->where('Created_date', '>=', $post['created_date_from']);
            }
            if (!empty($post['created_date_to'])) {
                $new_created_date_to = new DateTime($post['created_date_to']);
                $new_created_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                $All_ORM->where('Created_date', '<=', $new_created_date_to->format('Y-m-d H:i:s'));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);

        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $type = '';
            if ($value->type == 1) {
                $type = Lang::__('periodic_stocktaking');
                $type_c = 'periodic';
            } elseif ($value->type == 2) {
                $type = Lang::__('continuous_stocktaking');
                $type_c = 'continuous';
            } elseif ($value->type == 3) {
                $type = Lang::__('Bpbalance');
                $type_c = 'bpbalance';
            }
            $buttons = '';
            (($value->stocktake == NULL) && (($this->Edit_Periodic && $value->type == 1) || ($this->Edit_Continuous && $value->type == 2) || ($this->Edit_bpbalance && $value->type == 3))) ? $buttons .= '<button Stocktaking_Id="' . $value->id . '"  type="button" class="btn btn-block blue-hoki EditStocktaking"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</button>' : NULL;
            (($value->stocktake == 1) && (($this->Browse_Periodic && $value->type == 1) || ($this->Browse_Continuous && $value->type == 2) || ($this->Browse_bpbalance && $value->type == 3))) ? $buttons .= '<a href="' . URL::base() . 'Stores_Stocktaking/index/' . $type_c . '/' . $value->id . '" class="btn btn-block grey-mint"><i class="fa fa-eye"></i> ' . Lang::__('Show') . '</a>' : NULL;

            //($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;



            $records["data"][] = array(
                $type,
                $value->Store->{'name_' . $this->lang},
                $value->Categorie->{'name_' . $this->lang},
                ($value->stocktake == 1) ? '<span class="font-green-jungle">' . Lang::__('Yes Inventory Stocktaked') . '</span>' : '<span class="font-red-soft">' . Lang::__('Only saved not stocktaked yet') . '</span>',
                !empty($value->stocktake_date) ? $value->stocktake_date : Lang::__('Not stocktaked yet'),
                $value->Created_date,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
