<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Sales_Returns extends Controller_Template_Base {

    public $B_Sales_Invoice = FALSE;
    public $R_Sales_Invoice = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->B_Sales_Invoice = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Sales_Invoice')));
        $this->R_Sales_Invoice = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'R_Sales_Invoice')));
    }

    /*
     * تفاصيل العملية ومن هنا يمكن اجراء مردودات
     */

    public function action_SalesDetails() {
        if ($this->B_Sales_Invoice || $this->R_Sales_Invoice) {

            $Invoice_Voucher = ORM::factory('Stores_Sales_Invoice_Voucher', $this->request->param('par1'));

            if ($Invoice_Voucher->loaded()) {
                $title = Lang::__('Sales_Invoice_No') . ' ' . $Invoice_Voucher->id;
                $this->template->title = $title;
                $this->template->layout = new View('system/stores/sales/invoice/details');
                $this->template->layout->title = $title;
                $this->template->layout->lang = $this->lang;
                $this->template->layout->Invoice_Voucher = $Invoice_Voucher;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Get_SalesDetails() {
        if ($this->B_Sales_Invoice) {
            $req = Request::current(); //fillter requset
            $post = Search::action_Filtered_array($req->post());

            $Stores_Sales = ORM::factory('Stores_Sales_Invoice_Voucher', $post['par1']);

            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = $Stores_Sales->Items
                    ->where('is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                ($this->B_Sales_Invoice) ? $buttons .= '<a href="' . URL::base() . 'Stores_Sales_Returns/SalesDetails/' . $value->id . '" class="btn btn-xs blue"> ' . Lang::__('Details') . '</a>' : NULL;

                $quantity = $value->quantity;
                $CheckReturnedQty = $value->CheckReturnedQty();
                if ($value->quantity > $CheckReturnedQty) {
                    $quantity .= ' <button par1="' . $value->id . '" class="btn btn-xs yellow-gold ReturnQty" data-toggle="modal">' . Lang::__('Return_Qty') . '</button>';
                }

                $CheckReturnedQtyText = $CheckReturnedQty;
                if ($CheckReturnedQty > 0) {
                    $CheckReturnedQtyText .= ' <button par1="' . $value->id . '" class="btn btn-xs purple-studio ReturnDetails" data-toggle="modal">' . Lang::__('details') . '</button>';
                }

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->Inventory_Item->{'name_' . $this->lang},
                    $value->Inventory_Item->id,
                    $value->Inventory_Item->barcode,
                    $quantity,
                    $CheckReturnedQtyText,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * مودل عرض تفاصيل الارجاع 
     */

    public function action_ReturnDetails() {
        $req = Request::current(); //fillter requset
        $post = Search::action_Filtered_array($req->post());
        $Obj = ORM::factory('Stores_Sales_Invoice_Vitems', $post['item_id']);

        if ($this->R_Sales_Invoice && ($Obj->loaded())) {
            $ShowReturnItems = $Obj->Elements_Returned->where("is_deleted", "=", NULL)->find_all();
            $view = View::factory('system/stores/sales/invoice/ShowReturnItems');
            $view->set('Obj', $Obj);
            $view->set('ShowReturnItems', $ShowReturnItems);
            $view->set('title', Lang::__('Returns_of') . ' ' . $Obj->Inventory_Item->{'name_' . $this->lang});
            $view->set('lang', $this->lang);
            $this->response->body($view);
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    /*
     * مودل ارجاع كمية 
     */

    public function action_ReturnItemForm() {
        $req = Request::current(); //fillter requset
        $post = Search::action_Filtered_array($req->post());
        $Obj = ORM::factory('Stores_Sales_Invoice_Vitems', $post['item_id']);
     
        if ($this->R_Sales_Invoice && ($Obj->loaded())) {
            $CheckReturnedQty = $Obj->CheckReturnedQty();
            
            if ($Obj->quantity > $CheckReturnedQty) {
                $view = View::factory('system/stores/sales/invoice/ReturnItems');
                if ($Obj->loaded()) {
                    $view->set('Obj', $Obj);
                }
                $view->set('title', Lang::__('Return_Qty_of') . ' ' . $Obj->Inventory_Item->{'name_' . $this->lang});
                $view->set('lang', $this->lang);
                $view->set('MaxCanReturn', $Obj->quantity - $CheckReturnedQty);
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('No_quantities_are_available_for_this_item'));
                $this->response->body($view);
            }
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    public function action_ReturnItemTODB() {
        $results = array();
        $req = Request::current(); //fillter requset
        $post = Search::action_Filtered_array($req->post());
        $Obj = ORM::factory('Stores_Sales_Invoice_Vitems', $post['item_id']);

        if ($this->R_Sales_Invoice && ($Obj->loaded())) {
            try {
                $OPER = ORM::factory('Stores_Sales_Elements_Returned');
                $OPER->element = $Obj->id;
                $OPER->quantity = !empty($post['returned_quantity']) ? $post['returned_quantity'] : NULL;
                $OPER->returned_date = !empty($post['returned_date']) ? $post['returned_date'] : NULL;
                $OPER->notes = !empty($post['notes']) ? $post['notes'] : NULL;
                $OPER->Created_by = $this->user_online->id;
                $OPER->Created_date = date("Y-m-d H:i:s");
                if ($OPER->save()) {
                    $results['Success'] = array(
                        'type' => 'green',
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Saved_successfully'),
                        'redirect' => URL::base() . 'Stores_Inventory',
                    );
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = array(
                    'type' => 'red',
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
                );
            }
        } else {
            $results['Errors'] = array(
                'type' => 'red',
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_access_this_page'),
            );
        }

        echo json_encode($results);
    }


}
