<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Purchase extends Controller_Template_Base {

    public $A_Purchase = FALSE;
    public $B_Purchase = FALSE;
    public $R_Purchase = FALSE;
    public $transaction_types = array();

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->A_Purchase = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Purchase')));
        $this->B_Purchase = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Purchase')));
        $this->R_Purchase = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'R_Purchase')));
        $this->transaction_types = array(
            'IPO' => Lang::__('Internal Purchase Order'),
            'PO' => Lang::__('Purchase Order'),
            'PI' => Lang::__('Purchase invoice'),
        );
    }

    public function action_ManagePurchase() {
        if ($this->A_Purchase || $this->B_Purchase) {
            $title = Lang::__('manage_purchase');
            $this->template->title = $title;
            $this->template->layout = new View('system/stores/purchase/manage_purchase');
            $this->template->layout->title = $title;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->A_Purchase = $this->A_Purchase;
            $this->template->layout->transaction_types = $this->transaction_types;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_index() {
        if ($this->A_Purchase || $this->B_Purchase) {
            $transaction_type = strtoupper($this->request->param('par1'));

            if (array_key_exists($transaction_type, $this->transaction_types)) {
                $title = $this->transaction_types[$transaction_type];
                $this->template->title = $title;
                $this->template->layout = new View('system/stores/purchase/view_all');
                $this->template->layout->title = $title;
                $this->template->layout->lang = $this->lang;
                $this->template->layout->transaction_type = $transaction_type;
                $this->template->layout->Stores_Inventory = ORM::factory('Stores_Inventory')->where('is_deleted', '=', NULL)->find_all();

                $this->template->layout->Items_Of_Order = array();
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You tracked wrong or expired link');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Get_Managepurchase_Data() {
        if ($this->A_Purchase || $this->B_Purchase) {
            $req = Request::current(); //fillter requset
            $post = Search::action_Filtered_array($req->post());

            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Stores_Purchase')
                    ->where('is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['name'])) {
                    $Name = $post['name'];
                    $All_ORM->and_where_open();
                    $All_ORM->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                    $All_ORM->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Name%"));
                    $All_ORM->and_where_close();
                }
                if (!empty($post['store'])) {
                    $All_ORM->where('store', '=', $post['store']);
                }
                if (!empty($post['category'])) {
                    $All_ORM->where('category', '=', $post['category']);
                }
                if (!empty($post['shelf'])) {
                    $shelf = $post['shelf'];
                    $All_ORM->where(DB::expr('lower(shelf)'), 'LIKE', mb_strtolower("%$shelf%"));
                }

                if (!empty($post['cost_from'])) {
                    $All_ORM->where("cost", '>=', $post['cost_from']);
                }
                if (!empty($post['cost_to'])) {
                    $All_ORM->where("cost", '<=', $post['cost_to']);
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                ($this->B_Purchase) ? $buttons .= '<a href="' . URL::base() . 'Stores_Purchase/PurchaseDetails/' . $value->id . '" class="btn btn-xs blue"> ' . Lang::__('Details') . '</a>' : NULL;

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->id,
                    date("Y/m/d", strtotime($value->Created_date)),
                    Lang::__($value->type),
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * تفاصيل العملية ومن هنا يمكن اجراء مردودات
     */

    public function action_PurchaseDetails() {
        if ($this->B_Purchase) {

            $Stores_Purchase = ORM::factory('Stores_Purchase', $this->request->param('par1'));

            if ($Stores_Purchase->loaded()) {
                $title = Lang::__($Stores_Purchase->type) . ' - ' . $Stores_Purchase->id;
                $this->template->title = $title;
                $this->template->layout = new View('system/stores/purchase/details');
                $this->template->layout->title = $title;
                $this->template->layout->lang = $this->lang;
                $this->template->layout->Stores_Purchase = $Stores_Purchase;
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Get_PurchaseDetails() {
        if ($this->B_Purchase) {
            $req = Request::current(); //fillter requset
            $post = Search::action_Filtered_array($req->post());

            $Stores_Purchase = ORM::factory('Stores_Purchase', $post['par1']);

            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = $Stores_Purchase->Elements
                    ->where('is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                ($this->B_Purchase) ? $buttons .= '<a href="' . URL::base() . 'Stores_Purchase/PurchaseDetails/' . $value->id . '" class="btn btn-xs blue"> ' . Lang::__('Details') . '</a>' : NULL;

                $quantity = $value->quantity;
                $CheckReturnedQty = $value->CheckReturnedQty();
                if ($value->quantity > $CheckReturnedQty) {
                    $quantity .= ' <button par1="' . $value->id . '" class="btn btn-xs yellow-gold ReturnQty" data-toggle="modal">' . Lang::__('Return_Qty') . '</button>';
                }

                $CheckReturnedQtyText = $CheckReturnedQty;
                if ($CheckReturnedQty > 0) {
                    $CheckReturnedQtyText .= ' <button par1="' . $value->id . '" class="btn btn-xs purple-studio ReturnDetails" data-toggle="modal">' . Lang::__('details') . '</button>';
                }

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->Item->{'name_' . $this->lang},
                    $value->Item->id,
                    $value->Item->barcode,
                    $quantity,
                    $CheckReturnedQtyText,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * مودل عرض تفاصيل الارجاع 
     */

    public function action_ReturnDetails() {
        $req = Request::current(); //fillter requset
        $post = Search::action_Filtered_array($req->post());
        $Obj = ORM::factory('Stores_Purchase_Elements', $post['item_id']);

        if ($this->R_Purchase && ($Obj->loaded())) {
            $ShowReturnItems = $Obj->Elements_Returned->where("is_deleted", "=", NULL)->find_all();
            $view = View::factory('system/stores/purchase/ShowReturnItems');
            $view->set('Obj', $Obj);
            $view->set('ShowReturnItems', $ShowReturnItems);
            $view->set('title', Lang::__('Returns_of') . ' ' . $Obj->Item->{'name_' . $this->lang});
            $view->set('lang', $this->lang);
            $this->response->body($view);
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    /*
     * مودل ارجاع كمية 
     */

    public function action_ReturnItemForm() {
        $req = Request::current(); //fillter requset
        $post = Search::action_Filtered_array($req->post());
        $Obj = ORM::factory('Stores_Purchase_Elements', $post['item_id']);

        if ($this->R_Purchase && ($Obj->loaded())) {
            $CheckReturnedQty = $Obj->CheckReturnedQty();
            if ($Obj->quantity > $CheckReturnedQty) {
                $view = View::factory('system/stores/purchase/ReturnItems');
                if ($Obj->loaded()) {
                    $view->set('Obj', $Obj);
                }
                $view->set('title', Lang::__('Return_Qty_of') . ' ' . $Obj->Item->{'name_' . $this->lang});
                $view->set('lang', $this->lang);
                $view->set('MaxCanReturn', $Obj->quantity - $CheckReturnedQty);
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('No_quantities_are_available_for_this_item'));
                $this->response->body($view);
            }
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    public function action_ReturnItemTODB() {
        $results = array();
        $req = Request::current(); //fillter requset
        $post = Search::action_Filtered_array($req->post());
        $Obj = ORM::factory('Stores_Purchase_Elements', $post['item_id']);

        if ($this->R_Purchase && ($Obj->loaded())) {
            try {
                $OPER = ORM::factory('Stores_Purchase_Elements_Returned');
                $OPER->element = $Obj->id;
                $OPER->quantity = !empty($post['returned_quantity']) ? $post['returned_quantity'] : NULL;
                $OPER->returned_date = !empty($post['returned_date']) ? $post['returned_date'] : NULL;
                $OPER->notes = !empty($post['notes']) ? $post['notes'] : NULL;
                $OPER->Created_by = $this->user_online->id;
                $OPER->Created_date = date("Y-m-d H:i:s");
                if ($OPER->save()) {
                    $results['Success'] = array(
                        'type' => 'green',
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Saved_successfully'),
                        'redirect' => URL::base() . 'Stores_Inventory',
                    );
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = array(
                    'type' => 'red',
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
                );
            }
        } else {
            $results['Errors'] = array(
                'type' => 'red',
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_access_this_page'),
            );
        }

        echo json_encode($results);
    }

    public function action_GetItemAjax() {
        $results = array();

        if ($this->A_Purchase || $this->B_Purchase) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            if ($Filtered_array['type'] == 'Select' && (!empty($Filtered_array['id']))) {
                $Obj = ORM::factory('Stores_Inventory', $Filtered_array['id']);
            }

            if (isset($Obj) && $Obj->loaded()) {
                $results['Success'] = array(
                    'id' => $Obj->id,
                    'name' => $Obj->{'name_' . $this->lang},
                    'barcode' => $Obj->barcode,
                    'item_number' => $Obj->id,
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
        echo json_encode($results);
    }

    public function action_GetStoresItems() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $Barcode = !empty($Filtered_array['BarCode']) ? $Filtered_array['BarCode'] : NULL;
        $ItemNumber = !empty($Filtered_array['ItemNumber']) ? $Filtered_array['ItemNumber'] : NULL;
        $Item = !empty($Filtered_array['Item']) ? $Filtered_array['Item'] : NULL;
        if (($this->A_Purchase || $this->B_Purchase) && (!empty($Barcode) || !empty($ItemNumber) || !empty($Item))) {

            $Objs = ORM::factory('Stores_Inventory')
                    ->where('is_deleted', '=', NULL);
            if (!empty($Barcode)) {
                $Objs->where(DB::expr('lower(barcode)'), 'LIKE', mb_strtolower("%$Barcode%"));
            }
            if (!empty($ItemNumber)) {
                $Objs->where(DB::expr('lower(id)'), 'LIKE', mb_strtolower("%$ItemNumber%"));
            }
            if (!empty($Item)) {

                $Objs->and_where_open();
                $Objs->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Item%"));
                $Objs->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Item%"));
                $Objs->and_where_close();
            }


            $Objs->reset(FALSE);
            $iTotalRecords = $Objs->count_all();



            $items = array();
            foreach ($Objs->find_all() as $value) {
                array_push($items, array(
                    'id' => $value->id,
                    'number' => $value->id,
                    'name' => $value->{'name_' . $this->lang},
                    'barcode' => $value->barcode,
                ));
            }

            $results['items'] = $items;
            $results['total_count'] = $iTotalRecords;
            $results['incomplete_results'] = TRUE;
        }

        echo json_encode($results);
    }

    public function action_GetSuppliers() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $name = !empty($Filtered_array['name']) ? $Filtered_array['name'] : NULL;
        if (($this->A_Purchase || $this->B_Purchase) && (!empty($name))) {

            $Objs = ORM::factory('Accounting_Accounts')
                    ->where('is_deleted', '=', NULL);

            if (!empty($name)) {
                $Objs->and_where_open();
                $Objs->or_where(DB::expr('lower(AccName_ar)'), 'LIKE', mb_strtolower("%$name%"));
                $Objs->or_where(DB::expr('lower(AccName_en)'), 'LIKE', mb_strtolower("%$name%"));
                $Objs->and_where_close();
            }


            $Objs->reset(FALSE);
            $iTotalRecords = $Objs->count_all();



            $items = array();
            foreach ($Objs->find_all() as $value) {
                array_push($items, array(
                    'id' => $value->id,
                    'name' => $value->{'AccName_' . $this->lang},
                ));
            }

            $results['items'] = $items;
            $results['total_count'] = $iTotalRecords;
            $results['incomplete_results'] = TRUE;
        }

        echo json_encode($results);
    }

    public function action_TransactionToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : mb_strtoupper($Filtered_array['par2']);

        if (array_key_exists($par2, $this->transaction_types)) {
            $objj = ORM::factory('Stores_Purchase', $par1);

            $Expected_id = NULL;

            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
                $objj->type = mb_strtoupper($par2);
                $Expected_id = ORM::factory('Stores_Purchase')->order_by('id', 'desc')->find()->id;
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
                $Expected_id = $objj->id;
            }


            try {
                //Start validate form before adding
                $Items_Of_Order = isset($Filtered_array['Items_Of_Order']) ? $Filtered_array['Items_Of_Order'] : NULL;
                $Add_To_DB = FALSE;
                if (!empty($Items_Of_Order)) {
                    foreach ($Items_Of_Order as $keyQ => $Item) {
                        if (!empty($Expected_id)) {
                            $ElementCheck = ORM::factory('Stores_Purchase_Elements');
                            $ElementCheck->values($Item);
                            $ElementCheck->purchase_number = $Expected_id;
                            $ElementCheck->check();
                        }
                        //To check if any of field exist
                        $all_empty = TRUE;
                        foreach ($Item as $key => $value) {

                            if (!empty($value)) {

                                $all_empty = FALSE;
                                break;
                            }
                        }
                        //End check if any of field exist
                        if ($all_empty == FALSE) {
                            $Add_To_DB = TRUE;
                        }
                    }
                }
                //End validate form before adding


                if ($Add_To_DB && $objj->save()) {
                    //Start dealing with with Items_Of_Order
                    $Items_Of_Order = isset($Filtered_array['Items_Of_Order']) ? $Filtered_array['Items_Of_Order'] : NULL;
                    if (!empty($Items_Of_Order)) {
                        foreach ($Items_Of_Order as $keyQ => $Item) {

                            //To check if any of field exist
                            $all_empty = TRUE;
                            foreach ($Item as $key => $value) {
                                if (!empty($value)) {
                                    $all_empty = FALSE;
                                    break;
                                }
                            }
                            //End check if any of field exist
                            if ($all_empty == FALSE) {
                                $id_this = isset($Item['id']) ? $Item['id'] : NULL;
                                $Element = ORM::factory('Stores_Purchase_Elements', $id_this);
                                $Element->values($Item);
                                if (!$Element->loaded()) {
                                    $Element->purchase_number = $objj->id;
                                }
                                $Element->save();
                            }
                        }
                    }
                    //End dealing with with Items_Of_Order

                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                } else {
                    if (!$Add_To_DB) {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => Lang::__('You must fill at least one field')
                        );
                    }
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('The request type is not specified correctly')
            );
        }







        echo json_encode($results);
    }

}
