<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Itransfer extends Controller_Template_Base {

    public $Stores_itransfer = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Stores_itransfer = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Stores_itransfer')));
    }

    public function action_index() {
        if ($this->Stores_itransfer) {
            $title = Lang::__('Stores_itransfer');
            $this->template->title = $title;
            $this->template->layout = new View('system/stores/itransfer/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Inventory = ORM::factory('Stores_Inventory')->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->Items_Of_Order = array();
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetItemAjax() {
        $results = array();

        if ($this->Stores_itransfer) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            if ($Filtered_array['type'] == 'Select' && (!empty($Filtered_array['id']))) {
                $Obj = ORM::factory('Stores_Inventory', $Filtered_array['id']);
            }

            if (isset($Obj) && $Obj->loaded()) {
                $results['Success'] = array(
                    'id' => $Obj->id,
                    'name' => $Obj->{'name_' . $this->lang},
                    'barcode' => $Obj->barcode,
                    'item_number' => $Obj->id,
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
        echo json_encode($results);
    }

    public function action_GetStoresItems() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $Barcode = !empty($Filtered_array['BarCode']) ? $Filtered_array['BarCode'] : NULL;
        $ItemNumber = !empty($Filtered_array['ItemNumber']) ? $Filtered_array['ItemNumber'] : NULL;
        $Item = !empty($Filtered_array['Item']) ? $Filtered_array['Item'] : NULL;
        $store_id = !empty($Filtered_array['store_id']) ? $Filtered_array['store_id'] : NULL;
        if (($this->Stores_itransfer) && !empty($store_id) && (!empty($Barcode) || !empty($ItemNumber) || !empty($Item))) {

            $Objs = ORM::factory('Stores_Inventory')
                    ->where('store', '=', $store_id)
                    ->where('is_deleted', '=', NULL);
            if (!empty($Barcode)) {
                $Objs->where(DB::expr('lower(barcode)'), 'LIKE', mb_strtolower("%$Barcode%"));
            }
            if (!empty($ItemNumber)) {
                $Objs->where(DB::expr('lower(id)'), 'LIKE', mb_strtolower("%$ItemNumber%"));
            }
            if (!empty($Item)) {

                $Objs->and_where_open();
                $Objs->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Item%"));
                $Objs->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Item%"));
                $Objs->and_where_close();
            }


            $Objs->reset(FALSE);
            $iTotalRecords = $Objs->count_all();



            $items = array();
            foreach ($Objs->find_all() as $value) {
                array_push($items, array(
                    'id' => $value->id,
                    'number' => $value->id,
                    'name' => $value->{'name_' . $this->lang},
                    'barcode' => $value->barcode,
                    'StoreName' => $value->Store->{'name_' . $this->lang},
                    'current_qty' => $value->RCurrentQty(),
                ));
            }

            $results['items'] = $items;
            $results['total_count'] = $iTotalRecords;
            $results['incomplete_results'] = TRUE;
        }

        echo json_encode($results);
    }

    public function action_TransactionToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : mb_strtoupper($Filtered_array['par2']);

        $objj = ORM::factory('Stores_Goods_Transfer_Voucher', $par1);

        $Expected_id = NULL;

        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $Expected_id = ORM::factory('Stores_Goods_Transfer_Voucher')->order_by('id', 'desc')->find()->id;
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
            $Expected_id = $objj->id;
        }

        $objj->from_store = isset($Filtered_array['from_store']) ? $Filtered_array['from_store'] : NULL;
        $objj->to_store = isset($Filtered_array['to_store']) ? $Filtered_array['to_store'] : NULL;

        if ($objj->from_store != $objj->to_store) {

            try {
                //Start validate form before adding
                $Items_Of_Order = isset($Filtered_array['Items_Of_Order']) ? $Filtered_array['Items_Of_Order'] : NULL;
                $Add_To_DB = FALSE;
                if (!empty($Items_Of_Order)) {
                    foreach ($Items_Of_Order as $keyQ => $Item) {

                        //To check if any of field exist
                        $all_empty = TRUE;
                        foreach ($Item as $key => $value) {
                            if (!empty($value)) {

                                $all_empty = FALSE;
                                break;
                            }
                        }
                        //End check if any of field exist
                        if ($all_empty == FALSE) {
                            $Add_To_DB = TRUE;
                        }

                        if ($Add_To_DB) {
                            if (!empty($Expected_id)) {
                                $ElementCheck = ORM::factory('Stores_Goods_Transfer_Vitems');
                                $ElementCheck->item = isset($Item['item']) ? $Item['item'] : NULL;
                                $ElementCheck->quantity = isset($Item['quantity']) ? $Item['quantity'] : NULL;
                                $ElementCheck->voucher_id = $Expected_id;

                                if ($ElementCheck->check()) {
                                    
                                }
                            }
                        }
                    }
                }
                //End validate form before adding


                if ($Add_To_DB && $objj->save()) {
                    //Start dealing with with Items_Of_Order
                    $Items_Of_Order = isset($Filtered_array['Items_Of_Order']) ? $Filtered_array['Items_Of_Order'] : NULL;
                    if (!empty($Items_Of_Order)) {
                        foreach ($Items_Of_Order as $keyQ => $Item) {

                            //To check if any of field exist
                            $all_empty = TRUE;
                            foreach ($Item as $key => $value) {
                                if (!empty($value)) {

                                    $all_empty = FALSE;
                                    break;
                                }
                            }
                            //End check if any of field exist
                            if ($all_empty == FALSE) {
                                $id_this = isset($Item['id']) ? $Item['id'] : NULL;
                                $Element = ORM::factory('Stores_Goods_Transfer_Vitems', $id_this);
                                $Element->values($Item);
                                if (!$Element->loaded()) {
                                    $Element->voucher_id = $objj->id;
                                }
                                if ($Element->save()) {
                                    $Stores_Inventory = ORM::factory('Stores_Inventory');
                                    $Stores_Inventory->name_ar = $Element->Inventory_Item->name_ar;
                                    $Stores_Inventory->name_en = $Element->Inventory_Item->name_en;
                                    $Stores_Inventory->shelf = $Element->Inventory_Item->shelf;
                                    $Stores_Inventory->barcode = $Element->Inventory_Item->barcode;
                                    $Stores_Inventory->category = $Element->Inventory_Item->category;
                                    $Stores_Inventory->unit = $Element->Inventory_Item->unit;
                                    $Stores_Inventory->sales_price = $Element->Inventory_Item->sales_price;
                                    $Stores_Inventory->min_qty = $Element->Inventory_Item->min_qty;
                                    $Stores_Inventory->max_qty = $Element->Inventory_Item->max_qty;
                                    $Stores_Inventory->store = $objj->to_store;
                                    $Stores_Inventory->cost = $Element->Inventory_Item->cost;
                                    $Stores_Inventory->commision = $Element->Inventory_Item->commision;
                                    $Stores_Inventory->commision_percentage = $Element->Inventory_Item->commision_percentage;
                                    $Stores_Inventory->service_item = $Element->Inventory_Item->service_item;
                                    $Stores_Inventory->Created_by = $this->user_online->id;
                                    $Stores_Inventory->Created_date = date("Y-m-d H:i:s");
                                    if ($Stores_Inventory->save()) {
                                        $Element->new_item = $Stores_Inventory->id;
                                        $Element->save();
                                    }
                                }
                            }
                        }
                    }
                    //End dealing with with Items_Of_Order

                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Stores_Goods_Transfared_Succesfully'),
                        'redirect' => URL::base() . 'Stores_Itransfer',
                        'print_link' => URL::base() . 'Print/Stores_Goods_Transfer/'.$objj->id,
                    );
                } else {
                    if (!$Add_To_DB) {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => Lang::__('Please fill at least one item')
                        );
                    }
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('The target store is similar to the store moved from it')
            );
        }







        echo json_encode($results);
    }

}
