<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Inventory extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Store_Item_Report = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Inventory_Item')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Inventory_Item')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Inventory_Item')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Inventory_Item')));
        $this->Store_Item_Report = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Store_Item_Report')));
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $ORM = ORM::factory('Stores_Inventory', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);

        echo json_encode($results);
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Inventory_Manager');
            $this->template->title = $title;
            $this->template->layout = new View('system/stores/inventory/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Stores_Categories = ORM::factory('General_Stores_Categories')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Stores_Inventory', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/stores/inventory/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }

            $this->template->layout->Stores_Categories = ORM::factory('General_Stores_Categories')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Units = ORM::factory('General_Stores_Units')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();



            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Stores_Inventory', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $objj = ORM::factory('Stores_Inventory', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");

            if (!empty($objj->service_item) && empty($Filtered_array['service_item'])) {
                $objj->service_item = NULL;
            }
        }

        if (!empty($Filtered_array['service_item'])) {
            $Filtered_array['unit'] = NULL;
            $Filtered_array['cost'] = NULL;
        }

        $Jquery_Rules = $objj->AdminRules($objj, $Filtered_array);
        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $Jquery_Rules);

        $objj->values($Filtered_array);

        try {
            if ($objj->save($extra_rules)) {


                $results['Success'] = array(
                    'type' => 'green',
                    'title' => Lang::__('Done'),
                    'content' => Lang::__('Saved_successfully'),
                    'redirect' => URL::base() . 'Stores_Inventory',
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = array(
                'type' => 'red',
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
            );
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
            2 => 'name_' . $this->lang,
        );

        $All_ORM = ORM::factory('Stores_Inventory')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['store'])) {
                $All_ORM->where('store', '=', $post['store']);
            }
            if (!empty($post['item_number'])) {
                $All_ORM->where('id', '=', $post['item_number']);
            }
            if (!empty($post['category'])) {
                $All_ORM->where('category', '=', $post['category']);
            }
            if (!empty($post['shelf'])) {
                $shelf = $post['shelf'];
                $All_ORM->where(DB::expr('lower(shelf)'), 'LIKE', mb_strtolower("%$shelf%"));
            }

            if (!empty($post['cost_from'])) {
                $All_ORM->where("cost", '>=', $post['cost_from']);
            }
            if (!empty($post['cost_to'])) {
                $All_ORM->where("cost", '<=', $post['cost_to']);
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Store_Item_Report) ? $buttons .= '<a data-url="' . URL::base() . 'Stores_Inventory/Report/' . $value->id . '" class="btn btn-xs blue Report" data-toggle="modal"><i class="fa fa-file"></i> ' . Lang::__('Store_Item_Report') . '</a>' : NULL;
            ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Stores_Inventory/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->id,
                $value->{'name_' . $this->lang},
                Model_Stores_Inventory::CurrentQty($value),
                $value->cost,
                $value->Store->{'name_' . $this->lang},
                $value->Category->{'name_' . $this->lang},
                $value->shelf,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_Report() {
        $par1 = $this->request->param('par1');
        $Obj = ORM::factory('Stores_Inventory', $par1);

        if ($Obj->loaded() && $this->Store_Item_Report) {

            $view = View::factory('system/stores/inventory/report');
            $view->set('Obj', $Obj);
            
            
            $view->set('Purchase_Elements', $Obj->Purchase_Elements->where('is_deleted','=',NULL)->find_all());
            $view->set('Goods_Receipts_Vitems', $Obj->Goods_Receipts_Vitems->where('is_deleted','=',NULL)->find_all());
            $view->set('Goods_Delivery_Vitems', $Obj->Goods_Delivery_Vitems->where('is_deleted','=',NULL)->find_all());
            $view->set('Goods_Elimination_Vitems', $Obj->Goods_Elimination_Vitems->where('is_deleted','=',NULL)->find_all());
            $view->set('Sales_Invoice_Vitems', $Obj->Sales_Invoice_Vitems->where('is_deleted','=',NULL)->find_all());
            $view->set('Stocktaking_Elements', $Obj->Stocktaking_Elements->where('stocktake','=',1)->where('is_deleted','=',NULL)->find_all());
            $view->set('Goods_Transfer_Vitems', $Obj->Goods_Transfer_Vitems->where('is_deleted','=',NULL)->find_all());
            $view->set('Goods_Transfer_Transfared', $Obj->Goods_Transfer_Transfared->where('is_deleted','=',NULL)->find_all());
            
            
            $view->set('title', Lang::__('Store_Item_Report').' - '.$Obj->{'name_'.$this->lang});
            $view->set('lang', $this->lang);
            $this->response->body($view);
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

}
