<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Stores_Goods_Receipts extends Controller_Template_Base {

    public $Add = FALSE;
    public $Edit = FALSE;
    public $Browse = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Goods_Receipts_Voucher')));
        //$this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Goods_Receipts_Voucher')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Goods_Receipts_Voucher')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Goods_Receipts_Voucher')));
    }

    public function action_index() {
        if ($this->Add || $this->Edit || $this->Browse || $this->Delete) {
            $title = Lang::__('goods receipts voucher');
            $this->template->title = $title;
            $this->template->layout = new View('system/stores/goods/receipts/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->Employees = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Inventory = ORM::factory('Stores_Inventory')->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Payables = ORM::factory('Accounting_Accounts')->where('type_of_account', '=', 2)->where('is_deleted', '=', NULL)->find_all();
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {
        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');
        $title = Lang::__('A_Goods_Receipts_Voucher');
        $Obj = ORM::factory('Stores_Goods_Receipts_Voucher', $par1);

        if ($Obj->loaded()) {
            $title = Lang::__('E_Goods_Receipts_Voucher');
        }

        if ((($this->Add && !$Obj->loaded()) || ($this->Edit && $Obj->loaded()) || ($Obj->loaded() && $this->Browse)) && ($Obj->is_deleted == NULL)) {

            $par1 = $this->request->param('par1');

            $Disabled = false;

            //if only view
            if((($Obj->loaded() && $this->Browse)) && !($this->Edit && $Obj->loaded())){
                $Disabled = true;
                $title = Lang::__('B_Goods_Receipts_Voucher');
            }


            $this->template->title = $title;
            $this->template->layout = new View('system/stores/goods/receipts/AE');
            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }

            $this->template->layout->Disabled = $Disabled;
            $this->template->layout->title = $title;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Stores_Stores = ORM::factory('General_Stores_Stores')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Stores_Inventory = ORM::factory('Stores_Inventory')->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Payables = ORM::factory('Accounting_Accounts')->where('type_of_account', '=', 2)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Employees = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Items_Of_Order = $Obj->Items->where('is_deleted', '=', NULL)->find_all();
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetItemAjax() {
        $results = array();

        if ($this->Add || $this->Edit || $this->Browse || $this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            if ($Filtered_array['type'] == 'Select' && (!empty($Filtered_array['id']))) {
                $Obj = ORM::factory('Stores_Inventory', $Filtered_array['id']);
            }

            if (isset($Obj) && $Obj->loaded()) {
                $results['Success'] = array(
                    'id' => $Obj->id,
                    'name' => $Obj->{'name_' . $this->lang},
                    'barcode' => $Obj->barcode,
                    'item_number' => $Obj->id,
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
        echo json_encode($results);
    }

    public function action_GetStoresItems() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $Barcode = !empty($Filtered_array['BarCode']) ? $Filtered_array['BarCode'] : NULL;
        $ItemNumber = !empty($Filtered_array['ItemNumber']) ? $Filtered_array['ItemNumber'] : NULL;
        $Item = !empty($Filtered_array['Item']) ? $Filtered_array['Item'] : NULL;
        if (($this->Add || $this->Edit || $this->Browse || $this->Delete) && (!empty($Barcode) || !empty($ItemNumber) || !empty($Item))) {

            $Objs = ORM::factory('Stores_Inventory')
                    ->where('is_deleted', '=', NULL);
            if (!empty($Barcode)) {
                $Objs->where(DB::expr('lower(barcode)'), 'LIKE', mb_strtolower("%$Barcode%"));
            }
            if (!empty($ItemNumber)) {
                $Objs->where(DB::expr('lower(id)'), 'LIKE', mb_strtolower("%$ItemNumber%"));
            }
            if (!empty($Item)) {

                $Objs->and_where_open();
                $Objs->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Item%"));
                $Objs->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Item%"));
                $Objs->and_where_close();
            }


            $Objs->reset(FALSE);
            $iTotalRecords = $Objs->count_all();



            $items = array();
            foreach ($Objs->find_all() as $value) {
                array_push($items, array(
                    'id' => $value->id,
                    'number' => $value->id,
                    'name' => $value->{'name_' . $this->lang},
                    'barcode' => $value->barcode,
                    'StoreName' => $value->Store->{'name_' . $this->lang},
                    'current_qty' => $value->RCurrentQty(),
                ));
            }

            $results['items'] = $items;
            $results['total_count'] = $iTotalRecords;
            $results['incomplete_results'] = TRUE;
        }

        echo json_encode($results);
    }

    public function action_GetSuppliers() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $name = !empty($Filtered_array['name']) ? $Filtered_array['name'] : NULL;
        if (($this->Add || $this->Edit || $this->Browse || $this->Delete) && (!empty($name))) {

            $Objs = ORM::factory('Accounting_Accounts')
                    ->where('is_deleted', '=', NULL);

            if (!empty($name)) {
                $Objs->and_where_open();
                $Objs->or_where(DB::expr('lower(AccName_ar)'), 'LIKE', mb_strtolower("%$name%"));
                $Objs->or_where(DB::expr('lower(AccName_en)'), 'LIKE', mb_strtolower("%$name%"));
                $Objs->and_where_close();
            }


            $Objs->reset(FALSE);
            $iTotalRecords = $Objs->count_all();



            $items = array();
            foreach ($Objs->find_all() as $value) {
                array_push($items, array(
                    'id' => $value->id,
                    'name' => $value->{'AccName_' . $this->lang},
                ));
            }

            $results['items'] = $items;
            $results['total_count'] = $iTotalRecords;
            $results['incomplete_results'] = TRUE;
        }

        echo json_encode($results);
    }

    public function action_ReciptsToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : mb_strtoupper($Filtered_array['par2']);

        $objj = ORM::factory('Stores_Goods_Receipts_Voucher', $par1);

        $Expected_id = NULL;

        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $Expected_id = ORM::factory('Stores_Goods_Receipts_Voucher')->order_by('id', 'desc')->find()->id;
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
            $Expected_id = $objj->id;
        }

        $deliverer_type = isset($Filtered_array['deliverer_type']) ? $Filtered_array['deliverer_type'] : NULL;
        if ($deliverer_type == 1) {
            $Filtered_array['employee'] = NULL;
        } elseif ($deliverer_type == 2) {
            $Filtered_array['supplier'] = NULL;
        }


        $objj->store = isset($Filtered_array['store']) ? $Filtered_array['store'] : NULL;
        $objj->deliverer_type = $deliverer_type;
        $objj->supplier = isset($Filtered_array['supplier']) ? $Filtered_array['supplier'] : NULL;
        $objj->employee = isset($Filtered_array['employee']) ? $Filtered_array['employee'] : NULL;

        try {
            //Start validate form before adding
            $Items_Of_Order = isset($Filtered_array['Items_Of_Order']) ? $Filtered_array['Items_Of_Order'] : NULL;
            $Add_To_DB = FALSE;
            if (!empty($Items_Of_Order)) {
                foreach ($Items_Of_Order as $keyQ => $Item) {

                    //To check if any of field exist
                    $all_empty = TRUE;
                    foreach ($Item as $key => $value) {
                        if (!empty($value)) {

                            $all_empty = FALSE;
                            break;
                        }
                    }
                    //End check if any of field exist
                    if ($all_empty == FALSE) {
                        $Add_To_DB = TRUE;
                    }

                    if ($Add_To_DB) {
                        if (!empty($Expected_id)) {
                            $ElementCheck = ORM::factory('Stores_Goods_Receipts_Vitems');
                            $ElementCheck->item = isset($Item['item']) ? $Item['item'] : NULL;
                            $ElementCheck->quantity = isset($Item['quantity']) ? $Item['quantity'] : NULL;
                            $ElementCheck->voucher_id = $Expected_id;
                            $ElementCheck->check();
                        }
                    }
                }
            }
            //End validate form before adding


            if ($Add_To_DB && $objj->save()) {
                //Start dealing with with Items_Of_Order
                $Items_Of_Order = isset($Filtered_array['Items_Of_Order']) ? $Filtered_array['Items_Of_Order'] : NULL;
                if (!empty($Items_Of_Order)) {
                    foreach ($Items_Of_Order as $keyQ => $Item) {

                        //To check if any of field exist
                        $all_empty = TRUE;
                        foreach ($Item as $key => $value) {
                            if (!empty($value)) {

                                $all_empty = FALSE;
                                break;
                            }
                        }
                        //End check if any of field exist
                        if ($all_empty == FALSE) {
                            $id_this = isset($Item['id']) ? $Item['id'] : NULL;
                            $Element = ORM::factory('Stores_Goods_Receipts_Vitems', $id_this);
                            $Element->values($Item);
                            if (!$Element->loaded()) {
                                $Element->voucher_id = $objj->id;
                            }
                            $Element->save();
                        }
                    }
                }
                //End dealing with with Items_Of_Order

                $results['Success'] = array(
                    'title' => '',
                    'content' => Lang::__('Saved_successfully'),
                    'redirect' => URL::base() . 'Stores_Goods_Receipts',
                );
            } else {
                if (!$Add_To_DB) {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('Please fill at least one item')
                    );
                }
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
            );
        }








        echo json_encode($results);
    }

    public function action_GetData() {
        if ($this->Add || $this->Browse || $this->Delete || $this->Edit) {


            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "stores_goods_receipts_voucher.id",
            );

            $All_ORM = ORM::factory('Stores_Goods_Receipts_Voucher')
                    ->where('stores_goods_receipts_voucher.is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])
                    ->with("Created_by_User");


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */

            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

                if (!empty($post['Created_date_From'])) {
                    $All_ORM->where('stores_goods_receipts_voucher.Created_date', '>=', $post['Created_date_From']);
                }
                if (!empty($post['Created_date_to'])) {
                    $new_Created_date_to = new DateTime($post['Created_date_to']);
                    $new_Created_date_to->modify('+1 day'); //تم اضافة يوم لحل مشكلة عدم تحقق شرط التساوي
                    $All_ORM->where('stores_goods_receipts_voucher.Created_date', '<=', $new_Created_date_to->format('Y-m-d H:i:s'));
                }
                if (!empty($post['transaction_no'])) {
                    $All_ORM->where('stores_goods_receipts_voucher.id', '=', $post['transaction_no']);
                }
                if (!empty($post['store'])) {
                    $All_ORM->where('stores_goods_receipts_voucher.store', '=', $post['store']);
                }

                if (!empty($post['supplier'])) {
                    $All_ORM->where('stores_goods_receipts_voucher.supplier', '=', $post['supplier']);
                }
                if (!empty($post['employee'])) {
                    $All_ORM->where('stores_goods_receipts_voucher.employee', '=', $post['employee']);
                }

                if (!empty($post['Created_by'])) {
                    $Created_by = $post['Created_by'];
                    $All_ORM->and_where_open();
                    $All_ORM->or_where(DB::expr('lower(Created_by_User.name_ar)'), 'LIKE', mb_strtolower("%$Created_by%"));
                    $All_ORM->or_where(DB::expr('lower(Created_by_User.name_en)'), 'LIKE', mb_strtolower("%$Created_by%"));
                    $All_ORM->and_where_close();
                }
            }

            /*
             * Paging
             */

            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);

            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                ($this->Browse) ? $buttons .= '<a target="_blank" href="' . URL::base() . 'Print/Stores_Goods_Receipts/' . $value->id . '" class="btn btn-xs blue"><i class="fa fa-print"></i> ' . Lang::__('Print') . '</a>' : NULL;
                ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Stores_Goods_Receipts/AE/' . $value->id . '" class="btn btn-xs blue-soft"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
                ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;


                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->id,
                    $value->Store->{'name_' . $this->lang},
                    $value->Supplier->{'AccName_' . $this->lang},
                    $value->Employee->GetFullName($this->lang),
                    $value->Created_by_User->{'name_' . $this->lang},
                    date('Y-m-d', strtotime($value->Created_date)),
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    public function action_DeleteDetails() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = isset($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $par2 = isset($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

        $Obj = ORM::factory('Stores_Goods_Receipts_Vitems', $id);
        if ($Obj->loaded()) {
            if ($this->Delete) {
                $Goods_Receipts_Voucher = $Obj->Goods_Receipts_Voucher->Items->where('is_deleted', '=', NULL)->count_all();
                if ($Goods_Receipts_Voucher > 1) {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('The last item in the list can not be deleted'),
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }




        echo json_encode($results);
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Stores_Goods_Receipts_Voucher', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

}
