<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Slider extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Slides')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Slides')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Slides')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Slides')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $this->template->title = Lang::__('Slider');
            $this->template->layout = new View('system/slider/view_all');
            $this->template->layout->Add = $this->Add;
            $this->template->layout->Delete = $this->Delete;
        }
    }

    public function action_AE() {
        if ($this->Add || $this->Edit) {
            $this->template->layout = new View('system/slider/AE');
            $this->template->title = Lang::__('Slider');
            $process_type = 'add_new';
            $par1 = $this->request->param('par1');
            $Obj = ORM::factory('Slides', $par1);

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
                $process_type = 'modify';
            }
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());

            $this->template->layout->lang = $this->lang;
            $this->template->layout->title = Lang::__($process_type);
        }
    }

    public function action_DeleteLayer() {
        if ($this->Delete) {
            $id = mb_strtolower($this->request->param('par1'));
            $layer = ORM::factory('Layers', $id);
            if ($layer->delete()) {
                HTTP::redirect($this->request->referrer(), 302);
            }
        }
    }

    public function action_Delete($id) {
        if ($this->Delete) {
            $objj = ORM::factory('Slides', $id);
            if ($objj->loaded()) {
                if (!empty($objj->img)) {
                    $path = DOCROOT . $objj->img;
                    if (file_exists($path)) {
                        unlink($path);
                    }
                }
                if (!empty($objj->img_thumb)) {
                    $path = DOCROOT . $objj->img_thumb;
                    if (file_exists($path)) {
                        unlink($path);
                    }
                }
                foreach ($objj->Layers->find_all() as $option) {
                    $option->delete();
                }
                if ($objj->delete()) {
                    
                } else {
                    return FALSE;
                }
            }
        }
    }

    public function action_ToDB() {
        if ($this->Add || $this->Edit) {
            $results = array();

            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
            $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

            $objj = ORM::factory('Slides', $par1);
            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            }

            if ($this->request->method() == Request::POST) {
                if (isset($_FILES['img'])) {
                    $directory = 'files/slides/' . date('Y') . '/' . date("m") . '/';
                    $directory_thumbs = $directory . 'thumbs/';

                    $directory_D = DOCROOT . str_replace("\\", "/", $directory);
                    if (!file_exists($directory_D)) {
                        mkdir($directory_D, 0777, true);
                    }

                    $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
                    if (!file_exists($directory_thumbs_D)) {
                        mkdir($directory_thumbs_D, 0777, true);
                    }

                    $img = $this->_save_image($_FILES['img'], 2000, 600, $directory, $directory_thumbs);
                    if ($img) {
                        foreach (array('img', 'img_thumb') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }

                        $objj->img = $directory . $img;
                        $objj->img_thumb = $directory_thumbs . $img;
                    }
                }
            }
            $objj->values($Filtered_array);
            try {

                if ($objj->save()) {
                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                //To Delete Image From Server If OBJ Not Saved
                if (isset($_FILES['img'])) {
                    if ($img) {
                        foreach (array('img', 'img_thumb') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }
                    }
                }
                //End To Delete Image From Server If OBJ Not Saved

                $errors = $e->errors('');
                $results['Errors'] = General::CatchErrorMSGSAjax($errors);
            }
            echo json_encode($results);
        }
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            $img->save($directory . $filename, 100);
            $img->crop($width, $height);
            $img->save($directory_thumbs . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

    public function action_GetData() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable

            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Slides')
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':
                        $ids = array();
                        foreach ($post['id'] as $value) {
                            if ($this->action_Delete($value) === FALSE) {
                                array_push($ids, $value);
                            }
                        }

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                if ($this->Edit) {
                    $buttons .= '<a href="' . URL::base() . 'Slider/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>';
                }
                $buttons .= '<a href="' . URL::base() . 'Slider/ViewLayers/' . $value->id . '" class="btn btn-xs green"><i class="fa fa-list"></i> ' . Lang::__('ViewLayers') . '</a>';
                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    '<img class="img-responsive" src="' . URL::base() . $value->img_thumb . '" />',
                    ($value->Show_for_Visitors == 0) ? Lang::__('No') : Lang::__('Yes'),
                    $value->Created_date,
                    $buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    public function action_ViewLayers() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $par1 = $this->request->param('par1');
            $Obj = ORM::factory('Slides', $par1);
            if ($Obj->loaded()) {
                $this->template->title = Lang::__('ViewLayers');
                $this->template->layout = new View('system/slider/view_all_layers');
                $this->template->layout->Obj = $Obj;
                $this->template->layout->Edit = $this->Edit;
                $this->template->layout->Delete = $this->Delete;
                $this->template->layout->Add = $this->Add;
            }
        }
    }

    public function action_AELayer() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $this->template->layout = new View('system/slider/AELayer');
            $process_type = 'add_new';

            $GET_V = Search::action_Filtered_array($this->request->query());
            $A_E = empty($GET_V['A_E']) ? NULL : $GET_V['A_E']; //add || edit
            $var1 = empty($GET_V['type']) ? NULL : $GET_V['type']; //img || 2 text || 3 link
            $var2 = empty($GET_V['slide']) ? NULL : $GET_V['slide']; //slide id
            $id = empty($GET_V['id']) ? NULL : $GET_V['id']; //layer id

            switch ($A_E) {
                case 'edit':
                    $layer = ORM::factory('Layers', $id);
                    if ($layer->loaded()) {
                        $this->template->layout->layer = $layer;
                        $this->template->layout->slide_id = $layer->slide_id;
                        $process_type = 'modify';
                    } else {
                        
                    }
                    break;

                default:
                    $this->template->layout->type_of_layer = $var1;
                    $this->template->layout->slide_id = $var2;
                    break;
            }

            $this->template->layout->lang = $this->lang;
            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
        }
    }

    public function action_LayerToDB() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $results = array();
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $A_E = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1']; //add || edit
            $var1 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2']; // 1 img || 2 text || 3 link
            $var2 = empty($Filtered_array['par3']) ? NULL : $Filtered_array['par3']; // slide id
            $var4 = empty($Filtered_array['par4']) ? NULL : $Filtered_array['par4']; // slide id


            $objj = ORM::factory('Layers', $var4);
            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
                $objj->type = $var1;
                $objj->slide_id = $var2;
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            }

            if ($this->request->method() == Request::POST) {
                if (isset($_FILES['img'])) {
                    $directory = 'files/slides/' . date('Y') . '/' . date("m") . '/';
                    $directory_thumbs = $directory . 'thumbs/';

                    $directory_D = DOCROOT . str_replace("\\", "/", $directory);
                    if (!file_exists($directory_D)) {
                        mkdir($directory_D, 0777, true);
                    }

                    $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
                    if (!file_exists($directory_thumbs_D)) {
                        mkdir($directory_thumbs_D, 0777, true);
                    }

                    $img = $this->_save_image($_FILES['img'], 1500, 385, $directory, $directory_thumbs);
                    if ($img) {
                        foreach (array('img', 'img_thumb') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }

                        $objj->img = $directory . $img;
                        $objj->img_thumb = $directory_thumbs . $img;
                    }
                }
            }
            $objj->values($Filtered_array);
            try {

                if ($objj->save()) {
                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                //To Delete Image From Server If OBJ Not Saved
                if (isset($_FILES['img'])) {
                    if ($img) {
                        foreach (array('img', 'img_thumb') as $value) {
                            if (!empty($objj->$value)) {
                                $DelFilePath = DOCROOT . $objj->$value;
                                if (is_file($DelFilePath)) {
                                    unlink($DelFilePath);
                                }
                            }
                        }
                    }
                }
                //End To Delete Image From Server If OBJ Not Saved

                $errors = $e->errors('');
                $results['Errors'] = General::CatchErrorMSGSAjax($errors);
            }
            echo json_encode($results);
        }
    }

}

// End Slider
