<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Reports extends Controller_Template_Base {

    public $Browse_System_Reports = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        $this->Browse_System_Reports = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_System_Reports')));
    }

    public function action_index() {
        if ($this->Browse_System_Reports) {
            $this->template->title = Lang::__('Reports');
            $this->template->layout = new View('system/reports/view_all');
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        if ($this->Browse_System_Reports) {
            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable

            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Students_Logs')
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':
                        $ids = array();
                        foreach ($post['id'] as $value) {
                            if ($this->action_Delete($value) === FALSE) {
                                array_push($ids, $value);
                            }
                        }

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['token'])) {
                    $token = $post['token'];
                    $All_ORM->where(DB::expr('lower(token)'), 'LIKE', mb_strtolower("%$token%"));
                }
                if (!empty($post['txt_ar'])) {
                    $txt_ar = $post['txt_ar'];
                    $All_ORM->where(DB::expr('lower(txt_ar)'), 'LIKE', mb_strtolower("%$txt_ar%"));
                }
                if (!empty($post['txt_en'])) {
                    $txt_en = $post['txt_en'];
                    $All_ORM->where(DB::expr('lower(txt_en)'), 'LIKE', mb_strtolower("%$txt_en%"));
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {


                $text = $value->Operation->{'title_' . $this->lang};
                if ($value->old_int_val != NULL) {
                    $text .= '</br>' . Lang::__('old_int_val') . ' = ' . $value->old_int_val;
                }
                if ($value->new_int_val != NULL) {
                    $text .= '</br>' . Lang::__('new_int_val') . ' = ' . $value->new_int_val;
                }

                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $text,
                    $value->Created_by_User->{'name_' . $this->lang},
                    $value->Created_date,
                    '',
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

}
