<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Pagescp extends Controller_Template_Base {

    public $Add = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Browse = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Pages')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Pages')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Pages')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Pages')));
    }

    public function action_index() {
        if ($this->Add || $this->Edit || $this->Delete || $this->Browse) {
            $title = Lang::__('Pages');
            $this->template->title = $title;
            $this->template->layout = new View('system/pages/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Pages', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/pages/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;

                $this->template->layout->content_ar = $this->action_Img_Replaces($Obj->{'content_ar'});
                $this->template->layout->content_en = $this->action_Img_Replaces($Obj->{'content_en'});
            }
            $this->template->layout->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Img_Replaces($Html_Code) {
        if (!empty($Html_Code)) {
            $doc = new DOMDocument();
            $doc->loadHTML(mb_convert_encoding($Html_Code, 'HTML-ENTITIES', 'UTF-8'));
            $tags = $doc->getElementsByTagName('img');
            foreach ($tags as $tag) {
                $old_src = $tag->getAttribute('src');
                $new_src_url = URL::base() . $old_src;
                $tag->setAttribute('src', $new_src_url);
            }
            return $doc->saveHTML();
        } else {
            return $Html_Code;
        }
    }

    public function action_Delete() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $Obj = ORM::factory('Pages', $Filtered_array['id']);
        if ($Obj->loaded()) {
            if ($this->Delete) {
                $Obj->is_deleted = 1;
                $Obj->deleted_by = $this->user_online->id;
                $Obj->deleted_date = date("Y-m-d H:i:s");
                if ($Obj->save()) {
                    $results['Resp'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Deletion has been successfully'),
                        'life' => '2000', //1000 is 1 second
                        'text' => $Obj->{'title_' . $this->lang} . ' ' . Lang::__('has been deleted successfully'),
                    );
                }
            } else {
                $results['Resp'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Error'),
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('Not_found_the_desired_item'),
            );
        }
        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Pages', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }

        //لحذف مقدمة موقع الصور لتسهيل استخدامها لاحقا
        if (!empty($Filtered_array['content_ar'])) {
            $Filtered_array['content_ar'] = str_replace('img src="' . URL::base(), 'img src="', $Filtered_array['content_ar']);
            $Filtered_array['content_ar'] = str_replace('" src="' . URL::base(), '" src="', $Filtered_array['content_ar']);
        }
        if (!empty($Filtered_array['content_en'])) {
            $Filtered_array['content_en'] = str_replace('img src="' . URL::base(), 'img src="', $Filtered_array['content_en']);
            $Filtered_array['content_en'] = str_replace('" src="' . URL::base(), '" src="', $Filtered_array['content_en']);
        }


        $objj->values($Filtered_array);
        try {
            if ($objj->save()) {
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            $img->save($directory . $filename, 100);
            $img->resize($width, $height, Image::INVERSE);
            $img->save($directory_thumbs . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Pages')->where('is_deleted', '=', NULL)->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();

        // Convert Object to array
        $array_ = Search::action_FindAll_To_Array($All_ORM);
        // End Convert Object to array 

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $ids = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_Delete($value) === FALSE) {
                            array_push($ids, $value);
                        }
                    }

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            $array_1 = array();
            foreach ($All_ORM as $value) {
                if (
                        ((!empty($post['name'])) && ((strpos(mb_strtolower($value->title_ar), mb_strtolower($post['name'])) !== false) || strpos(mb_strtolower($value->title_en), mb_strtolower($post['name'])) !== false)) || (((!empty($post['max_students_no_from']) && !empty($post['max_students_no_to']))) && ($value->max_students_no >= $post['max_students_no_from'] && $value->max_students_no <= $post['max_students_no_to'])) || (((!empty($post['max_students_no_from']) && empty($post['max_students_no_to']))) && ($value->max_students_no >= $post['max_students_no_from'])) || (((empty($post['max_students_no_from']) && !empty($post['max_students_no_to']))) && ($value->max_students_no <= $post['max_students_no_to']))
                ) {
                    array_push($array_1, $value->id);
                }
            }
        }

        /*
         * Paging
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            $iTotalRecords = count($array_1);
        } else {
            $iTotalRecords = count($array_);
        }

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;



        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            $output = array_slice($array_1, $iDisplayStart, $iDisplayLength);
            $Search_objs = array();
            foreach ($output as $value) {
                array_push($Search_objs, Search::action_GetOne($array_, 'id', $value));
            }
        } else {
            $Search_objs = array_slice($array_, $iDisplayStart, $iDisplayLength);
        }



        /*
         * Prepare JSON Array
         */
        $Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        foreach ($Search_objs as $key => $value) {
            $buttons = '';
            $buttons .= '<a target="_blank" href="' . URL::base() . 'Page/view/' . $value['id'] . '" class="btn btn-xs blue" > ' . Lang::__('View in website') . '</a>';
            ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Pagescp/AE/' . $value['id'] . '" class="btn btn-xs default EDIT" data-toggle="modal"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete) ? $buttons .= '<a par1="' . $value['id'] . '" par2="" class="btn btn-xs red Delete" data-toggle="modal"><i class="fa fa-times"></i> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value['id'] . '">',
                $value['title_' . $this->lang],
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
