<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Onlinereg extends Controller_Template_Site {

    public function action_New() {

        $ReqType = mb_strtolower($this->request->param('par1'));

        if ($ReqType == 'ba' || $ReqType == 'ma') {
            $State_Of_Reg = NULL;
            if ($ReqType == "ba") {
                $State_Of_Reg = ORM::factory('Variables', 69)->value;
            } elseif ($ReqType == "ma") {
                $State_Of_Reg = ORM::factory('Variables', 70)->value;
            }
            //فحص هل التسجيل مفتوح من قبل الادارة
          //  if (mb_strtolower($State_Of_Reg) == 'open' || $objj->loaded()) {
            if (mb_strtolower($State_Of_Reg) == 'open' ) {
                $this->template->layout = new View('site/online_registration/step1_agreement');

                $title = "";
                switch ($ReqType) {
                    case 'ba':
                        $ReqType = 'ba';
                        $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                        $this->template->layout->Agreement = ORM::factory('Variables', 67)->{'text_' . $this->lang};

                        break;
                    case 'ma':
                        $ReqType = 'ma';
                        $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                        $this->template->layout->Agreement = ORM::factory('Variables', 68)->{'text_' . $this->lang};

                        break;

                    default:
                        $title = "";
                        break;
                }




                $this->template->layout->title = $title;
                $this->template->layout->ReqType = $ReqType;
                $this->template->title = $title;

                $this->template->layout->lang = $this->lang;
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('New applications are currently unavailable');
            }
        }
    }

    public function action_StepA() {

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());


        $objj = ORM::factory('Students_Applications', $this->request->param("par1"));
        if ($objj->loaded()) {
            $ReqType = $objj->app_type;
            $Study_MajorsOBJ = $objj->Major;
        } else {
            $ReqType = empty($Filtered_array['RType']) ? NULL : $Filtered_array['RType'];
            $major = empty($Filtered_array['major']) ? NULL : $Filtered_array['major'];
            $Study_MajorsOBJ = ORM::factory('Study_Majors', $major);
        }

        if (($objj->loaded() && $this->CheckSession($objj) && !$objj->App_Affect_by_admins()) || ( (!$objj->loaded()) && $Study_MajorsOBJ->loaded() && ($ReqType == 'ba' || $ReqType == 'ma'))) {


            $State_Of_Reg = NULL;
            if ($ReqType == "ba") {
                $State_Of_Reg = ORM::factory('Variables', 69)->value;
            } elseif ($ReqType == "ma") {
                $State_Of_Reg = ORM::factory('Variables', 70)->value;
            }
            //فحص هل التسجيل مفتوح من قبل الادارة

            if (mb_strtolower($State_Of_Reg) == 'open' || $objj->loaded()) {
                $this->template->layout = new View('site/online_registration/stepA');

                $title = "";
                $sub_title = Lang::__('Applicant info');

                switch ($ReqType) {

                    case 'ba':
                        $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                        $Agreement = ORM::factory('Variables', 67)->{'text_' . $this->lang};
                        break;
                    case 'ma':
                        $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                        $Agreement = ORM::factory('Variables', 68)->{'text_' . $this->lang};

                        break;

                    default:
                        $title = "";
                        break;
                }

                //الجنسيات
                $this->template->layout->Nationalities = ORM::factory('General_Countries')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                $this->template->layout->Steps_Array = General::Steps_Of_Admission_Application($objj, 'StepA');

                if (isset($objj) && $objj->loaded()) {
                    $this->template->layout->Obj = $objj;
                }
                $this->template->layout->ReqType = $ReqType;
                $this->template->layout->Study_MajorsOBJ = $Study_MajorsOBJ;
                $this->template->layout->title = $title;
                $this->template->layout->sub_title = $sub_title;
                $this->template->title = $title;

                $this->template->layout->lang = $this->lang;
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
            }
        } elseif ($objj->loaded() && $this->CheckSession($objj) && $objj->App_Affect_by_admins()) {
            $this->template->layout = new View('site/online_registration/show_app_info');
            $lang_c = ($this->lang == 'ar') ? 'Arabic' : 'English';
            $title = Lang::__('Admission application') . ' ' . $objj->{'Full_Name_' . $lang_c};
            $this->template->title = $title;
            $this->template->layout->title = $title;
            $this->template->layout->Obj = $objj;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Documents = $objj->Documents->where('is_deleted', '=', NULL)->find_all();
            ;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_StepAToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $objj = ORM::factory('Students_Applications', $Filtered_array['par1']);

        if ((!$objj->loaded()) || ($objj->loaded() && $this->CheckSession($objj) && !$objj->App_Affect_by_admins())) {
            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online;
                $objj->Created_date = date("Y-m-d H:i:s");
                $objj->need_to_review = 1;
                $objj->ip_of_application = Detects::get_client_ip();
                $objj->device = Detects::getDevice();
                $objj->os = Detects::getOS();
                $objj->browser = Detects::getBrowser();


                //Generate App id
                $app_id = date('y') . Text::random('nozero', 8);
                while (TRUE) {
                    $check = ORM::factory('Students_Applications')->where('app_id', '=', $app_id)->find();
                    if ($check->loaded()) {
                        $app_id = date('y') . Text::random('nozero', rand(4, 7));
                    } else {
                        break;
                    }
                }
                $objj->app_id = $app_id;
                $objj->app_password = mb_strtolower(Text::random('nozero', rand(4, 7)));
                //End Generate App id
            }

            if (isset($Filtered_array['bd_year_gregorian']) && isset($Filtered_array['bd_month_gregorian']) && isset($Filtered_array['bd_day_gregorian'])) {
                $Filtered_array['Date_of_Birth'] = $Filtered_array['bd_year_gregorian'] . '-' . $Filtered_array['bd_month_gregorian'] . '-' . $Filtered_array['bd_day_gregorian'];
            }
            if (isset($Filtered_array['bd_year']) && isset($Filtered_array['bd_month']) && isset($Filtered_array['bd_day'])) {
                $Filtered_array['Date_of_Birth_higri'] = $Filtered_array['bd_year'] . '-' . $Filtered_array['bd_month'] . '-' . $Filtered_array['bd_day'];
            }


            if (isset($Filtered_array['ID_Expiry_year_gregorian']) && isset($Filtered_array['ID_Expiry_month_gregorian']) && isset($Filtered_array['ID_Expiry_day_gregorian'])) {
                $Filtered_array['ID_Expiry_Date'] = $Filtered_array['ID_Expiry_year_gregorian'] . '-' . $Filtered_array['ID_Expiry_month_gregorian'] . '-' . $Filtered_array['ID_Expiry_day_gregorian'];
            }
            if (isset($Filtered_array['ID_Expiry_year']) && isset($Filtered_array['ID_Expiry_month']) && isset($Filtered_array['ID_Expiry_day'])) {
                $Filtered_array['ID_Expiry_Date_higri'] = $Filtered_array['ID_Expiry_year'] . '-' . $Filtered_array['ID_Expiry_month'] . '-' . $Filtered_array['ID_Expiry_day'];
            }

            //Keep only this step fields
            $StepAFields = array('app_type', 'Office_Phone', 'major', 'Full_Name_Arabic', 'Full_Name_English', 'Place_of_birth', 'Date_of_Birth', 'Date_of_Birth_higri', 'Gender', 'Nationality', 'ID_No', 'ID_Expiry_Date', 'ID_Expiry_Date_higri', 'Mobile', 'Phone', 'Email', 'Address');
            foreach ($Filtered_array as $key => $value) {
                if (!in_array($key, $StepAFields)) {
                    unset($Filtered_array[$key]);
                }
            }
            //End Keep only this step fields

            $objj->values($Filtered_array);
            try {
                $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->StepAJqueryRules($objj, FALSE));

                if ($objj->save($extra_rules)) {

                    switch ($objj->app_type) {
                        case 'ba':
                            //تقييد رسوم الدفع
                            $objj->amount_to_pay = ORM::factory('Variables', 73)->value;
                            if (empty(ORM::factory('Variables', 73)->value)) {
                                $objj->amount_paid = 2;
                            }
                            $objj->save();

                            break;
                        case 'ma':
                            //تقييد رسوم الدفع
                            $objj->amount_to_pay = ORM::factory('Variables', 74)->value;
                            if (empty(ORM::factory('Variables', 74)->value)) {
                                $objj->amount_paid = 2;
                            }
                            $objj->save();

                            break;

                        default:
                            break;
                    }

                    if (($objj->Nationality == 1) || (!empty($objj->Nationalitie->GCC))) {
                        $results['RedURL'] = URL::base() . 'Onlinereg/StepC/' . $objj->id;
                    } else {
                        $results['RedURL'] = URL::base() . 'Onlinereg/StepB/' . $objj->id;
                    }

                    $msg_to_user = Lang::__('Saved successfully, now you will be redirected automatically to next step');

                    $this->SetStepAsFinish($objj, "A");


                    $session = Session::instance();

                    // Find existing data
                    $data = $session->get('Students_app_Arr');

                    // Add new array
                    $data[] = array('id' => $objj->app_id, 'password' => $objj->app_password);

                    // Resave it
                    if ($session->set('Students_app_Arr', $data)) {
                        $results['Success'] = array(
                            'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                            'horizontalEdge' => 'top', //top,bottom
                            'verticalEdge' => 'right', //right,left
                            'heading' => '',
                            'life' => '0', //1000 is 1 second
                            'text' => $msg_to_user,
                        );
                    }
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = General::CatchErrorMSGSAjax($errors);
            }
        } else {
            
        }

        echo json_encode($results);
    }

    public function action_StepB() {

        $objj = ORM::factory('Students_Applications', $this->request->param("par1"));
        if (($objj->Nationality == 1) || (!empty($objj->Nationalitie->GCC))) {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('This step is not required for GCC nationals');
        } else {
            if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj) === TRUE)) {
                $StepsAllow = ORM::factory('Students_Applications_Steps')
                        ->where('student_application_id', '=', $objj->id)
                        ->where('step', 'IN', array('A', 'B'))
                        ->find();
                if ($StepsAllow->loaded()) {
                    if ($objj->app_type == 'ba' || $objj->app_type == 'ma') {
                        $State_Of_Reg = NULL;
                        if ($objj->app_type == "ba") {
                            $State_Of_Reg = ORM::factory('Variables', 69)->value;
                        } elseif ($objj->app_type == "ma") {
                            $State_Of_Reg = ORM::factory('Variables', 70)->value;
                        }
                        //فحص هل التسجيل مفتوح من قبل الادارة
                        if (mb_strtolower($State_Of_Reg) == 'open') {

                            $this->template->layout = new View('site/online_registration/stepB');
                            $sub_title = Lang::__('Sponsor information');
                            $title = "";
                            switch ($objj->app_type) {
                                case 'ba':
                                    $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                                    break;
                                case 'ma':
                                    $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                                    break;

                                default:
                                    $title = "";
                                    break;
                            }
                            $this->template->layout->Steps_Array = General::Steps_Of_Admission_Application($objj, 'StepB');

                            $this->template->layout->Obj = $objj;
                            $this->template->layout->sub_title = $sub_title;
                            $this->template->layout->title = $title;
                            $this->template->title = $title;

                            $this->template->layout->lang = $this->lang;
                        } else {
                            $this->template->layout = new View('site/error');
                            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                        }
                    } else {
                        $this->template->layout = new View('site/error');
                        $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                    }
                } else {
                    $this->template->layout = new View('site/error');
                    $this->template->layout->MSG = Lang::__('You must complete the previous steps before you reach this step');
                }
            } elseif ($objj->loaded() && $this->CheckSession($objj) && $objj->App_Affect_by_admins()) {
                $this->template->layout = new View('site/online_registration/show_app_info');
                $lang_c = ($this->lang == 'ar') ? 'Arabic' : 'English';
                $title = Lang::__('Admission application') . ' ' . $objj->{'Full_Name_' . $lang_c};
                $this->template->title = $title;
                $this->template->layout->title = $title;
                $this->template->layout->Obj = $objj;
                $this->template->layout->lang = $this->lang;
                $this->template->layout->Documents = $objj->Documents->where('is_deleted', '=', NULL)->find_all();
                ;
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
            }
        }
    }

    public function action_StepBToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($Filtered_array['par1'])) {
            $objj = ORM::factory('Students_Applications', $Filtered_array['par1']);
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('A', 'B'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj))) {
                    //Keep only this step fields
                    $StepFields = array('Sponsor_Full_Name_Arabic', 'Sponsor_Full_Name_English', 'Sponsor_Mobile', 'Sponsor_Office_number', 'Sponsor_Email', 'Sponsor_Legal_Form', 'Sponsor_Address');
                    foreach ($Filtered_array as $key => $value) {
                        if (!in_array($key, $StepFields)) {
                            unset($Filtered_array[$key]);
                        }
                    }
                    //End Keep only this step fields
                    $objj->values($Filtered_array);
                    try {
                        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->StepBJqueryRules($objj, FALSE));

                        if ($objj->save($extra_rules)) {
                            $results['RedURL'] = URL::base() . 'Onlinereg/StepC/' . $objj->id;

                            $this->SetStepAsFinish($objj, "B");

                            $msg_to_user = Lang::__('Saved successfully, now you will be redirected automatically to next step');

                            $results['Success'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => '',
                                'life' => '0', //1000 is 1 second
                                'text' => $msg_to_user,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                    }
                }
            }
        }


        echo json_encode($results);
    }

    public function action_StepC() {

        $objj = ORM::factory('Students_Applications', $this->request->param("par1"));
        if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj) === TRUE)) {

            if (($objj->Nationality == 1) || !empty($objj->Nationalitie->GCC)) {
                $All_St_all = array('A', 'C');
            } else {
                $All_St_all = array('B', 'C');
            }
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', $All_St_all)
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->app_type == 'ba' || $objj->app_type == 'ma') {
                    $State_Of_Reg = NULL;
                    if ($objj->app_type == "ba") {
                        $State_Of_Reg = ORM::factory('Variables', 69)->value;
                    } elseif ($objj->app_type == "ma") {
                        $State_Of_Reg = ORM::factory('Variables', 70)->value;
                    }
                    //فحص هل التسجيل مفتوح من قبل الادارة
                    if (mb_strtolower($State_Of_Reg) == 'open' || $objj->loaded()) {

                        $this->template->layout = new View('site/online_registration/stepC');
                        $sub_title = Lang::__('Study History');
                        $title = "";
                        switch ($objj->app_type) {
                            case 'ba':
                                $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                                break;
                            case 'ma':
                                $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                                break;

                            default:
                                $title = "";
                                break;
                        }
                        //الجنسيات
                        $this->template->layout->Nationalities = ORM::factory('General_Countries')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                        $this->template->layout->Hscertypes = ORM::factory('General_Hscertypes')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();

                        $this->template->layout->Steps_Array = General::Steps_Of_Admission_Application($objj, 'StepC');
                        $this->template->layout->Obj = $objj;
                        $this->template->layout->sub_title = $sub_title;
                        $this->template->layout->title = $title;
                        $this->template->title = $title;

                        $this->template->layout->lang = $this->lang;
                    } else {
                        $this->template->layout = new View('site/error');
                        $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                    }
                } else {
                    $this->template->layout = new View('site/error');
                    $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                }
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('You must complete the previous steps before you reach this step');
            }
        } elseif ($objj->loaded() && $this->CheckSession($objj) && $objj->App_Affect_by_admins()) {
            $this->template->layout = new View('site/online_registration/show_app_info');
            $lang_c = ($this->lang == 'ar') ? 'Arabic' : 'English';
            $title = Lang::__('Admission application') . ' ' . $objj->{'Full_Name_' . $lang_c};
            $this->template->title = $title;
            $this->template->layout->title = $title;
            $this->template->layout->Obj = $objj;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Documents = $objj->Documents->where('is_deleted', '=', NULL)->find_all();
            ;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_StepCToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($Filtered_array['par1'])) {
            $objj = ORM::factory('Students_Applications', $Filtered_array['par1']);
            if (($objj->Nationality == 1) || !empty($objj->Nationalitie->GCC)) {
                $All_St_all = array('A', 'C');
            } else {
                $All_St_all = array('B', 'C');
            }
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', $All_St_all)
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj))) {

                    //Keep only this step fields
                    $StepFields = array('hs_School_Name', 'hs_Certificate_Type', 'hs_Certificate_Type', 'hs_Qudurat_points', 'hs_Tofel_Points', 'hs_Country', 'hs_Graduation_Year', 'hs_Percentage', 'hs_Grade_total', 'hs_Tahsele_Points', 'hs_City');
                    if ($objj->app_type == 'ma') {
                        $StepFields = array_merge($StepFields, array('ba_College', 'ba_University', 'ba_Major', 'ba_General_Grade', 'ba_GPA', 'ba_Grade_Total', 'ba_Graduation_Year'));
                    }
                    foreach ($Filtered_array as $key => $value) {
                        if (!in_array($key, $StepFields)) {
                            unset($Filtered_array[$key]);
                        }
                    }
                    //End Keep only this step fields

                    $objj->values($Filtered_array);
                    try {
                        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->StepCJqueryRules($objj, FALSE));

                        if ($objj->save($extra_rules)) {
                            $results['RedURL'] = URL::base() . 'Onlinereg/StepD/' . $objj->id;

                            $this->SetStepAsFinish($objj, "C");

                            $msg_to_user = Lang::__('Saved successfully, now you will be redirected automatically to next step');

                            $results['Success'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => '',
                                'life' => '0', //1000 is 1 second
                                'text' => $msg_to_user,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                    }
                }
            }
        }


        echo json_encode($results);
    }

    public function action_StepD() {

        $objj = ORM::factory('Students_Applications', $this->request->param("par1"));
        if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj) === TRUE)) {
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('C', 'D'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->app_type == 'ba' || $objj->app_type == 'ma') {
                    $State_Of_Reg = NULL;
                    if ($objj->app_type == "ba") {
                        $State_Of_Reg = ORM::factory('Variables', 69)->value;
                    } elseif ($objj->app_type == "ma") {
                        $State_Of_Reg = ORM::factory('Variables', 70)->value;
                    }
                    //فحص هل التسجيل مفتوح من قبل الادارة
                    if (mb_strtolower($State_Of_Reg) == 'open' || $objj->loaded()) {

                        $this->template->layout = new View('site/online_registration/stepD');
                        $sub_title = Lang::__('Gardian information');
                        $title = "";
                        switch ($objj->app_type) {
                            case 'ba':
                                $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                                break;
                            case 'ma':
                                $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                                break;

                            default:
                                $title = "";
                                break;
                        }
                        //الجنسيات
                        $this->template->layout->Nationalities = ORM::factory('General_Countries')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                        $this->template->layout->Sprelations = ORM::factory('General_Sprelations')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                        $this->template->layout->Edulevels = ORM::factory('General_Edulevels')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                        $this->template->layout->Steps_Array = General::Steps_Of_Admission_Application($objj, 'StepD');

                        $this->template->layout->Obj = $objj;
                        $this->template->layout->sub_title = $sub_title;
                        $this->template->layout->title = $title;
                        $this->template->title = $title;

                        $this->template->layout->lang = $this->lang;
                    } else {
                        $this->template->layout = new View('site/error');
                        $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                    }
                } else {
                    $this->template->layout = new View('site/error');
                    $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                }
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('You must complete the previous steps before you reach this step');
            }
        } elseif ($objj->loaded() && $this->CheckSession($objj) && $objj->App_Affect_by_admins()) {
            $this->template->layout = new View('site/online_registration/show_app_info');
            $lang_c = ($this->lang == 'ar') ? 'Arabic' : 'English';
            $title = Lang::__('Admission application') . ' ' . $objj->{'Full_Name_' . $lang_c};
            $this->template->title = $title;
            $this->template->layout->title = $title;
            $this->template->layout->Obj = $objj;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Documents = $objj->Documents->where('is_deleted', '=', NULL)->find_all();
            ;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_StepDToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($Filtered_array['par1'])) {
            $objj = ORM::factory('Students_Applications', $Filtered_array['par1']);
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('C', 'D'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj))) {
                    //Keep only this step fields
                    $StepFields = array('g_Full_Name_Arabic', 'g_Full_Name_English', 'g_Nationality', 'g_email', 'g_job_title', 'g_Address', 'g_id_number', 'g_mobile', 'g_relation', 'g_home_number', 'g_employer', 'g_study_level');
                    foreach ($Filtered_array as $key => $value) {
                        if (!in_array($key, $StepFields)) {
                            unset($Filtered_array[$key]);
                        }
                    }
                    //End Keep only this step fields
                    $objj->values($Filtered_array);
                    try {
                        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->StepDJqueryRules($objj, FALSE));

                        if ($objj->save($extra_rules)) {
                            $results['RedURL'] = URL::base() . 'Onlinereg/StepE/' . $objj->id;

                            $this->SetStepAsFinish($objj, "D");

                            $msg_to_user = Lang::__('Saved successfully, now you will be redirected automatically to next step');

                            $results['Success'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => '',
                                'life' => '0', //1000 is 1 second
                                'text' => $msg_to_user,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                    }
                }
            }
        }


        echo json_encode($results);
    }

    /*
     * Work details form For E step in ajax 
     */

    public function action_StepEEmplyeeDetails($id = NULL) {
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = (empty($Filtered_array['par1'])) ? $id : $Filtered_array['par1'];

        $objj = ORM::factory('Students_Applications', $par1);

        $stepE_workDetails = View::factory('site/online_registration/stepE_workDetails');
        if ($objj->loaded()) {
            $stepE_workDetails->set('Obj', $objj);
        }
        if (empty($id)) {
            echo $stepE_workDetails;
        } else {
            return $stepE_workDetails;
        }
    }

    public function action_StepE() {

        $objj = ORM::factory('Students_Applications', $this->request->param("par1"));
        if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj) === TRUE)) {
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('D', 'E'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->app_type == 'ba' || $objj->app_type == 'ma') {
                    $State_Of_Reg = NULL;
                    if ($objj->app_type == "ba") {
                        $State_Of_Reg = ORM::factory('Variables', 69)->value;
                    } elseif ($objj->app_type == "ma") {
                        $State_Of_Reg = ORM::factory('Variables', 70)->value;
                    }
                    //فحص هل التسجيل مفتوح من قبل الادارة
                    if (mb_strtolower($State_Of_Reg) == 'open' || $objj->loaded()) {

                        $this->template->layout = new View('site/online_registration/stepE');
                        $sub_title = Lang::__('Employment information');
                        $title = "";
                        switch ($objj->app_type) {
                            case 'ba':
                                $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                                break;
                            case 'ma':
                                $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                                break;

                            default:
                                $title = "";
                                break;
                        }
                        $this->template->layout->Steps_Array = General::Steps_Of_Admission_Application($objj, 'StepE');

                        $this->template->layout->Obj = $objj;
                        if ($objj->E_Employeed == 'yes') {
                            $this->template->layout->EmplyeeDetails = $this->action_StepEEmplyeeDetails($objj->id);
                        }
                        $this->template->layout->sub_title = $sub_title;
                        $this->template->layout->title = $title;
                        $this->template->title = $title;

                        $this->template->layout->lang = $this->lang;
                    } else {
                        $this->template->layout = new View('site/error');
                        $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                    }
                } else {
                    $this->template->layout = new View('site/error');
                    $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                }
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('You must complete the previous steps before you reach this step');
            }
        } elseif ($objj->loaded() && $this->CheckSession($objj) && $objj->App_Affect_by_admins()) {
            $this->template->layout = new View('site/online_registration/show_app_info');
            $lang_c = ($this->lang == 'ar') ? 'Arabic' : 'English';
            $title = Lang::__('Admission application') . ' ' . $objj->{'Full_Name_' . $lang_c};
            $this->template->title = $title;
            $this->template->layout->title = $title;
            $this->template->layout->Obj = $objj;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Documents = $objj->Documents->where('is_deleted', '=', NULL)->find_all();
            ;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_StepEToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($Filtered_array['par1'])) {
            $objj = ORM::factory('Students_Applications', $Filtered_array['par1']);
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('D', 'E'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj))) {
                    $objj->values($Filtered_array);
                    try {
                        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->StepEJqueryRules($objj, FALSE));

                        if ($objj->save($extra_rules)) {
                            $results['RedURL'] = URL::base() . 'Onlinereg/StepF/' . $objj->id;

                            $this->SetStepAsFinish($objj, "E");

                            $msg_to_user = Lang::__('Saved successfully, now you will be redirected automatically to next step');

                            $results['Success'] = array(
                                'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                                'horizontalEdge' => 'top', //top,bottom
                                'verticalEdge' => 'right', //right,left
                                'heading' => '',
                                'life' => '0', //1000 is 1 second
                                'text' => $msg_to_user,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                    }
                }
            }
        }


        echo json_encode($results);
    }

    public function action_StepF() {

        $objj = ORM::factory('Students_Applications', $this->request->param("par1"));
        if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj) === TRUE)) {
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('E', 'F'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->app_type == 'ba' || $objj->app_type == 'ma') {
                    $State_Of_Reg = NULL;
                    if ($objj->app_type == "ba") {
                        $State_Of_Reg = ORM::factory('Variables', 69)->value;
                    } elseif ($objj->app_type == "ma") {
                        $State_Of_Reg = ORM::factory('Variables', 70)->value;
                    }
                    //فحص هل التسجيل مفتوح من قبل الادارة
                    if (mb_strtolower($State_Of_Reg) == 'open' || $objj->loaded()) {

                        $this->template->layout = new View('site/online_registration/stepF');
                        $this->template->layout->Documents = ORM::factory('Students_Applications_Documents_Types')->where('student_application_type', '=', $objj->app_type)->where('is_deleted', '=', NULL)->find_all();
                        $sub_title = Lang::__('Required documents');
                        $title = "";
                        switch ($objj->app_type) {
                            case 'ba':
                                $title = ORM::factory('Variables', 65)->{'value_' . $this->lang};
                                break;
                            case 'ma':
                                $title = ORM::factory('Variables', 66)->{'value_' . $this->lang};
                                break;

                            default:
                                $title = "";
                                break;
                        }
                        $this->template->layout->Steps_Array = General::Steps_Of_Admission_Application($objj, 'StepF');

                        $this->template->layout->Obj = $objj;

                        $StepF = ORM::factory('Students_Applications_Steps')
                                ->where('student_application_id', '=', $objj->id)
                                ->where('step', '=', 'F')
                                ->find();

                        if ($StepF->loaded()) {
                            $this->template->layout->Not_New_App = 1;
                        }

                        $this->template->layout->sub_title = $sub_title;
                        $this->template->layout->title = $title;
                        $this->template->title = $title;

                        $this->template->layout->lang = $this->lang;
                    } else {
                        $this->template->layout = new View('site/error');
                        $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                    }
                } else {
                    $this->template->layout = new View('site/error');
                    $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
                }
            } else {
                $this->template->layout = new View('site/error');
                $this->template->layout->MSG = Lang::__('You must complete the previous steps before you reach this step');
            }
        } elseif ($objj->loaded() && $this->CheckSession($objj) && $objj->App_Affect_by_admins()) {
            $this->template->layout = new View('site/online_registration/show_app_info');
            $lang_c = ($this->lang == 'ar') ? 'Arabic' : 'English';
            $title = Lang::__('Admission application') . ' ' . $objj->{'Full_Name_' . $lang_c};
            $this->template->title = $title;
            $this->template->layout->title = $title;
            $this->template->layout->Obj = $objj;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Documents = $objj->Documents->where('is_deleted', '=', NULL)->find_all();
            ;
        } else {
            $this->template->layout = new View('site/error');
            $this->template->layout->MSG = Lang::__('You tracked wrong or expired link');
        }
    }

    public function action_StepFToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        if (!empty($Filtered_array['par1'])) {
            $objj = ORM::factory('Students_Applications', $Filtered_array['par1']);
            $StepsAllow = ORM::factory('Students_Applications_Steps')
                    ->where('student_application_id', '=', $objj->id)
                    ->where('step', 'IN', array('E', 'F'))
                    ->find();
            if ($StepsAllow->loaded()) {
                if ($objj->loaded() && !$objj->App_Affect_by_admins() && ($this->CheckSession($objj))) {
                    try {
                        if ($this->request->method() == Request::POST) {
                            $Documents = ORM::factory('Students_Applications_Documents_Types')->where('student_application_type', '=', $objj->app_type)->where('is_deleted', '=', NULL)->find_all();
                            $doc_req_not_uploaded_problem = array(); //مستندات مطلوبة تعذر رفعها
                            $doc_req_not_uploaded = array(); //مستندات مطلوبة لم يتم رفعها
                            foreach ($Documents as $Document_type) {
                                $DocumentRel = ORM::factory('Students_Applications_Documents')
                                        ->where('student_application_id', '=', $objj->id)
                                        ->where('document_type', '=', $Document_type->id)
                                        ->where('is_deleted', '=', NULL)
                                        ->find();
                                $FileS = $_FILES['Document' . $Document_type->id];
                                if (isset($FileS) && Upload::valid($FileS) && Upload::not_empty($FileS)) {

                                    $img = $this->_save_file($FileS, explode(',', $Document_type->allow_file_ext), $Document_type);
                                    if ($img) {

                                        if ($DocumentRel->loaded()) {
                                            if (file_exists(DOCROOT . $DocumentRel->file_path) && is_dir(DOCROOT . $DocumentRel->file_path)) {
                                                unlink(DOCROOT . $DocumentRel->file_path);
                                            }
                                            $DocumentRel->file_path = $img;
                                            $DocumentRel->last_update_by = ($this->user_online) ? $this->user_online->id : NULL;
                                            $DocumentRel->last_update_date = date("Y-m-d H:i:s");
                                        } else {
                                            $DocumentRel->student_application_id = $objj->id;
                                            $DocumentRel->document_type = $Document_type->id;
                                            $DocumentRel->Created_by = ($this->user_online) ? $this->user_online->id : NULL;
                                            $DocumentRel->Created_date = date("Y-m-d H:i:s");
                                        }
                                        $DocumentRel->file_path = $img;
                                        $DocumentRel->save();
                                    } else {
                                        if ($Document_type->required == 1 && (!$DocumentRel->loaded())) {
                                            array_push($doc_req_not_uploaded_problem, $Document_type->{"name_" . $this->lang});
                                        }
                                    }
                                } else {
                                    if ($Document_type->required == 1 && (!$DocumentRel->loaded())) {
                                        array_push($doc_req_not_uploaded, $Document_type->{"name_" . $this->lang});
                                    }
                                }
                            }
                        }

                        if (empty($doc_req_not_uploaded) && empty($doc_req_not_uploaded_problem)) {

                            $this->SetStepAsFinish($objj, "F");

                            $StepF = ORM::factory('Students_Applications_Steps')
                                    ->where('student_application_id', '=', $objj->id)
                                    ->where('step', '=', 'F')
                                    ->find();

                            if ($StepF->loaded() && empty($StepF->last_update_date)) {
                                $objj->finished = 1;
                                $objj->update();

                                $HtmlMsg = View::factory("site/online_registration/sucess_msg_first_time")->set('objj', $objj)->set('app_id', $objj->app_id)->set('app_password', $objj->app_password)->set('lang', $this->lang)->render();
                                $results['Success'] = array(
                                    'HtmlMsg' => $HtmlMsg,
                                );
                            } else {
                                $results['SuccessR'] = array(
                                    'title' => Lang::__('Done'),
                                    'content' => Lang::__('Saved_successfully'),
                                    'Redirect' => URL::base() . "Onlinereg/StepA/" . $objj->id,
                                );
                            }
                        } else {
                            $msg = '';
                            if (!empty($doc_req_not_uploaded)) {
                                $msg .= "<div>" . Lang::__('You have not uploaded the following documents') . '</br>' . General::ArrayToString($doc_req_not_uploaded) . "</div>";
                            }
                            if (!empty($doc_req_not_uploaded_problem)) {
                                $msg .= "<div style='margin-top:15px;'>" . Lang::__('Unable to upload the following required documents') . '</br>' . General::ArrayToString($doc_req_not_uploaded_problem) . "</div>";
                            }
                            $results['UploadUnSuccessfull'] = array(
                                'RedURL' => URL::base() . 'Onlinereg/stepf/' . $objj->id,
                                'title' => Lang::__('incomplete_upload'),
                                'msg' => $msg,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');
                        $results['Errors'] = General::CatchErrorMSGSAjax($errors);
                    }
                }
            }
        }


        echo json_encode($results);
    }

    protected function _save_file($image, $ext_array, $Document_type) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, $ext_array) OR ! Upload::size($image, $Document_type->max_file_size . 'M')) {
            return FALSE;
        }
        $directory = 'files/students/documents/' . date('Y') . '/' . date('m') . '/' . date('d') . '/';
        $directory_D = DOCROOT . str_replace("\\", "/", $directory);
        if (!file_exists($directory_D)) {
            mkdir($directory_D, 0777, true);
        }

        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $filename = mb_strtolower(Text::random('alnum', 22)) . '.' . $ext;
        if ($file = Upload::save($image, $filename, $directory)) {
            return $directory . $filename;
        } else {
            return FALSE;
        }
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_StepRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        if (in_array($par2, array('A', 'B', 'C', 'D', 'E', 'F'))) {
            $Student_app = ORM::factory('Students_Applications', $par1);

            $MethodName = "Step" . $par2 . "JqueryRules";
            $results['Rules'] = $Student_app->$MethodName($Student_app);
        }


        echo json_encode($results);
    }

    /*
     * تحديد المرحلة كمنتهية
     */

    public function SetStepAsFinish($objj, $StepChar) {
        $Step = ORM::factory('Students_Applications_Steps')
                ->where('student_application_id', '=', $objj->id)
                ->where('step', '=', $StepChar)
                ->find();
        if ($Step->loaded()) {
            $Step->last_update_by = (!empty($this->user_online->id)) ? $this->user_online->id : NULL;
            $Step->last_update_date = date("Y-m-d H:i:s");
            $Step->save();
        } else {
            $Step->student_application_id = $objj->id;
            $Step->step = $StepChar;
            $Step->Created_by = (!empty($this->user_online->id)) ? $this->user_online->id : NULL;
            $Step->Created_date = date("Y-m-d H:i:s");
            $Step->save();
        }
    }

    public function CheckSession($Obj) {
        $Res = FALSE;
        $session = Session::instance();
        // Find existing data
        $data = $session->get('Students_app_Arr');
        if (is_array($data)) {
            foreach ($data as $elm) {
                $id_ = !empty($elm['id']) ? $elm['id'] : NULL;
                $password_ = !empty($elm['password']) ? $elm['password'] : NULL;

                if ((mb_strtolower($id_) == mb_strtolower($Obj->app_id)) && mb_strtolower($password_) == mb_strtolower($Obj->app_password)) {

                    $Res = TRUE;
                }
            }
        }
        return $Res;
    }

    public function action_AppSec() {
        $this->template->title = Lang::__('Follow-up application');
        $this->template->layout = new View('site/online_registration/appsec');
    }

    public function action_AppSecToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = !empty($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $password = !empty($Filtered_array['password']) ? $Filtered_array['password'] : NULL;

        $Obj = ORM::factory('Students_Applications')
                ->where('app_id', '=', $id)
                ->where('app_password', '=', $password)
                ->find();
        if ($Obj->loaded()) {
            $session = Session::instance();

            // Find existing data
            $data = $session->get('Students_app_Arr');

            // Add new array
            $data[] = array('id' => $Obj->app_id, 'password' => $Obj->app_password);

            // Resave it
            if ($session->set('Students_app_Arr', $data)) {
                $results['Success'] = array(
                    "Redirect_url" => URL::base() . 'Onlinereg/stepA/' . $Obj->id,
                );
            }
        } else {
            $results['Errors'] = array(
                "title" => Lang::__('Error'),
                "content" => Lang::__('Wrong_user_name_or_password'),
            );
        }

        echo json_encode($results);
    }

    public function action_UpdateField() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $field_selector = !empty($Filtered_array['field_selector']) ? $Filtered_array['field_selector'] : NULL;
        $field_val = !empty($Filtered_array['field_val']) ? $Filtered_array['field_val'] : NULL;
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;

        $objj = ORM::factory('Students_Applications', $par1);

        if ($objj->loaded() && empty($objj->cancelled_date) && $this->CheckSession($objj) && in_array($field_selector, array('Mobile', 'Phone', 'Email'))) {
            try {


                $objj->$field_selector = $field_val;
                $Re = FALSE;

                if (in_array($field_selector, array('Mobile', 'Phone', 'Email'))) {
                    $extra_rules = General::Jquery_To_ORM_Rules(array($field_selector => $field_val), $objj->StepAJqueryRules($objj, FALSE, $field_selector));
                    $Re = $objj->update($extra_rules);
                }

                if ($Re) {
                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Error_in_data')
            );
        }

        echo json_encode($results);
    }

    public function action_Cancel_Adm_App() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;

        $objj = ORM::factory('Students_Applications', $par1);

        if ($objj->loaded() && (empty($objj->cancelled_date)) && ($objj->Initial_Approval == 1) && empty($objj->is_deleted) && $this->CheckSession($objj)) {
            try {

                $objj->cancelled_date = date("Y-m-d H:i:s");
                $objj->id_can_order_other = 1;

                if ($objj->update()) {
                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Your application has been successfully canceled'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Error_in_data')
            );
        }

        echo json_encode($results);
    }

    public function action_ResetInfo() {
        $title = Lang::__('Retrieve application data');
        $this->template->title = $title;
        $this->template->layout = new View('site/online_registration/ResetInfo');
        $this->template->layout->title = $title;
    }

}

// End Onlinereg
