<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Newscp extends Controller_Template_Base {

    public $Add = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Browse = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

    
        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_News')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_News')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_News')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_News')));
 
        
    }

    public function action_index() {
        if ($this->Add || $this->Edit || $this->Delete || $this->Browse) {
            $title = Lang::__('News');
            $this->template->title = $title;
            $this->template->layout = new View('system/news/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('News', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/news/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }
            $this->template->layout->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
            $this->template->layout->other_details_ar = $this->action_Img_Replaces($Obj->{'other_details_ar'});
            $this->template->layout->other_details_en = $this->action_Img_Replaces($Obj->{'other_details_en'});
            $this->template->layout->images = ORM::factory('Imagescenter')->where('section', '=', 'News')->where('ref_id', '=', $Obj->id)->find_all();
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $Obj = ORM::factory('News', $Filtered_array['id']);
        if ($Obj->loaded()) {
            if ($this->Delete) {
                $Obj->is_deleted = 1;
                $Obj->deleted_by = $this->user_online->id;
                $Obj->deleted_date = date("Y-m-d H:i:s");
                if ($Obj->save()) {
                    $results['Resp'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Deletion has been successfully'),
                        'life' => '2000', //1000 is 1 second
                        'text' => $Obj->{'title_' . $this->lang} . ' ' . Lang::__('has been deleted successfully'),
                    );
                }
            } else {
                $results['Resp'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Error'),
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {
            $results['Resp'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('Not_found_the_desired_item'),
            );
        }
        echo json_encode($results);
    }

    public function action_DeleteIMG() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $Obj = ORM::factory('Imagescenter', $Filtered_array['par1']);
        if ($Obj->loaded()) {
            if ($this->Edit) {
                if (!empty($Obj->img)) {
                    $DelFilePath = DOCROOT . $Obj->img;
                    if (is_file($DelFilePath)) {
                        unlink($DelFilePath);
                    }
                }
                if (!empty($Obj->img_thumb)) {
                    $DelFilePath = DOCROOT . $Obj->img_thumb;
                    if (is_file($DelFilePath)) {
                        unlink($DelFilePath);
                    }
                }

                if ($Obj->delete()) {
                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => Lang::__('Deletion has been successfully'),
                        'life' => '2000', //1000 is 1 second
                        'text' => '',
                    );
                }
            } else {
                $results['Errors'] = array(
                    'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => Lang::__('Error'),
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {
            $results['Errors'] = array(
                'theme' => 'ruby', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                'horizontalEdge' => 'top', //top,bottom
                'verticalEdge' => 'right', //right,left
                'heading' => Lang::__('Error'),
                'life' => '2000', //1000 is 1 second
                'text' => Lang::__('Not_found_the_desired_item'),
            );
        }



        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('News', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");

            if (!empty($objj->stick) && empty($Filtered_array['stick'])) {
                $objj->stick = NULL;
            }
        }

        if ($this->request->method() == Request::POST) {
            if (isset($_FILES['img'])) {
                $directory = 'files/news/' . date('Y') . '/' . date("m") . '/';
                $directory_thumbs = $directory . 'thumbs/';

                $directory_D = DOCROOT . str_replace("\\", "/", $directory);
                if (!file_exists($directory_D)) {
                    mkdir($directory_D, 0777, true);
                }

                $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
                if (!file_exists($directory_thumbs_D)) {
                    mkdir($directory_thumbs_D, 0777, true);
                }

                $img = $this->_save_image($_FILES['img'], 522, 400, $directory, $directory_thumbs);
                if ($img) {
                    foreach (array('img', 'img_thumb') as $value) {
                        if (!empty($objj->$value)) {
                            $DelFilePath = DOCROOT . $objj->$value;
                            if (is_file($DelFilePath)) {
                                unlink($DelFilePath);
                            }
                        }
                    }

                    $objj->img = $directory . $img;
                    $objj->img_thumb = $directory_thumbs . $img;
                }
            }
        }

        //لحذف مقدمة موقع الصور لتسهيل استخدامها لاحقا
        if (!empty($Filtered_array['other_details_ar'])) {
            $Filtered_array['other_details_ar'] = str_replace('img src="' . URL::base(), 'img src="', $Filtered_array['other_details_ar']);
            $Filtered_array['other_details_ar'] = str_replace('" src="' . URL::base(), '" src="', $Filtered_array['other_details_ar']);
        }
        if (!empty($Filtered_array['other_details_en'])) {
            $Filtered_array['other_details_en'] = str_replace('img src="' . URL::base(), 'img src="', $Filtered_array['other_details_en']);
            $Filtered_array['other_details_en'] = str_replace('" src="' . URL::base(), '" src="', $Filtered_array['other_details_en']);
        }

        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {

                //ADD,Edit,Delete Tags
                $All_Current_T = ORM::factory('Relations')
                        ->where('description', '=', 'News_Tags')
                        ->where('new', '=', $objj->id)
                        ->find_all();
                $All_Current_T_arr = array();
                foreach ($All_Current_T as $value) {
                    $All_Current_T_arr[$value->id] = $value->id;
                }
                $Langs = array('ar', 'en', 'he');
                foreach ($Langs as $Lang) {
                    if (!empty($Filtered_array['tags_' . $Lang])) {
                        foreach ($Filtered_array['tags_' . $Lang] as $tag) {
                            $tag = trim(preg_replace('/\s+/', ' ', $tag));
                            $Tags = ORM::factory('Tags')
                                    ->where('name_' . $Lang, '=', $tag)
                                    ->find();
                            if (!$Tags->loaded()) {
                                $Tags->{'name_' . $Lang} = $tag;
                                $Tags->save();
                            }

                            $Relation = ORM::factory('Relations')
                                    ->where('description', '=', 'News_Tags')
                                    ->where('lang', '=', $Lang)
                                    ->where('new', '=', $objj->id)
                                    ->where('tag', '=', $Tags->id)
                                    ->find();
                            if (!$Relation->loaded()) {
                                $Relation->description = 'News_Tags';
                                $Relation->lang = $Lang;
                                $Relation->new = $objj->id;
                                $Relation->tag = $Tags->id;
                                $Relation->Created_date = date("Y-m-d H:i:s");
                                $Relation->Created_by = $this->user_online;
                                $Relation->save();
                            } else {
                                unset($All_Current_T_arr[$Relation->id]);
                            }
                        }
                    }
                }
                foreach ($All_Current_T_arr as $value) {
                    ORM::factory('Relations', $value)->delete();
                }
                //End ADD,Edit,Delete Tags
                ///////////////////////////////////////////////////////////
                if (!empty($_FILES['addimages'])) {
                    // validation file image
                    $files = Validation::factory($_FILES)
                            ->rule('addimages', 'Upload::type', array(':value', array('jpg', 'jpeg', 'png', 'gif')));
                    if ($files->check() && !empty($_FILES['addimages']['name'][0])) {

                        Upload::$remove_spaces = TRUE;
                        $allimg = array();

                        foreach ($_FILES['addimages']["error"] as $key => $value) {

                            $image['name'] = preg_replace('/\s+/', '', $_FILES['addimages']['name'][$key]);
                            $image['type'] = $_FILES['addimages']['type'][$key] . "</br>";
                            $image['tmp_name'] = $_FILES['addimages']['tmp_name'][$key];
                            $image['error'] = $_FILES['addimages']['error'][$key];
                            $image['size'] = $_FILES['addimages']['size'][$key];

                            $array = array('name' => $image['name'],
                                'type' => $image['type'],
                                'tmp_name' => $image['tmp_name'],
                                'error' => $image['error'],
                                'size' => $image['size']);
                            //   print_r($array);
                            array_push($allimg, $array);
                        }

                        foreach ($allimg as $value) {
                            $directory = 'files/news/' . date('Y') . '/' . date("m") . '/';
                            $thumb = $directory . 'thumbs/';

                            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
                            if (!file_exists($directory_D)) {
                                mkdir($directory_D, 0777, true);
                            }

                            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $thumb);
                            if (!file_exists($directory_thumbs_D)) {
                                mkdir($directory_thumbs_D, 0777, true);
                            }
                            $image1 = $this->_save_image($value, 600, 600, $directory, $thumb);
                            if ($image1) {
                                $img = ORM::factory('Imagescenter');
                                $img->section = 'News';
                                $img->ref_id = $objj->id;
                                $img->img = $directory . $image1;
                                $img->img_thumb = $thumb . $image1;
                                $img->Created_by = $this->user_online->id;
                                $img->Created_date = date("Y-m-d H:i:s");
                                $img->save();
                            }
                        }
                    }
                }
                ///////////////////////////////////////////////////////////
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {
            //To Delete Image From Server If OBJ Not Saved
            if (isset($_FILES['img'])) {
                if ($img) {
                    foreach (array('img', 'img_thumb') as $value) {
                        if (!empty($objj->$value)) {
                            $DelFilePath = DOCROOT . $objj->$value;
                            if (is_file($DelFilePath)) {
                                unlink($DelFilePath);
                            }
                        }
                    }
                }
            }
            //End To Delete Image From Server If OBJ Not Saved

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif'))) {
            return FALSE;
        }

        if ($file = Upload::save($image, NULL, $directory)) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

            $img = Image::factory($file);
            $img->save($directory . $filename, 100);
            $img->resize($width, $height, Image::INVERSE);
            $img->crop($width, $height);
            $img->save($directory_thumbs . $filename, 100);

            // Delete the temporary file
            unlink($file);

            return $filename;
        }

        return FALSE;
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('News')->where('is_deleted', '=', NULL)->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();

        // Convert Object to array
        $array_ = Search::action_FindAll_To_Array($All_ORM);
        // End Convert Object to array 

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $ids = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_Delete($value) === FALSE) {
                            array_push($ids, $value);
                        }
                    }

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            $array_1 = array();
            foreach ($All_ORM as $value) {
                if (
                        ((!empty($post['name'])) && ((strpos(mb_strtolower($value->title_ar), mb_strtolower($post['name'])) !== false) || strpos(mb_strtolower($value->title_en), mb_strtolower($post['name'])) !== false)) || (((!empty($post['max_students_no_from']) && !empty($post['max_students_no_to']))) && ($value->max_students_no >= $post['max_students_no_from'] && $value->max_students_no <= $post['max_students_no_to'])) || (((!empty($post['max_students_no_from']) && empty($post['max_students_no_to']))) && ($value->max_students_no >= $post['max_students_no_from'])) || (((empty($post['max_students_no_from']) && !empty($post['max_students_no_to']))) && ($value->max_students_no <= $post['max_students_no_to']))
                ) {
                    array_push($array_1, $value->id);
                }
            }
        }

        /*
         * Paging
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            $iTotalRecords = count($array_1);
        } else {
            $iTotalRecords = count($array_);
        }

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;



        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            $output = array_slice($array_1, $iDisplayStart, $iDisplayLength);
            $Search_objs = array();
            foreach ($output as $value) {
                array_push($Search_objs, Search::action_GetOne($array_, 'id', $value));
            }
        } else {
            $Search_objs = array_slice($array_, $iDisplayStart, $iDisplayLength);
        }



        /*
         * Prepare JSON Array
         */
        $Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        foreach ($Search_objs as $key => $value) {
            $buttons = '';
            $buttons.='<a href="' . URL::base() . 'News/' . $value['id'] . '" target="_blank" class="btn btn-xs green-sharp"><i class="fa fa-television"></i> ' . Lang::__('Show_in_website') . '</a>';
            ($this->Edit) ? $buttons.='<a href="' . URL::base() . 'Newscp/AE/' . $value['id'] . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete) ? $buttons.='<a par1="' . $value['id'] . '" par2="" class="btn btn-xs red Delete" data-toggle="modal"><i class="fa fa-times"></i> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value['id'] . '">',
                $value['title_' . $this->lang],
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_Img_Replaces($Html_Code) {
        if (!empty($Html_Code)) {
            $doc = new DOMDocument();
            $doc->loadHTML(mb_convert_encoding($Html_Code, 'HTML-ENTITIES', 'UTF-8'));
            $tags = $doc->getElementsByTagName('img');
            foreach ($tags as $tag) {
                $old_src = $tag->getAttribute('src');
                $new_src_url = URL::base() . $old_src;
                $tag->setAttribute('src', $new_src_url);
            }
            return $doc->saveHTML();
        } else {
            return $Html_Code;
        }
    }

}
