<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Letters_Dropdowns extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Letters_Dropdowns')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Letters_Dropdowns')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Letters_Dropdowns')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Letters_Dropdowns')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Letters_Dropdowns');
            $this->template->title = $title;
            $this->template->layout = new View('system/letters/dropdowns/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Letters_Dropdowns', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/letters/dropdowns/AE');

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }

            $this->template->layout->Options = $Obj->Options->where('is_deleted', '=', NULL)->find_all();

            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Letters_Dropdowns', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Letters_Dropdowns', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }


        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {



                //Start dealing with with Date_Fields
                $Fields_Types = array(
                    "Options" => array(
                        'id' => 1,
                    ),
                );
                foreach ($Fields_Types as $TKey => $Tvalue) {
                    $Form_Fields = isset($Filtered_array[$TKey]) ? $Filtered_array[$TKey] : NULL;
                    if (!empty($Form_Fields)) {
                        foreach ($Form_Fields as $keyQ => $Field) {
                            $Field = Search::action_Filtered_array($Field);
                            //To check if any of field exist
                            $all_empty = TRUE;
                            foreach ($Field as $key => $value) {
                                if (!empty($value)) {
                                    $all_empty = FALSE;
                                    break;
                                }
                            }
                            //End check if any of field exist
                            if ($all_empty == FALSE) {
                                $id_this = isset($Field['id']) ? $Field['id'] : NULL;

                                $FieldORM = ORM::factory('Letters_Dropdowns_Options', $id_this);
                                if (isset($Field['id'])) {
                                    unset($Field['id']);
                                }

                                $FieldORM->values($Field);
                                if (!$FieldORM->loaded()) {
                                    $FieldORM->dropdown = $objj->id;
                                    $FieldORM->Created_by = $this->user_online->id;
                                    $FieldORM->Created_date = date("Y-m-d H:i:s");
                                } else {
                                    $FieldORM->last_update_by = $this->user_online->id;
                                    $FieldORM->last_update_date = date("Y-m-d H:i:s");

                                    if (!empty($FieldORM->salary_affect) && empty($Field['salary_affect'])) {
                                        $FieldORM->salary_affect = NULL;
                                    }
                                }
                                $FieldORM->save();
                            }
                        }
                    }
                }

                //End dealing with with Date_Fields


                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Letters_Dropdowns')
                ->where('source', '=', 2)
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(name_ar)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(name_en)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        if($iDisplayLength == -1){
            $iDisplayLength = 1000;;
        }
        //$iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Letters_Dropdowns/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->{"name_ar"},
                $value->{"name_en"},
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $ORM = ORM::factory('Letters_Dropdowns', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);



        echo json_encode($results);
    }

    public function action_DeleteField() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = isset($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $par2 = isset($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

        $Obj = ORM::factory('Letters_Dropdowns_Options', $id);
        if ($Obj->loaded()) {
            if ($this->Delete) {
                $Obj->is_deleted = 1;
                $Obj->deleted_by = $this->user_online->id;
                $Obj->deleted_date = date("Y-m-d H:i:s");
                if ($Obj->save()) {
                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Deletion has been successfully'),
                    );
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }




        echo json_encode($results);
    }

}
