<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Hr_History extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_hr_history')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_hr_history')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_hr_history')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_hr_history')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Hr_History');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/History/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Hr_Employment_Applications')
                ->where('is_deleted', '=', NULL)
                ->where('app_status', '=', 1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr("concat(`name_first_ar`, ' ', `name_father_ar`,' ',`name_grandfather_ar`, ' ',`name_last_ar`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                $All_ORM->or_where(DB::expr("concat(`name_first_en`, ' ', `name_father_en`,' ',`name_grandfather_en`, ' ',`name_last_en`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['id_no'])) {
                $All_ORM->where('id_no', '=', $post['id_no']);
            }
        }

        /*
         * Paging
         */

        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit || $this->Browse || $this->Delete) ? $buttons .= '<a href="' . URL::base() . 'Hr_History/Browse/' . $value->user_id . '" class="btn btn-xs blue"><i class="fa fa-search"></i> ' . Lang::__('Browse') . '</a>' : NULL;
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->name_first_ar . ' ' . $value->name_father_ar . ' ' . $value->name_grandfather_ar . ' ' . $value->name_last_ar,
                $value->name_first_en . ' ' . $value->name_father_en . ' ' . $value->name_grandfather_en . ' ' . $value->name_last_en,
                $value->id_no,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_Browse() {
        $par1 = $this->request->param('par1');
        if ($this->Browse || $this->Delete || $this->Edit) {
            $this->template->layout = new View('system/hr/History/Browse');
            $this->template->title = Lang::__("Hr_History");
            $Letters = ORM::factory('Letters_Letters');
            $Fields = $Letters->Fields->where('is_deleted', '=', NULL)->order_by('order')->limit(4)->find_all();
            $this->template->layout->Fields = $Fields;
            $this->template->layout->par1 = $par1;
            $this->template->layout->title = Lang::__("Hr_History");
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_BrowseGetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        $par1 = !empty($post['par1']) ? $post['par1'] : NULL;
        
        $Letter = ORM::factory('Letters_Letters');
        $Fields = $Letter->Fields->where('is_deleted', '=', NULL)->order_by('order')->limit(4)->find_all();
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Letters_Applications')
                ->where('Created_by', '=', $par1)
                ->where('is_deleted', '=', NULL)
                //->where('letter', '=', $par1)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        if ($iDisplayLength == -1) {
            $iDisplayLength = 1000;
        }
        //$iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';

            $Approvals = $value->Letter_Application_Approvals->where('is_deleted', '=', NULL)->find_all();
            $Approvals_All = count($Approvals);
            $Wait = 0;
            $accept = 0;
            $reject = 0;
            $rejected_by = NULL;
            $Text_Approvals = '';
            $notes = '';
            $count = 1;
            foreach ($Approvals as $Approval) {
                if (empty($Approval->app_status)) {
                    $Wait++;
                }
                if ($Approval->app_status == 1) {
                    $accept++;
                }
                if ($Approval->app_status == 2) {
                    $reject++;
                    if (!empty($Approval->rejected_by)) {
                        $rejected_by = $Approval->Rejected_By->{'name_' . $this->lang};
                    }
                }


                $department = $Approval->department;
                if (empty($department)) {
                    $department = $Approval->Application->Created_User->Employee_Information->department;
                }
                if ($Approval->app_status == 1) {
                    $class = ' font-green-jungle ';
                    $S_State = Lang::__('App_Approved') . ' <br> ' . $Approval->approved_date;
                } elseif ($Approval->app_status == 2) {
                    $class = ' font-red-thunderbird ';
                    $S_State = Lang::__('rejected') . ' <br> ' . $Approval->rejected_date;
                } else {
                    $class = ' font-grey-cascade  ';
                    $S_State = Lang::__('Waiting for approval');
                }

                $Text_Approvals .= '<span class="' . $class . '">' . $Approval->order . ' - ' . ORM::factory('General_Hr_Departments', $department)->{'name_' . $this->lang} . ' ( ' . $S_State . ' )' . '</span></br>';
                if ($Approval->notes != null && $Approval->notes != '') {
                    $notes .= $count . ') ' . $Approval->notes . '<br>';
                    $count++;
                }
            }






            $buttons .= '<a data-url="' . URL::base() . 'Letters_Applications/ViewDetails/' . $value->id . '" class="btn btn-xs default ViewD" data-toggle="modal"><i class="fa fa-eye"></i> ' . Lang::__('Browse') . '</a>';
           
            $data_array = array();
            array_push($data_array, '<input type="checkbox" name="id[]" value="');
            $letter = ORM::factory('Letters_Letters',$value->letter);
            $letter->loaded();
            array_push($data_array, $letter->{'name_'.$this->lang});

            foreach ($Fields as $Field) {
                if ($Field->type == 6) {
                    if ($Field->Dropdown->source == 1) {

                        switch ($Field->Dropdown->source_data) {
                            case 'All_Employees':

                                array_push($data_array, ORM::factory('Hr_Employment_Applications', $value->{$Field->col_name})->GetFullName($this->lang));
                                break;

                            default:
                                break;
                        }
                    } elseif ($Field->Dropdown->source == 2) {
                        array_push($data_array, ORM::factory('Letters_Dropdowns_Options', $value->{$Field->col_name})->{'name_' . $this->lang});
                    }
                } elseif ($Field->type == 7) {

                    array_push($data_array, ORM::factory('Letters_Dropdowns_Options', $value->{$Field->col_name})->{'name_' . $this->lang});
                } else {
                    array_push($data_array, $value->{$Field->col_name});
                }
            }

            array_push($data_array, $Text_Approvals);
            array_push($data_array, $notes);
            array_push($data_array, $buttons);


            $records["data"][] = $data_array;
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
