<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Hr_Fineswarnings extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $Accept_HR_Fines = FALSE;
    public $Accept_HR_Warnings = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Fines_Warnings')));
        $this->Browse =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Fines_Warnings')));
        $this->Edit =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Fines_Warnings')));
        $this->Delete =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Fines_Warnings')));
        $this->Accept_HR_Fines =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Accept_HR_Fines')));
        $this->Accept_HR_Warnings =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Accept_HR_Warnings')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Hr_Fineswarnings');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/fineswarnings/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Hr_Fineswarnings', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/hr/fineswarnings/AE');
            $this->template->layout->Employees = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Fines_Types = ORM::factory('General_Hr_Fines_Types')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Warnings_Types = ORM::factory('General_Hr_Warnings_Types')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();

            if ($Obj->loaded()) {
                $this->template->layout->Obj = $Obj;
            }
            $this->template->layout->title = Lang::__($process_type);
            $this->template->title = Lang::__($process_type);
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Hr_Fineswarnings', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Hr_Fineswarnings', $par1);
        if (!$objj->loaded()) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
        } else {
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");
        }


        $objj->values($Filtered_array);

        try {
            if ($objj->save()) {



                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Hr_Fineswarnings')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['employee'])) {
                $All_ORM->where("employee", '=', $post['employee']);
            }
            if (!empty($post['type'])) {
                $All_ORM->where("type", '=', $post['type']);
            }
            if (!empty($post['month_from'])) {
                $All_ORM->where("month", '>=', $post['month_from']);
            }
            if (!empty($post['month_to'])) {
                $All_ORM->where("month", '<=', $post['month_to']);
            }
            if (!empty($post['year_from'])) {
                $All_ORM->where("year", '>=', $post['year_from']);
            }
            if (!empty($post['year_to'])) {
                $All_ORM->where("year", '<=', $post['year_to']);
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->Edit) ? $buttons.='<a href="' . URL::base() . 'Hr_Fineswarnings/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

            $Employee = $value->Employment_Applications;
            $T = NULL;
            if ($value->type == 1) {
                $S = !empty($value->Fine_Type->amount) ? Lang::__('amount') . ': ' . $value->Fine_Type->amount . ' )' : Lang::__('percentage') . ': ' . $value->Fine_Type->percentage . ' )';
                $T = Lang::__('Fine') . ' - ' . $value->Fine_Type->{'name_' . $this->lang} . ' ( ' . $S;
                
                ($this->Accept_HR_Fines && ($value->status != 1)) ? $buttons.='<button type="button" class="btn btn-xs green-jungle app_affect" par1="' . $value->id . '" par2="1" Dtitle="' . Lang::__("confirmation") . '" Dcontent="' . Lang::__("You_are_about_to_approve_fine_against_the_employee") . ' ' . $value->Employment_Applications->{"name_first_" . $this->lang} . ' ' . $value->Employment_Applications->{"name_last_" . $this->lang} . '" PHold="' . Lang::__("Notes") . '" Submit_Btn="' . Lang::__("Submit") . '" Cancel_Btn="' . Lang::__("Cancel") . '">' . Lang::__('Accept_fine') . '</button>' : NULL;
            }
            if ($value->type == 2) {
                $T = Lang::__('Warning') . ' - ' . $value->Warning_Type->{'name_' . $this->lang};
                
                ($this->Accept_HR_Warnings && ($value->status != 1)) ? $buttons.='<button type="button" class="btn btn-xs green-jungle app_affect" par1="' . $value->id . '" par2="1" Dtitle="' . Lang::__("confirmation") . '" Dcontent="' . Lang::__("You_are_about_to_approve_warning_against_the_employee") . ' ' . $value->Employment_Applications->{"name_first_" . $this->lang} . ' ' . $value->Employment_Applications->{"name_last_" . $this->lang} . '" PHold="' . Lang::__("Notes") . '" Submit_Btn="' . Lang::__("Submit") . '" Cancel_Btn="' . Lang::__("Cancel") . '">' . Lang::__('Accept_warning') . '</button>' : NULL;
            }
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $Employee->{"name_first_" . $this->lang} . ' ' . $Employee->{"name_father_" . $this->lang}. ' ' . $Employee->{"name_grandfather_" . $this->lang} . ' ' . $Employee->{"name_last_" . $this->lang},
                $T,
                $value->month,
                $value->year,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];

        $ORM = ORM::factory('Hr_Fineswarnings', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);



        echo json_encode($results);
    }

    public function action_Approval() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = !empty($Filtered_array['par1']) ? $Filtered_array['par1'] : NULL;
        $par2 = !empty($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;
        $notes = !empty($Filtered_array['notes']) ? $Filtered_array['notes'] : NULL;

        $objj = ORM::factory('Hr_Fineswarnings', $par1);

        if ($objj->loaded()) {
            try {
                if ($par2 == 1 && (($objj->type == 1 && $this->Accept_HR_Fines) || ($objj->type == 2 && $this->Accept_HR_Warnings))) {
                    $objj->status = 1;
                    $objj->approved_date = date("Y-m-d H:i:s");
                    $objj->approved_by = $this->user_online->id;
                    $objj->notes = $notes;
                    if ($objj->update()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Operation_accomplished_successfully')
                        );
                    }
                }
//                elseif ($par2 == 2 && empty($objj->app_status) && $this->Reject_Employment_Applications) {
//                    $objj->app_status = 2;
//                    $objj->rejected_date = date("Y-m-d H:i:s");
//                    $objj->rejected_by = $this->user_online->id;
//                    $objj->notes = $notes;
//                    if ($objj->update()) {
//                        $results['Success'] = array(
//                            'title' => Lang::__('Done'),
//                            'content' => Lang::__('Application rejected successfully')
//                        );
//                    }
//                } 
                else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                    );
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        }

        echo json_encode($results);
    }

}
