<?php

defined('SYSPATH') or die('No direct script access.');
require DOCROOT . 'classes/PhpSpreadsheet/autoload.php';

class Controller_Hr_Attendance extends Controller_Template_Base {

    public $Review_attendance_and_departure = FALSE;
    public $Import_attendance_and_departure = FALSE;
    public $Export_attendance_and_departure = FALSE;
    public $Feilds = array(); //الحقول المتاحة لتصدير البيانات
    public $type_of_export = array(); //الحقول المتاحة لتصدير البيانات

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Review_attendance_and_departure = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Review_attendance_and_departure')));
        $this->Import_attendance_and_departure = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Import_attendance_and_departure')));
        $this->Export_attendance_and_departure = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Export_attendance_and_departure')));
        $this->Feilds = array("code", "name", "date", "clock_in", "clock_out", "late", "early", "absent", "Created_by", "Created_date");
        $this->type_of_export = array("xls", 'xlsx');
    }

    public function action_index() {
        if ($this->Import_attendance_and_departure || $this->Review_attendance_and_departure) {
            $title = Lang::__('Attendance_and_departure');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/attendance/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Review_attendance_and_departure = $this->Review_attendance_and_departure;
            $this->template->layout->Import_attendance_and_departure = $this->Import_attendance_and_departure;
            $this->template->layout->Export_attendance_and_departure = $this->Export_attendance_and_departure;

            $this->template->layout->NotReviewed = ORM::factory('Hr_Attendance')->where('reviewed', '=', NULL)->where('is_deleted', '=', NULL)->count_all();



            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        if ($this->Import_attendance_and_departure || $this->Review_attendance_and_departure) {
            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Hr_Attendance')
                    ->where('is_deleted', '=', NULL)
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);


            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':


                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

                if (!empty($post['code'])) {
                    $Hr_Employment_code = ORM::factory('Hr_Employment_Applications')
                            ->where('code', '=', $post['code'])
                            ->where('is_deleted', '=', NULL)
                            ->where('app_status', '=', 1)
                            ->find();


                    if ($Hr_Employment_code->loaded()) {
                        $All_ORM->where('employee', '=', $Hr_Employment_code->id);
                    }
                }

                if (!empty($post['name'])) {
                    $Hr_Employment_Applications = ORM::factory('Hr_Employment_Applications')
                            ->where('is_deleted', '=', NULL)
                            ->where('app_status', '=', 1);

                    $Name = mb_strtolower($post['name']);
                    $Hr_Employment_Applications->and_where_open();
                    $Hr_Employment_Applications->or_where(DB::expr("concat(`name_first_ar`, ' ', `name_father_ar`,' ',`name_grandfather_ar`, ' ',`name_last_ar`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                    $Hr_Employment_Applications->or_where(DB::expr("concat(`name_first_en`, ' ', `name_father_en`,' ',`name_grandfather_en`, ' ',`name_last_en`)"), "LIKE", DB::expr("concat('%', replace('$Name', ' ', '%'), '%')"));
                    $Hr_Employment_Applications->and_where_close();

                    $Arr_e = array();
                    foreach ($Hr_Employment_Applications->find_all() as $value) {
                        array_push($Arr_e, $value->id);
                    }
                    if (count($Arr_e) > 0) {
                        $All_ORM->where('employee', 'IN', $Arr_e);
                    }
                }

                if (!empty($post['date_From'])) {
                    $All_ORM->where('date', '>=', $post['date_From']);
                }
                if (!empty($post['date_to'])) {
                    $new_date_to = new DateTime($post['date_to']);
                    $All_ORM->where('date', '<=', $new_date_to->format('Y-m-d H:i:s'));
                }

                if (!empty($post['clock_in_from'])) {
                    $All_ORM->where('clock_in', '>=', $post['clock_in_from']);
                }
                if (!empty($post['clock_in_to'])) {
                    $All_ORM->where('clock_in', '<=', $post['clock_in_to']);
                }

                if (!empty($post['clock_out_from'])) {
                    $All_ORM->where('clock_out', '>=', $post['clock_out_from']);
                }
                if (!empty($post['clock_out_to'])) {
                    $All_ORM->where('clock_out', '<=', $post['clock_out_to']);
                }

                if (!empty($post['late_from'])) {
                    $All_ORM->where('late', '>=', $post['late_from']);
                }
                if (!empty($post['late_to'])) {
                    $All_ORM->where('late', '<=', $post['late_to']);
                }

                if (!empty($post['early_from'])) {
                    $All_ORM->where('early', '>=', $post['early_from']);
                }
                if (!empty($post['early_to'])) {
                    $All_ORM->where('early', '<=', $post['early_to']);
                }

                if (!empty($post['absent'])) {
                    if (intval($post['absent']) === 1) {
                        $All_ORM->where('absent', '=', 1);
                    } elseif (intval($post['absent']) === 2) {
                        $All_ORM->where('absent', '=', NULL);
                    }
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;


            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);



            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $buttons = '';
                //($this->Edit) ? $buttons .= '<a href="' . URL::base() . 'Hr_Fineswarnings/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
                //($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons .= '<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;

                $clock_in = explode(':', $value->clock_in);
                $clock_in_text = isset($clock_in[0]) ? $clock_in[0] : '';
                $clock_in_text .= isset($clock_in[1]) ? ':' . $clock_in[1] : '';

                $clock_out = explode(':', $value->clock_out);
                $clock_out_text = isset($clock_out[0]) ? $clock_out[0] : '';
                $clock_out_text .= isset($clock_out[1]) ? ':' . $clock_out[1] : '';

                $late = explode(':', $value->late);
                $late_text = isset($late[0]) ? $late[0] : '';
                $late_text .= isset($late[1]) ? ':' . $late[1] : '';

                $early = explode(':', $value->early);
                $early_text = isset($early[0]) ? $early[0] : '';
                $early_text .= isset($early[1]) ? ':' . $early[1] : '';

                $background = '#fdfff5';
                if (empty($value->reviewed)) {
                    $background = '#fff5f7';
                }
                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->Employee->code,
                    $value->Employee->{"name_first_" . $this->lang} . ' ' . $value->Employee->{"name_father_" . $this->lang} . ' ' . $value->Employee->{"name_grandfather_" . $this->lang} . ' ' . $value->Employee->{"name_last_" . $this->lang},
                    $value->date,
                    $clock_in_text,
                    $clock_out_text,
                    $late_text,
                    $early_text,
                    empty($value->absent) ? Lang::__('No') : Lang::__('Yes'),
                    $buttons,
                    $background,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

    /*
     * ارسال بيانات ملف الاكسل الى جدول الحضور والانصراف في قاعدة البيانات
     */

       public function action_ToDB() {
        if ($this->Import_attendance_and_departure) {

            if ($this->request->method() == Request::POST) {
                $results = array();

                $req = Request::current(); //fillter requset
                $Filtered_array = Search::action_Filtered_array($req->post());

                if (isset($_FILES['excel_file'])) {

                    $video = $this->_save_file($_FILES['excel_file']);
                    if ($video) {

                        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load(DOCROOT . $video);
                        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

                        try {
                            $Rows_Not_Inserted = array();
                            $Rows_Inserted = array();
                            foreach ($sheetData as $key => $row) {

                                if (isset($row["A"])) {

                                    $date = NULL;
                                    $clock_in = "00:00:00";
                                    $clock_out = "00:00:00";
                                    $late = "00:00:00";
                                    $early = "00:00:00";
                                    $absent = NULL;
                                    
                                    $Hr_Employment_Application = ORM::factory('Hr_Employment_Applications')->where('is_deleted', '=', NULL)->where('code', '=', $row["A"])->find();

                                    if ($Hr_Employment_Application->loaded()) {


                                        if (!empty($row["D"])) {
                                            $DExplode = explode('/', $row["D"]);
                                            $month = isset($DExplode[0]) ? $DExplode[0] : NULL;
                                            $day = isset($DExplode[1]) ? $DExplode[1] : NULL;
                                            $year = isset($DExplode[2]) ? $DExplode[2] : NULL;
                                            if (checkdate($month, $day, $year)) {
                                                $date = $year . '-' . $month . '-' . $day;
                                            }
                                        }
                                        if (!empty($row["H"])) {
                                            $explode_clock_in = explode(":", $row["H"]);
                                            if (isset($explode_clock_in[0]) && isset($explode_clock_in[1])) {
                                                $clock_in = $row["H"];
                                            }
                                        }
                                        if (!empty($row["I"])) {
                                            $explode_clock_out = explode(":", $row["I"]);
                                            if (isset($explode_clock_out[0]) && isset($explode_clock_out[1])) {
                                                $clock_out = $row["I"];
                                            }
                                        }
                                        if (!empty($row["L"])) {
                                            $explode_late = explode(":", $row["L"]);
                                            if (isset($explode_late[0]) && isset($explode_late[1])) {
                                                $late = $row["L"];
                                            }
                                        }
                                        if (!empty($row["M"])) {
                                            $explode_early = explode(":", $row["M"]);
                                            if (isset($explode_early[0]) && isset($explode_early[1])) {
                                                $early = $row["M"];
                                            }
                                        }
                                        if (!empty($row["N"]) && trim(mb_strtolower($row["N"])) == 'true') {
                                            $absent = 1;
                                        }
                                        if (isset($date)) {

                                            $Hr_Attendance = ORM::factory('Hr_Attendance')
                                                    ->where('employee', '=', $Hr_Employment_Application->id)
                                                    ->where('date', '=', $date)
                                                    ->find();
                                            if ($Hr_Attendance->loaded()) {
                                                array_push($Rows_Not_Inserted, array(
                                                    'row_id' => $key,
                                                    'reason' => Lang::__('The employee has been pre-iserted in the attendance and departure record for the same specified date'),
                                                ));
                                            } else {
                                                $Hr_Attendance->date = isset($date) ? $date : NULL;
                                                $Hr_Attendance->employee = $Hr_Employment_Application->id;
                                                $Hr_Attendance->clock_in = isset($clock_in) ? $clock_in : NULL;
                                                $Hr_Attendance->clock_out = isset($clock_out) ? $clock_out : NULL;
                                                $Hr_Attendance->late = isset($late) ? $late : NULL;
                                                $Hr_Attendance->early = isset($early) ? $early : NULL;
                                                $Hr_Attendance->absent = isset($absent) ? $absent : NULL;
                                                $Hr_Attendance->Created_by = $this->user_online->id;
                                                $Hr_Attendance->Created_date = date("Y-m-d H:i:s");
                                                if ($Hr_Attendance->save()) {
                                                    array_push($Rows_Inserted, array(
                                                        'name' => $Hr_Employment_Application->{'name_first_' . $this->lang} . ' ' . $Hr_Employment_Application->{'name_father_' . $this->lang} . ' ' . $Hr_Employment_Application->{'name_grandfather_' . $this->lang} . ' ' . $Hr_Employment_Application->{'name_last_' . $this->lang},
                                                        'date' => $Hr_Attendance->date,
                                                        'clock_in' => $Hr_Attendance->clock_in,
                                                        'clock_out' => $Hr_Attendance->clock_out,
                                                        'late' => $Hr_Attendance->late,
                                                        'early' => $Hr_Attendance->early,
                                                        'absent' => empty($Hr_Attendance->absent) ? Lang::__('No') : Lang::__('Yes'),
                                                        'row_id' => $key,
                                                    ));
                                                }
                                            }
                                        } else {
                                            array_push($Rows_Not_Inserted, array(
                                                'row_id' => $key,
                                                'reason' => Lang::__('The date is not specified, or the date specified is in incorrect format'),
                                            ));
                                        }
                                    } else {
                                        array_push($Rows_Not_Inserted, array(
                                            'row_id' => $key,
                                            'reason' => Lang::__('The employee was not found based on his code listed in column A'),
                                        ));
                                    }
                                }
                            }
                        } catch (ORM_Validation_Exception $e) {

                            $errors = $e->errors('');
                            $results['Errors'] = array(
                                'title' => Lang::__('Error'),
                                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
                            );
                        }
                    } else {
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => Lang::__('An error occurred while trying to upload the file'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('File not uploaded'),
                    );
                }
                if (isset($Rows_Not_Inserted) && isset($Rows_Inserted)) {
                    $Text = '';
                    $Rows_Not_Inserted_count = count($Rows_Not_Inserted);
                    $Rows_Inserted_count = count($Rows_Inserted);

                    if ($Rows_Not_Inserted_count > 0) {
                        $Text .= '<h4 class="bg-red bg-font-red" style="padding:10px;">' . Lang::__('The following data has not been added to the attendance and departure schedule') . ':</h4>';

                        $Text .= '<table class="table table-bordered table-condensed table-striped">';

                        $Text .= '<tr><th class="text-center">' . Lang::__('row_id') . '</th><th class="text-center">' . Lang::__('reason') . '</th></tr>';
                        foreach ($Rows_Not_Inserted as $value) {
                            $Text .= '<tr class="danger"><td class="text-center">' . $value['row_id'] . '</td><td class="text-center">' . $value['reason'] . '</td></tr>';
                        }
                        $Text .= '</table>';
                    }


                    if ($Rows_Inserted_count > 0) {
                        $Text .= '<h4 class="bg-green bg-font-green" style="padding:10px;">' . Lang::__('The following data were added to the attendance and departure schedule') . ':</h4>';

                        $Text .= '<table class="table table-bordered table-condensed table-striped">';


                        $Text .= '<tr><th class="text-center">' . Lang::__('date') . '</th><th class="text-center">' . Lang::__('name') . '</th><th class="text-center">' . Lang::__('clock_in') . '</th><th class="text-center">' . Lang::__('clock_out') . '</th><th class="text-center">' . Lang::__('late') . '</th><th class="text-center">' . Lang::__('absent') . '</th><th class="text-center">' . Lang::__('row_id') . '</th></tr>';
                        foreach ($Rows_Inserted as $value) {
                            $Text .= '<tr class="success"><td class="text-center">' . $value['date'] . '</td><td class="text-center">' . $value['name'] . '</td><td class="text-center">' . $value['clock_in'] . '</td><td class="text-center">' . $value['clock_out'] . '</td><td class="text-center">' . $value['late'] . '</td><td class="text-center">' . $value['absent'] . '</td><td class="text-center">' . $value['row_id'] . '</td></tr>';
                        }
                        $Text .= '</table>';
                    }
                    $results['Success'] = array(
                        'title' => Lang::__('Results'),
                        'Text' => $Text,
                    );
                }

                echo json_encode($results);
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }
    }


    /*
     * تصدير جدول الحضور والغياب على شكل ملف اكسل
     */

    public function action_ExportData() {
        if ($this->Export_attendance_and_departure) {
            $title = Lang::__('export_data') . ' - ' . Lang::__('Attendance_and_departure');
            $this->template->title = $title;
            $this->template->layout = new View('system/hr/attendance/export');
            $this->template->layout->title = $title;
            $this->template->layout->Import_attendance_and_departure = $this->Import_attendance_and_departure;
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Feilds = $this->Feilds;
            $this->template->layout->type_of_export = $this->type_of_export;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * تعليم كل البيانات ك مراجعة
     */

    public function action_ReviewAll() {
        $results = array();
        if ($this->Review_attendance_and_departure) {
            if ($this->request->method() == Request::POST) {
                DB::update(ORM::factory('Hr_Attendance')->table_name())
                        ->set(array(
                            'reviewed' => 1,
                            'reviewed_by' => $this->user_online->id,
                            'reviewed_date' => date("Y-m-d H:i:s"),
                        ))
                        ->where('reviewed', '=', NULL)
                        ->execute();

                $results['Success'] = array(
                    'title' => Lang::__('Done'),
                    'content' => Lang::__('Operation_accomplished_successfully'),
                );
            }
        }
        echo json_encode($results);
    }

    public function action_ExportFile() {
        $results = array();
        if ($this->request->method() == Request::POST) {


            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());
            if (!empty($Filtered_array['Feilds']) && is_array($Filtered_array['Feilds']) && !empty($Filtered_array['Types_of_export']) && is_array($Filtered_array['Types_of_export'])) {

                $headerstyleArray = array(
                    'font' => array(
                        'bold' => true,
                    ),
                    'alignment' => array(
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => array(
                        'top' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ),
                    ),
                );

                $NormalstyleArray = array(
                    'alignment' => array(
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ),
                    'borders' => array(
                        'top' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ),
                    ),
                );

                $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
                $worksheet = $spreadsheet->getActiveSheet();

                $Feilds = array_combine(range(1, count($Filtered_array['Feilds'])), array_values($Filtered_array['Feilds'])); //To Start Keys From 1 not 0

                foreach ($Feilds as $key => $value) {
                    if (in_array($value, $this->Feilds)) { //للتأكد انه اليوزر ما لعب باسم العمود
                        $alphapet = $this->getNameFromNumber($key);

                        $worksheet->getCell($alphapet . '1')->setValue(Lang::__($value))->getStyle($alphapet . '1')->applyFromArray($headerstyleArray);
                        $Feilds[$alphapet] = $value; //To change key to alphapet
                        unset($Feilds[$key]);
                    }
                }

                $Hr_Attendance = ORM::factory('Hr_Attendance')->find_all();
                $k = 2;
                foreach ($Hr_Attendance as $Attendance) {
                    $Employee = $Attendance->Employee;
                    $Created_by = $Attendance->Created_by_User;
                    foreach ($Feilds as $alpha => $col_name) {
                        if ($col_name == 'code') {
                            $val = $Employee->$col_name;
                        } elseif ($col_name == 'name') {
                            $val = $Employee->{'name_first_' . $this->lang} . ' ' . $Employee->{'name_father_' . $this->lang} . ' ' . $Employee->{'name_grandfather_' . $this->lang} . ' ' . $Employee->{'name_last_' . $this->lang};
                        } elseif ($col_name == 'Created_by') {
                            $val = $Created_by->{'name_' . $this->lang};
                        } elseif ($col_name == 'absent') {
                            $val = empty($Attendance->absent) ? Lang::__('No') : Lang::__('Yes');
                        } else {
                            $val = $Attendance->$col_name;
                        }

                        $worksheet->getCell($alpha . $k)->setValue($val)->getStyle($alpha . $k)->applyFromArray($NormalstyleArray);
                    }

                    $k++;
                }
                foreach ($Feilds as $alpha => $col_name) {
                    $worksheet->getColumnDimension($alpha)->setAutoSize(true);
                }

                $Success_Files = array();
                foreach ($Filtered_array['Types_of_export'] as $ext) {
                    $directory = 'files/attendance/' . date('Y') . '/' . date("m") . '/';
                    $directory_D = DOCROOT . str_replace("\\", "/", $directory);
                    if (!file_exists($directory_D)) {
                        mkdir($directory_D, 0777, true);
                    }

                    $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;
                    $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, ucfirst($ext));

                    if ($writer->save($directory . $filename) === NULL) {
                        $date_to_delete = date('Y-m-d', strtotime(date('Y-m-d') . ' + 90 days'));
                        try {
                            $User_File = ORM::factory('Users_Files');
                            $User_File->file_path = $directory . $filename;
                            $User_File->description_ar = Lang::__('Export_attendance_and_departure_in_format', 'ar') . ' ' . strtoupper($ext);
                            $User_File->description_en = Lang::__('Export_attendance_and_departure_in_format', 'en') . ' ' . strtoupper($ext);
                            $User_File->date_to_delete = $date_to_delete;
                            $User_File->Created_by = $this->user_online->id;
                            $User_File->Created_date = date("Y-m-d H:i:s");
                            if ($User_File->save()) {
                                array_push($Success_Files, $User_File);
                            }
                        } catch (ORM_Validation_Exception $e) {

                            $errors = $e->errors('');
                            $results['Errors'] = array(
                                'title' => Lang::__('Error'),
                                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors)),
                            );
                        }
                    }
                }


                $spreadsheet->disconnectWorksheets(); //Clearing a Workbook from memory
                unset($spreadsheet); //Clearing a Workbook from memory
            } else {
                if (empty($Filtered_array['Feilds'])) {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('No table feilds is specified to export'),
                    );
                } else if (empty($Filtered_array['Types_of_export'])) {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('No file type selected'),
                    );
                }
            }
        }

        if (isset($Success_Files) && !empty($Success_Files)) {
            $Text = '';
            if (count($Success_Files) == 1) {
                $Text .= '<h4 class="bg-green bg-font-green" style="padding:10px;">' . Lang::__('File exported successfully') . '</h4>';
            } else {
                $Text .= '<h4 class="bg-green bg-font-green" style="padding:10px;">' . Lang::__('Files exported successfully') . '</h4>';
            }
            $Text .= '<table class="table table-bordered table-condensed table-striped">';
            $Text .= '<tr><th class="text-center">' . Lang::__('file_path') . '</th><th class="text-center">' . Lang::__('description') . '</th><th class="text-center">' . Lang::__('date_to_delete') . '</th></tr>';

            foreach ($Success_Files as $value) {
                $Text .= '<tr class="success"><td class="text-center"><a href="' . URL::base() . $value->file_path . '" class="btn blue btn-sm" target="_blank">' . Lang::__('Click here to download the file') . '</a></td><td class="text-center">' . $value->{'description_' . $this->lang} . '</td><td class="text-center">' . $value->date_to_delete . '</td></tr>';
            }
            $Text .= '</table>';

            $results['Success'] = array(
                'title' => Lang::__('Done'),
                'content' => $Text
            );
        }
        echo json_encode($results);
    }

    /*
     * لتحويل الارقام الى اسماء اعمدة الاكسل
     */

    public function getNameFromNumber($num) {
        $numeric = ($num - 1) % 26;
        $letter = chr(65 + $numeric);
        $num2 = intval(($num - 1) / 26);
        if ($num2 > 0) {
            return getNameFromNumber($num2) . $letter;
        } else {
            return $letter;
        }
    }

    protected function _save_file($file) {
        if (!Upload::valid($file) OR ! Upload::not_empty($file) OR ! Upload::type($file, array('xlsx', 'xls'))) {
            return FALSE;
        }
        $directory = 'files/attendance/' . date('Y') . '/' . date("m") . '/';
        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $filename = strtolower(Text::random('alnum', 22)) . '.' . $ext;
        if ($file = Upload::save($file, $filename, $directory)) {
            return $directory . $filename;
        }

        // return FALSE;
    }

}
