<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Home extends Controller_Template_Site
{


    public function action_index()
    {

        $this->template->layout = new View('site/index');


        $this->template->layout->lang = $this->lang;

        $Main_Slides = ORM::factory('Slides')
            ->where('Show_for_Visitors', '=', 1)
            ->order_by('order')
            ->find_all();
        $this->template->layout->Main_Slides = $Main_Slides;

        $Home_Icons = ORM::factory('Home_Icons')
            ->where('Show_for_Visitors', '=', 1)
            ->order_by('order')
            ->find_all();
        $this->template->layout->Home_Icons = $Home_Icons;


        $Num_News = 3;
        $First_News_Sticked = ORM::factory('News')->where("stick", "=", 1)->where('is_deleted', '=', NULL)->order_by('id', 'desc')->limit($Num_News)->find_all();
        $F_Count = count($First_News_Sticked);
        if ($F_Count > 0) {
            $this->template->layout->First_News_Sticked = $First_News_Sticked;
        }
        if (($Num_News - $F_Count) > 0) {
            $First_News_NotSticked = ORM::factory('News')->where("stick", "=", NULL)->where('is_deleted', '=', NULL)->order_by('id', 'desc')->limit($Num_News - $F_Count)->find_all();
            if (count($First_News_NotSticked) > 0) {
                $this->template->layout->First_News_NotSticked = $First_News_NotSticked;
            }
        }

        $Num_Announcements = 3;
        $First_Announcements_Sticked = ORM::factory('Announcements')->where("stick", "=", 1)->where('is_deleted', '=', NULL)->order_by('id', 'desc')->limit($Num_Announcements)->find_all();
        $F_Count = count($First_Announcements_Sticked);
        if ($F_Count > 0) {
            $this->template->layout->First_Announcements_Sticked = $First_Announcements_Sticked;
        }
        if (($Num_Announcements - $F_Count) > 0) {
            $First_Announcements_NotSticked = ORM::factory('Announcements')->where("stick", "=", NULL)->where('is_deleted', '=', NULL)->order_by('id', 'desc')->limit($Num_Announcements - $F_Count)->find_all();
            if (count($First_Announcements_NotSticked) > 0) {
                $this->template->layout->First_Announcements_NotSticked = $First_Announcements_NotSticked;
            }
        }


        $Facebook = ORM::factory('Variables', 38)->value;
        if (!empty($Facebook)) {
            $this->template->layout->Facebook = $Facebook;
        }
        $twitter = ORM::factory('Variables', 39)->value;
        if (!empty($twitter)) {
            $this->template->layout->twitter = $twitter;
        }

        $services_scale = '/130/130';
        $product_scale = '/162/235';
        $client_scale = '/100/100';
        if (!empty($this->mobile_version)) {
            $this->template->layout->mobile_version = $this->mobile_version;
            $services_scale = '/300/300';
            $product_scale = '/283/405';
            $client_scale = '/200/200';
        }

        $this->template->layout->services_scale = $services_scale;
        $this->template->layout->product_scale = $product_scale;
        $this->template->layout->client_scale = $client_scale;

        $this->template->keywords = ORM::factory('Variables', 14)->{'value_' . $this->lang};
        $this->template->description = ORM::factory('Variables', 15)->{'value_' . $this->lang};
    }

}

// End Home
