<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Financials_Students extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $ShowTermsCost = FALSE;
    public $AddPayment = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        //$this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Students')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Students')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Students')));
        //$this->Delete =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Students')));
        $this->ShowTermsCost = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'ShowTermsCost')));
        $this->AddPayment = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Financials_Payments')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Students_Financials');
            $this->template->title = $title;
            $this->template->layout = new View('system/financials/students/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_TermsCost() {

        $par1 = $this->request->param('par1');

        $Obj = ORM::factory('User', $par1);

        if ($Obj->loaded() && $Obj->user_groub == 3 && $this->ShowTermsCost && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/financials/students/terms_cost');
            $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);

            $this->template->layout->User = $Obj;
            $this->template->layout->Student_Information = $Obj->Student_Information;
            $this->template->layout->Students_Terms = ORM::factory('Students_Terms')->where('term', '!=', $Current_Term->id)->where('student', '=', $Obj->id)->where('is_deleted', '=', NULL)->find_all();
            
            if($Current_Term->loaded()){
                $this->template->layout->Current_Term = $Current_Term;
            }
            
            $this->template->layout->title = $Obj->{'name_' . $this->lang};
            $this->template->title = $Obj->{'name_' . $this->lang};
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }
    public function action_Financial_report() {

        $par1 = $this->request->param('par1');

        $Obj = ORM::factory('User', $par1);

        if ($Obj->loaded() && $Obj->user_groub == 3 && $this->Browse && ($Obj->is_deleted == NULL)) {
            $this->template->layout = new View('system/financials/students/financial_report');

            $this->template->layout->User = $Obj;
            $this->template->layout->Student_Information = $Obj->Student_Information;
            $this->template->layout->Students_Terms = ORM::factory('Students_Terms')->where('student', '=', $Obj->id)->where('is_deleted', '=', NULL)->find_all();

            $Payments = ORM::factory('Financials_Payments')
                            ->where("student","=",$Obj->id)
                            ->where("is_deleted","=",NULL)
                            ->find_all();

            $this->template->layout->title = $Obj->{'name_' . $this->lang};
            $this->template->title = $Obj->{'name_' . $this->lang};
            $this->template->layout->lang = $this->lang;
            $this->template->layout->Payments = $Payments;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $StudentArr = isset($Filtered_array['Student']) ? Search::action_Filtered_array($Filtered_array['Student']) : NULL;
        $InfoArr = isset($Filtered_array['Information']) ? Search::action_Filtered_array($Filtered_array['Information']) : NULL;

        $Student = ORM::factory('User', $par1);

        if ($Student->loaded() && $StudentArr != NULL) {
            $Student->last_update_by = $this->user_online->id;
            $Student->last_update_date = date("Y-m-d H:i:s");

            $Student->values($StudentArr);

            try {
                if ($Student->save()) {
                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = General::CatchErrorMSGSAjax($errors);
            }
        }
        $S_Info = $Student->Student_Information;
        if ($S_Info->loaded() && $InfoArr != NULL) {
            $S_Info->last_update_by = $this->user_online->id;
            $S_Info->last_update_date = date("Y-m-d H:i:s");

            $S_Info->values($InfoArr);

            try {
                if ($S_Info->save()) {
                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = General::CatchErrorMSGSAjax($errors);
            }
        }


        echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "user.id",
        );

        $All_ORM = ORM::factory('User')
                ->with('Student_Information')
                ->where('user.user_groub', '=', 3)
                ->where('user.is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->and_where_open();
                $All_ORM->or_where(DB::expr('lower(Student_Information.Full_Name_Arabic)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->or_where(DB::expr('lower(Student_Information.Full_Name_English)'), 'LIKE', mb_strtolower("%$Name%"));
                $All_ORM->and_where_close();
            }
            if (!empty($post['username'])) {
                $username = $post['username'];
                $All_ORM->where(DB::expr('lower(user.username)'), 'LIKE', mb_strtolower("%$username%"));
            }
            if (!empty($post['ID_No'])) {
                $ID_No = $post['ID_No'];
                $All_ORM->where(DB::expr('lower(Student_Information.ID_No)'), 'LIKE', mb_strtolower("%$ID_No%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */

        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            ($this->ShowTermsCost) ? $buttons.='<a href="' . URL::base() . 'Financials_Students/TermsCost/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-list"></i> ' . Lang::__('Cost of terms') . '</a>' : NULL;
            ($this->AddPayment) ? $buttons .= '<a href="' . URL::base() . 'Financials_Payments/AE/add/' . $value->id . '" class="btn btn-xs blue"><i class="fa fa-plus"></i> ' . Lang::__('Add_Payment') . '</a>' : NULL;
            ($this->Browse) ? $buttons .= '<a href="' . URL::base() . 'Financials_Students/Financial_report/' . $value->id . '" class="btn btn-xs purple"><i class="fa fa-eye"></i> ' . Lang::__('Account_Statement') . '</a>' : NULL;
            $balance = Model_Financials_Payments::CalculateStudentBalance($value->id);
            $class_f_b = 'font-red-mint sbold';
            if ($balance >= 0) {
                $class_f_b = 'font-green-meadow sbold';
            }
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->username,
                $value->Student_Information->ID_No,
                $value->{'name_' . $this->lang},
                '<span class="' . $class_f_b . '">' . $balance . '</span>',
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
