<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Extra extends Controller_Template_Site {
    /*
     * فحص الهويات
     */

    public function action_CheckIDS() {
        $Students_Applications = ORM::factory('Students_Applications')->find_all();
        try {
            $username_not_10 = array();
            $username = array();
            $username_Err = array();
            foreach ($Students_Applications as $value) {

                $id = trim($value->ID_No);
                $type = substr($id, 0, 1);
                if (($type != 2 && $type != 1) || !is_numeric($id) || strlen($id) !== 10) {
                    array_push($username_not_10, $value->User->username . ' - رقم الهوية خاطئ لانه لا يساوي عشرة ارقام - ' . $value->ID_No);
                } else {
                    $sum = NULL;
                    for ($i = 0; $i < 10; $i++) {
                        //echo "  $id <b>"."</b> -";
                        if ($i % 2 == 0) {
                            $ZFOdd = str_pad(( substr($id, $i, 1) * 2), 2, "0", STR_PAD_LEFT);
                            $sum += substr($ZFOdd, 0, 1) + substr($ZFOdd, 1, 1);
                        } else {
                            $sum += substr($id, $i, 1);
                        }
                    }
                    $a = $sum % 10;

                    if ($a !== 0) {
                        array_push($username, $value->User->username . ' - رقم الهوية خاطئ بناء على الفحص  - ' . $value->ID_No);
                    } else {
                        if ($type == 1 && $value->Nationality != 1) { // الهوية سعودية والجنسية غير سعودي
                            array_push($username_Err, $value->User->username . ' - ' . $value->Full_Name_Arabic . '  - تم تحديد الجنسية ك سعودي ');
                        }
                    }
                }
            }
            $i = 1;
            foreach ($username_Err as $value) {
                echo $i . ' - ' . $value . '</br>';

                $i++;
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            echo $value->id . "</br>" . $value->User->id . "</br>" . $value->User->username . "</br>";
            print_r(General::CatchErrorMSGSAjax($errors));
        }
    }

    /*
     * اضافة المقدمات للارقام
     */

    public function action_CheckRoles() {
        $Students_Applications = ORM::factory('Students_Applications')->find_all();
        try {
            foreach ($Students_Applications as $value) {

                $value->check();
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            echo $value->id . "</br>" . $value->User->id . "</br>" . $value->User->username . "</br>";
            print_r(General::CatchErrorMSGSAjax($errors));
        }
    }

    /*
     * انشاء عضويات للطلاب
     */

    public function action_CreateUser() {
        $Students_Applications = ORM::factory('Students_Applications')->find_all();
        try {
            foreach ($Students_Applications as $objj) {

                if (empty($objj->student_id)) {

                    //اذا ما في مقابلة، يتم انشاء عضوية للطالب مباشرة
                    $Groub = ORM::factory('Usersgroub', 3); // Student
                    $password = Text::random('nozero', rand(8, 8));


                    $Year = date('y');
                    if ($objj->S_Type == 1 || $objj->S_Type == 2) {
                        $e = explode('-', $objj->Academic_Number);
                        $s = $e[1];
                        if (!empty($s[2]) && !empty($s[3])) {
                            $Year = $s[2] . $s[3];
                        }
                    }
                    if ($objj->S_Type == 3 || $objj->S_Type == 4) {
                        $e = explode('-', $objj->Academic_Number);
                        $s = $e[0];
                        if (!empty($s[2]) && !empty($s[3])) {
                            $Year = $s[2] . $s[3];
                        }
                    }

                    $username = $objj->GenerateAcadimicNo();

                    $User = ORM::factory('User');
                    $User->username = $username;
                    $User->password = $password;
                    $User->email = $objj->Email;
                    $User->user_groub = $Groub->id;
                    $User->name_ar = $objj->Full_Name_Arabic;
                    $User->name_en = $objj->Full_Name_English;
                    $User->Created_by = $this->user_online->id;
                    $User->Created_date = date("Y-m-d H:i:s");

                    if ($User->save()) {
                        // Grant user login role
                        $User->add('roles', ORM::factory('Role', array('name' => 'login')));

                        $objj->Initial_Approval = 2;
                        $objj->student_id = $User->id;
                        $objj->password = $password;
                        if ($objj->app_type == 'ba') {
                            $objj->level = ORM::factory('Variables', 79)->value;
                        } elseif ($objj->app_type == 'ma') {
                            $objj->level = ORM::factory('Variables', 80)->value;
                        }
                        if ($objj->save()) {
                            
                        }
                    }
                }
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            echo $objj->id;
            print_r(General::CatchErrorMSGSAjax($errors));
        }
    }

    /*
     * اضافة المقدمات للارقام
     */

    public function action_add966tomobile() {
        $Students_Applications = ORM::factory('Students_Applications')->find_all();
        try {
            foreach ($Students_Applications as $value) {
                $Mobile = $value->Mobile;
                if (strlen($Mobile) == 9) {
                    $value->Mobile = '966' . $Mobile;
                }

                $g_mobile = $value->g_mobile;
                if (strlen($g_mobile) == 9) {
                    $value->g_mobile = '966' . $g_mobile;
                }
                $value->update();
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            echo $value->id;
            print_r(General::CatchErrorMSGSAjax($errors));
        }
    }

    /*
     * استقبال الطلاب من ملف الاكسل
     */

    public function action_excel() {
        include DOCROOT . 'ext_classes/exelreader/simplexlsx.class.php';

        $xlsx = new SimpleXLSX(DOCROOT . 'students.xlsx');
        $students = $xlsx->rows();


        $arr = array(
            0 => "Full_Name_English", //English Name
            1 => "Full_Name_Arabic", //Arabic Name
            2 => "Gender", //Sex
            3 => "Academic_Number", //Academic Number //حقل جديد
            4 => "Nationality", //Nationality
            5 => "Nationality", //راح يتم حذفها
            6 => "Grade", //Grade
            7 => "Date_of_Birth_higri", //Birth Date
            8 => "Place_of_birth", //Birth Place
            9 => "ID_No", //ID Number
            10 => "ID_Expiry_Date_higri", //ID Expiry Date
            11 => "Mobile", //Mobile
            12 => "Phone", //Home Number
            13 => "Email", //E-Mail
            14 => "Address", //Address
            15 => "hs_School_Name", //School Name
            16 => "hs_Certificate_Type", //Certficate Type
            17 => "hs_Qudurat_points", //School Qudarat Points
            18 => "hs_Tofel_Points", //School Tofel Points
            19 => "hs_Country", //School Country
            20 => "hs_Graduation_Year_Higri", //School Graduate Yaer //حقل جديد
            21 => "hs_Percentage", //School Percentage
            22 => "hs_Grade_total", //School Graduate Total
            23 => "hs_Tahsele_Points", //School Tahsely Points
            24 => "hs_City", //School City
            25 => "ba_College", //College
            26 => "ba_University", //University
            27 => "ba_Major", //Major
            28 => "ba_General_Grade", //General Grade
            29 => "ba_GPA_old", //GPA //حقل جديد لانه يحتوي بيانات غير رقمية
            30 => "ba_Grade_Total", //Total Grade
            31 => "ba_Graduation_Year_higri", //Graduate Yaer //حقل جديد
            32 => "Master_College", //Master College //حقل جديد
            33 => "Master_University", //Master University //حقل جديد
            34 => "Master_Major", //Master Major //حقل جديد
            35 => "Master_Graduate_year", //Master Graduate year //حقل جديد
            36 => "Master_Total_Grade", //Master Total Grade //حقل جديد
            37 => "Master_General_Grade", //Master General Grade //حقل جديد
            38 => "Master_GPA", //Master GPA //حقل جديد
            39 => "Sponsor_Full_Name_English", //English Name
            40 => "Sponsor_Full_Name_Arabic", //Arabic Name
            41 => "Sponsor_Mobile", //Mobile Number
            42 => "Sponsor_Address", //Sponsor Address
            43 => "Sponsor_Office_number", //Office Number
            44 => "Sponsor_Email", //Email Address
            45 => "Sponsor_Legal_Form", //Legal Form
            46 => "Sponsor Address", //مكرر راح يتم حذفها
            47 => "g_Full_Name_English", //Guardian English Name
            48 => "g_Full_Name_Arabic", //Guardian Arabic Name
            49 => "g_Nationality", //Guardian Nationality
            50 => "g_email", //Email
            51 => "g_job_title", //Guardian Job Title
            52 => "g_Residency_No_Expiry_Date", //Guardian Residency No Expiry Date //حقل جديد
            53 => "g_Address", //Guardian Address
            54 => "g_id_number", //Guardian Residency No
            55 => "g_mobile", //Guardian Mobile
            56 => "g_relation", //Releationship
            57 => "g_home_number", //Guardian Home Number
            58 => "g_employer", //Guardian Employer
            59 => "g_study_level",
            60 => "E_Location", //Empolyer Loaction
            61 => "E_Level", //Empolyer Level //حقل جديد
            62 => "E_Experience_level", //Experience Level
            63 => "Starting_Date", //Starting Date //حقل جديد
            64 => "E_Occupation", //Occupation
            65 => "E_work_tel_number", //Work Tel
            66 => "E_Salary", //Salary
            67 => "E_Organization_ID", //Organization ID //حقل جديد
        );
        $New_Student_Arr = array();
        try {
            foreach ($students as $key => $value) {
                $S_Type = NULL;
                if ((($key >= 3) && ($key <= 191))) {
                    $S_Type = 1; //المنتظمين والمنتظمات ماجستير 
                } elseif ((($key >= 193) && ($key <= 577))) {
                    $S_Type = 2;  //الخريجين والخريجات ماجستير
                } elseif ((($key >= 579) && ($key <= 863))) {
                    $S_Type = 3;  //المنتظمين والمنتظمات بكالوريوس
                } elseif ((($key >= 865) && ($key <= 1139))) {
                    $S_Type = 4;  //الخريجين والخريجات بكالوريوس
                }
                if (!empty($S_Type)) {
                    $New_Student_Arr[$key]['S_Type'] = $S_Type;
                    if (in_array($S_Type, array(1, 2))) {
                        $New_Student_Arr[$key]['app_type'] = 'ma';
                    }
                    if (in_array($S_Type, array(3, 4))) {
                        $New_Student_Arr[$key]['app_type'] = 'ba';
                    }

                    foreach ($value as $kk => $vv) {
                        $Col_Name = $arr[$kk];

                        if (!in_array($kk, array(5, 46))) { //اعمدة ما تضيفها
                            if ($kk == 16) { //لتحديد نوع الشهادة المدرسية
                                $O = ORM::factory('General_Hscertypes')
                                        ->and_where_open()
                                        ->or_where('name_ar', '=', $vv)
                                        ->or_where('name_en', '=', $vv)
                                        ->and_where_close()
                                        ->where('is_deleted', '=', NULL)
                                        ->find();
                                if ($O->loaded()) {
                                    $vv = $O->id;
                                } else {
                                    if (!empty($vv)) {
                                        $O->name_en = $vv;
                                        $O->name_ar = $vv;
                                        $O->Created_by = $this->user_online->id;
                                        $O->Created_date = date("Y-m-d H:i:s");
                                        if ($O->save()) {
                                            $vv = $O->id;
                                        }
                                    }
                                }
                            }
                            if ($kk == 24) { //لتحديد مدينة المدرسة الثانوية
                                $O = ORM::factory('General_Cities')
                                        ->and_where_open()
                                        ->or_where('name_ar', '=', $vv)
                                        ->or_where('name_en', '=', $vv)
                                        ->and_where_close()
                                        ->where('is_deleted', '=', NULL)
                                        ->find();
                                if ($O->loaded()) {
                                    $vv = $O->id;
                                } else {
                                    if (!empty($vv)) {
                                        $O->country_id = $New_Student_Arr[$key]['hs_Country'];
                                        $O->name_en = $vv;
                                        $O->name_ar = $vv;
                                        $O->Created_by = $this->user_online->id;
                                        $O->Created_date = date("Y-m-d H:i:s");
                                        if ($O->save()) {
                                            $vv = $O->id;
                                        }
                                    }
                                }
                            }
                            if ($kk == 56) { //لتحديد العلاقة بين الطالب وولي الامر
                                $O = ORM::factory('General_Sprelations')
                                        ->and_where_open()
                                        ->or_where('name_ar', '=', $vv)
                                        ->or_where('name_en', '=', $vv)
                                        ->and_where_close()
                                        ->where('is_deleted', '=', NULL)
                                        ->find();
                                if ($O->loaded()) {
                                    $vv = $O->id;
                                } else {
                                    if (!empty($vv)) {
                                        $O->name_en = $vv;
                                        $O->name_ar = $vv;
                                        $O->Created_by = $this->user_online->id;
                                        $O->Created_date = date("Y-m-d H:i:s");
                                        if ($O->save()) {
                                            $vv = $O->id;
                                        }
                                    }
                                }
                            }
                            if (in_array($kk, array(19, 49, 4))) { //لتحديد الدول والجنسيات
                                if (in_array($vv, array('Saudi', 'سعودي', 'سعودية', 'سعوديه', 'السعودية', 'المملكه العربيه السعوديه', 'المملكة العربية السعودية', 'المملكة العربيه السعوديه'))) {
                                    $vv = 1;
                                } elseif (in_array($vv, array('Yamni', 'يمني', 'اليمن', 'يمنيه', 'يمنية'))) {
                                    $vv = 247;
                                } elseif (in_array($vv, array('سوداني'))) {
                                    $vv = 211;
                                } elseif (in_array($vv, array('لبنانيه', 'لبناني'))) {
                                    $vv = 122;
                                } elseif (in_array($vv, array('مصري'))) {
                                    $vv = 65;
                                } elseif (in_array($vv, array('فلسطيني'))) {
                                    $vv = 169;
                                } else {
                                    $vv = NULL;
                                }
                            }
                            if ($vv == 'فارغ') {
                                $vv = NULL;
                            }
                            $New_Student_Arr[$key][$Col_Name] = $vv;
                        }
                    }
                }
            }

            $i = 1;
            foreach ($New_Student_Arr as $value) {
                foreach ($value as $k1 => $v1) {
                    if (empty($v1)) {
                        unset($value[$k1]);
                    }
                }
                $Students_Applications = ORM::factory('Students_Applications');
                print_r($value);
                $Students_Applications->values($value);
                $Students_Applications->save();


                $i++;
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            print_r(General::CatchErrorMSGSAjax($errors));
        }
    }

    /*
     * For Convert Gerg date to Hegri Date
     */

    public function action_ConvertDateToHegri() {

        $post = $this->request->post();
        $HDate = !empty($post['HDate']) ? $post['HDate'] : NULL;

        echo json_encode(array('Hegri' => General::ConvertDateToHegri($HDate)));
    }

    public function action_ssss2() {

        echo ORM::factory('Students_Applications')->where('Nationality', '=', NULL)->count_all();
    }

    public function action_ssss3() {

        foreach (ORM::factory('Students_Applications')->where('Nationality', '=', NULL)->find_all() as $sssssss) {
            $rr = ORM::factory('Students_Applicationssssss', $sssssss->id);
            $sssssss->Nationality = $rr->Nationality;
            $sssssss->update();
        }
    }

}

// End Home
