<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Dictionary extends Controller_Template_Base {

    public $Browse_Dictionary = FALSE;
    public $Add_Dictionary = FALSE;
    public $Edit_Dictionary = FALSE;
    public $Delete_Dictionary = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want
        $this->Browse_Dictionary = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Browse_Dictionary')));
        $this->Add_Dictionary = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Add_Dictionary')));
        $this->Edit_Dictionary = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Edit_Dictionary')));
        $this->Delete_Dictionary = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Delete_Dictionary')));
    }

    public function action_index() {
        if ($this->Browse_Dictionary || $this->Add_Dictionary || $this->Edit_Dictionary || $this->Delete_Dictionary) {
            $this->template->title = Lang::__('dictionary');
            $this->template->layout = new View('system/dictionary/view_all');
            $this->template->layout->Add_Dictionary = $this->Add_Dictionary;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {
        $process_type = 'add_new';
        $par1 = $this->request->param('par1');
        $Obj = ORM::factory('Dictionary', $par1);
        if ($Obj->loaded()) {
            $process_type = 'modify';
        }
        if (($this->Add_Dictionary && ($process_type == 'add_new')) || ($this->Edit_Dictionary && ($process_type == 'modify'))) {

            $view = View::factory('system/dictionary/AE');
            if ($Obj->loaded()) {
                $view->set('Obj', $Obj);
            }
            $view->set('title', Lang::__($process_type));
            $view->set('lang', $this->lang);
            $this->response->body($view);
        } else {
            $view = View::factory('system/error_modal');
            $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
            $this->response->body($view);
        }
    }

    public function action_Delete($id) {
        if ($this->Delete_Dictionary) {
            $objj = ORM::factory('Dictionary', $id);
            if ($objj->loaded()) {

                if ($objj->delete()) {
                    
                } else {
                    return FALSE;
                }
            }
        }
    }

    public function action_ToDB() {
        $results = array();
        $obj_id = $this->request->param('par1');

        $objj = ORM::factory('Dictionary', $obj_id);

        if (($this->Add_Dictionary && (!$objj->loaded())) || ($this->Edit_Dictionary && ($objj->loaded()))) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());


            $objj->values($Filtered_array);

            if (!$objj->loaded()) {
                $objj->Created_by = $this->user_online->id;
                $objj->Created_date = date("Y-m-d H:i:s");
            } else {
                $objj->last_update_by = $this->user_online->id;
                $objj->last_update_date = date("Y-m-d H:i:s");
            }

            try {
                if ($objj->save()) {
                    $results['Success'] = '';
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = General::ArrayToString(General::CatchErrorMSGSAjax($errors));
            }
        } else {
            $results['Errors'] = Lang::__('You_dont_have_permission_to_do_this_action');
        }
        echo json_encode($results);
    }

    public function action_GetData() {
        if ($this->Browse_Dictionary || $this->Add_Dictionary || $this->Edit_Dictionary || $this->Delete_Dictionary) {

            $post = $this->request->post();
            $order = $post['order']; //Get how table order from datatable

            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );

            $All_ORM = ORM::factory('Dictionary')
                    ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);

            $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
            $C_Acti_status = "OK";

            /*
             * If Action exists
             */
            if (isset($post['customActionName'])) {
                switch ($post['customActionName']) {
                    case 'Delete':
                        $ids = array();
                        foreach ($post['id'] as $value) {
                            if ($this->action_Delete($value) === FALSE) {
                                array_push($ids, $value);
                            }
                        }

                        break;


                    default:
                        break;
                }
            }


            /*
             * if search exists
             */
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                if (!empty($post['token'])) {
                    $token = $post['token'];
                    $All_ORM->where(DB::expr('lower(token)'), 'LIKE', mb_strtolower("%$token%"));
                }
                if (!empty($post['txt_ar'])) {
                    $txt_ar = $post['txt_ar'];
                    $All_ORM->where(DB::expr('lower(txt_ar)'), 'LIKE', mb_strtolower("%$txt_ar%"));
                }
                if (!empty($post['txt_en'])) {
                    $txt_en = $post['txt_en'];
                    $All_ORM->where(DB::expr('lower(txt_en)'), 'LIKE', mb_strtolower("%$txt_en%"));
                }
            }

            /*
             * Paging
             */
            $All_ORM->reset(FALSE);
            $iTotalRecords = $All_ORM->count_all();

            $iDisplayLength = intval($post['length']);
            $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
            $iDisplayStart = intval($post['start']);
            $sEcho = intval($post['draw']);

            $records = array();
            $records["data"] = array();

            $end = $iDisplayStart + $iDisplayLength;
            $end = $end > $iTotalRecords ? $iTotalRecords : $end;

            $All_ORM->offset($iDisplayStart);
            $All_ORM->limit($iDisplayLength);


            /*
             * Prepare JSON Array
             */
            foreach ($All_ORM->find_all() as $value) {
                $Buttons = '';
                if ($this->Edit_Dictionary) {
                    $Buttons .= '<a data-url="' . URL::base() . 'Dictionary/AE/' . $value->id . '" class="btn btn-xs default EDIT" data-toggle="modal"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>';
                }
                $records["data"][] = array(
                    '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                    $value->token,
                    $value->txt_ar,
                    $value->txt_en,
                    $Buttons,
                );
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = $sEcho;
            $records["recordsTotal"] = $iTotalRecords;
            $records["recordsFiltered"] = $iTotalRecords;

            echo json_encode($records);
        }
    }

}

// End Dictionary
