<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Contact extends Controller_Template_Site {

    public function action_index() {
        $this->template->layout = new View('site/page/contact');
        $title = ORM::factory('Variables', 33)->value_ar;
        $this->template->layout->title = $title;
        $this->template->title = $title;
        $this->template->keywords = ORM::factory('Variables', 34)->value_ar;
        $this->template->description = ORM::factory('Variables', 35)->value_ar;
        $this->template->layout->lang = $this->lang;
    }

    public function action_Send() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $objj = ORM::factory('Contact');
        $Filtered_array['Created_date'] = date("Y-m-d H:i:s");
        $objj->values($Filtered_array);
        try {
            if ($objj->save()) {
                $msg_text = new View('email');
                $msg_text->set('lang', $this->lang);
                $msg_text->set('dir', $this->dir);
                $msg_text->set('Big_Title', $objj->name);
                $msg_text->set('Description_Title', $objj->name);
                $msg_text->set('Text1', nl2br($objj->message));
                //$msg_text->set('Text2', Lang::__('Username') . ": " . $objj->email . "<br>");
                //$msg_text->set('img_link', ORM::factory('Variables', 10)->value . "style/img/Go_en.png");
                $msg_text->set('img_href', ORM::factory('Variables', 12)->value);
                
                $send_result = Mailer::SendEmail($objj->email, $objj->name, ORM::factory('Variables', 11)->value, $objj->name, $msg_text->render());
                if ($send_result == TRUE) {
                    $objj->sended_to_admin_main = 1;
                    $objj->save();
                }
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('your_msg_success'),
                );
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

}

// End Page
