<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Community_Application extends Controller_Template_Site {

    public function action_AppSec() {
        $this->template->title = Lang::__('Follow up employment application');
        $this->template->layout = new View('site/admission/employment/appsec');
    }

    public function action_AppSecToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = !empty($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $password = !empty($Filtered_array['password']) ? $Filtered_array['password'] : NULL;

        $Obj = ORM::factory('Hr_Employment_Applications')
                ->where('app_id', '=', $id)
                ->where('app_password', '=', $password)
                ->find();
        if ($Obj->loaded()) {
            $session = Session::instance();

            // Find existing data
            $data = $session->get('Emp_Arr');

            // Add new array
            $data[] = array('id' => $Obj->app_id, 'password' => $Obj->app_password);

            // Resave it
            if ($session->set('Emp_Arr', $data)) {
                $results['Success'] = array(
                    "Redirect_url" => URL::base() . 'Admission_Employment/App/' . $Obj->id,
                );
            }
        } else {
            $results['Errors'] = array(
                "title" => Lang::__('Error'),
                "content" => Lang::__('Wrong_user_name_or_password'),
            );
        }

        echo json_encode($results);
    }

    public function action_App() {

        $session = Session::instance();
        $this->template->layout = new View('system/Community/application');

        $title = Lang::__("Community_service_course_application");
        if(isset($this->user_online->id) && $this->user_online->id != null){
            $this->template->layout->user_id = $this->user_online->id;
        }
        $this->template->layout->title = $title;
        $this->template->title = $title;
        $this->template->layout->Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
        $this->template->layout->lang = $this->lang;
        /*
          $par1 = $this->request->param('par1');
          $Obj = ORM::factory('Hr_Employment_Applications', $par1);

          $NewAppState = (ORM::factory('Variables', 86)->value == "Open") ? TRUE : FALSE;

          $Access = FALSE;
          if ($Obj->loaded()) {
          // Find existing data
          $data = $session->get('Emp_Arr');
          if (is_array($data)) {
          foreach ($data as $elm) {
          $id_ = !empty($elm['id']) ? $elm['id'] : NULL;
          $password_ = !empty($elm['password']) ? $elm['password'] : NULL;

          if ((mb_strtolower($id_) == mb_strtolower($Obj->app_id)) && mb_strtolower($password_) == mb_strtolower($Obj->app_password)) {
          $Access = TRUE;
          }
          }
          }
          }
          if ((!$Obj->loaded() && $NewAppState) || ($Obj->loaded() && $Access == TRUE)) {
          $this->template->layout = new View('system/Community/application');

          $title = Lang::__("Community_service_course_application");
          if ($Obj->loaded()) {
          $this->template->layout->Obj = $Obj;
          $this->template->layout->date_of_birth = explode('-', $Obj->date_of_birth);
          $this->template->layout->date_of_birth_higri = explode('-', $Obj->date_of_birth_higri);
          $this->template->layout->passport_expiration_date = explode('-', $Obj->passport_expiration_date);
          $this->template->layout->passport_expiration_date_higri = explode('-', $Obj->passport_expiration_date_higri);
          $this->template->layout->id_expiry_date_higri = explode('-', $Obj->id_expiry_date_higri);
          $this->template->layout->id_expiry_date = explode('-', $Obj->id_expiry_date);
          $this->template->layout->id_expiry_date_higri = explode('-', $Obj->id_expiry_date_higri);
          $this->template->layout->starting_date = explode('-', $Obj->starting_date);
          }
          $this->template->layout->Maritalstatus = ORM::factory('General_Maritalstatus')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Nationalities = ORM::factory('General_Countries')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Religions = ORM::factory('General_Religions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Banks = ORM::factory('General_Banks')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Sections = ORM::factory('General_Hr_Sections')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Employee_Types = ORM::factory('General_Hr_Employee_Types')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Departments = ORM::factory('General_Hr_Departments')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Positions = ORM::factory('General_Hr_Positions')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all();

          $this->template->layout->Qualifications = $Obj->Qualifications->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Certificates = $Obj->Certificates->where('is_deleted', '=', NULL)->find_all();
          $this->template->layout->Experiances = $Obj->Experiances->where('is_deleted', '=', NULL)->find_all();

          $this->template->layout->title = $title;
          $this->template->title = $title;

          $this->template->layout->lang = $this->lang;
          } else {

          } */
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];
        $objj = ORM::factory('Community_Request_db');
        $session = Session::instance();
        $objj->Created_date = date("Y-m-d H:i:s");
        if(isset($this->user_online->id) && $this->user_online->id != NULL){
            $objj->HR_id = $this->user_online->id;
        }
        $objj->values($Filtered_array);
        try {
            if ($objj->save()) {

                $results['SuccessR'] = array(
                    'title' => Lang::__('Done'),
                    'content' => Lang::__('Saved_successfully'),
                    'Redirect' => URL::base() . "Community_Application/App/" . $objj->id,
                );
            }
        } catch (ORM_Validation_Exception $e) {
            $errors = $e->errors('');
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
            );
        }


        echo json_encode($results);
    }

    public function action_DeleteDetails() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $id = isset($Filtered_array['id']) ? $Filtered_array['id'] : NULL;
        $par2 = isset($Filtered_array['par2']) ? $Filtered_array['par2'] : NULL;

        if (in_array($par2, array('Qualifications', 'Certificates', 'Experiances'))) {
            $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);
            if ($Obj->loaded()) {
                $session = Session::instance();

                $Access = FALSE;
                // Find existing data
                $data = $session->get('Emp_Arr');
                if (is_array($data)) {
                    foreach ($data as $elm) {
                        $id_ = !empty($elm['id']) ? $elm['id'] : NULL;
                        $password_ = !empty($elm['password']) ? $elm['password'] : NULL;

                        if ((mb_strtolower($id_) == mb_strtolower($Obj->Hr_Employment_Application->app_id)) && mb_strtolower($password_) == mb_strtolower($Obj->Hr_Employment_Application->app_password)) {
                            $Access = TRUE;
                        }
                    }
                }


                if ($Access) {
                    $Obj->is_deleted = 1;
                    $Obj->deleted_by = $this->user_online->id;
                    $Obj->deleted_date = date("Y-m-d H:i:s");
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } else {
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                    );
                }
            } else {

                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('Not_found_the_desired_item'),
                );
            }
        } else {

            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('Not_found_the_desired_item'),
            );
        }

        $Obj = ORM::factory('Hr_Employment_Applications_' . $par2, $id);


        echo json_encode($results);
    }

    /*
     * Send Json of rules to jquery validation
     */

    public function action_GetRules() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());

        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $ORM = ORM::factory('Community_Request_db', $par1);

        $results['Rules'] = $ORM->AdminRules($ORM);


        echo json_encode($results);
    }

    protected function _save_image($image, $width = NULL, $height = NULL, $directory, $directory_thumbs, $extensions, $max_file_size) {
        if (!Upload::valid($image) OR ! Upload::not_empty($image) OR ! Upload::type($image, $extensions) OR ! Upload::size($image, $max_file_size)) {
            return FALSE;
        }

        if (!empty($directory)) {
            $directory_D = DOCROOT . str_replace("\\", "/", $directory);
            if (!file_exists($directory_D)) {
                mkdir($directory_D, 0777, true);
            }
        }

        if (!empty($directory_thumbs)) {
            $directory_thumbs_D = DOCROOT . str_replace("\\", "/", $directory_thumbs);
            if (!file_exists($directory_thumbs_D)) {
                mkdir($directory_thumbs_D, 0777, true);
            }
        }

        $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
        $filename = mb_strtolower(Text::random('alnum', rand(10, 30))) . '.' . $ext;

        if (in_array(mb_strtolower($ext), array("gif", "jpeg", "jpg", "png", "bmp"))) {
            if ($file = Upload::save($image, NULL, $directory)) {
                $img = Image::factory($file);
                $img->save($directory . $filename, 100);
                if (!empty($directory_thumbs)) {
                    $img->resize($width, $height, Image::INVERSE);
                    $img->save($directory_thumbs . $filename, 100);
                }
                // Delete the temporary file
                unlink($file);

                return $filename;
            }
        } else {
            if ($file = Upload::save($image, $filename, $directory)) {

                return $filename;
            }
        }
    }

}

// End Onlinereg
