<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Accounting_Salaries extends Controller_Template_Base {

    public $Calculation_of_salaries = FALSE;
    public $Post_Salaries_To_Accounts = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Calculation_of_salaries = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Calculation_of_salaries')));
        $this->Post_Salaries_To_Accounts = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'Post_Salaries_To_Accounts')));
    }

    public function action_index() {
        if ($this->Calculation_of_salaries || $this->Post_Salaries_To_Accounts) {
            $title = Lang::__('Salaries');
            $this->template->title = $title;

            $this->template->layout = new View('system/accounting/salaries/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Hr_Allowances_Types = ORM::factory('Hr_Allowances_Types')->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->Hr_Deductions_Types = ORM::factory('Hr_Deductions_Types')->where('is_deleted', '=', NULL)->find_all();
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_GetData() {
        if ($this->Calculation_of_salaries || $this->Post_Salaries_To_Accounts) {
            $post = $this->request->post();
            /*
             * All coulums will shown in table
             */
            $ALL_coulums = array(
                1 => "id",
            );
            if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                $All_ORM = ORM::factory('Hr_Employment_Applications')
                        ->where('is_deleted', '=', NULL)
                        ->where('app_status', '=', 1);

                //Fines
                $All_ORM->with("Course");


                $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
                $C_Acti_status = "OK";

                /*
                 * If Action exists
                 */
                if (isset($post['customActionName'])) {
                    switch ($post['customActionName']) {
                        case 'Delete':


                            break;


                        default:
                            break;
                    }
                }
                /*
                 * If Action exists
                 */
                if (isset($post['CalActionType'])) {
                    switch ($post['ActionName']) {
                        case 'Post_Salaries':
                            if ($this->Post_Salaries_To_Accounts) {
                                $this->Post_Salaries($post['id']);
                            }
                            break;


                        default:
                            break;
                    }
                }


                /*
                 * if search exists
                 */
                if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
                    if (!empty($post['college'])) {
                        $All_ORM->where('college', '=', $post['college']);
                    }
                    if (!empty($post['employee'])) {
                        $All_ORM->where('id', '=', $post['employee']);
                    }
                    if (!empty($post['department'])) {
                        $All_ORM->where('department', '=', $post['department']);
                    }
                    if (!empty($post['bank'])) {
                        $All_ORM->where('bank', '=', $post['bank']);
                    }
                    if (!empty($post['Section'])) {
                        $All_ORM->where('hr_section', '=', $post['Section']);
                    }
                    if (!empty($post['gender'])) {
                        $All_ORM->where('gender', '=', $post['gender']);
                    }
                    if (!empty($post['position'])) {
                        $All_ORM->where('hr_position', '=', $post['position']);
                    }
                    if (!empty($post['employee_type'])) {
                        $All_ORM->where('employee_type', '=', $post['employee_type']);
                    }
                }

                /*
                 * Paging
                 */
                $All_ORM->reset(FALSE);
                $iTotalRecords = $All_ORM->count_all();

                $iDisplayLength = intval($post['length']);
                $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
                $iDisplayStart = intval($post['start']);
                $sEcho = intval($post['draw']);

                $records = array();
                $records["data"] = array();

                $end = $iDisplayStart + $iDisplayLength;
                $end = $end > $iTotalRecords ? $iTotalRecords : $end;

                $All_ORM->offset($iDisplayStart);
                $All_ORM->limit($iDisplayLength);



                /*
                 * Prepare JSON Array
                 */
                $Total_net_salary = 0; //اجمالي صافي الرواتب
                $Total_basic_salary = 0; //اجمالي الرواتب الاساسي
                $Total_discounts = 0; //اجمالي الخصومات
                $Total_Rewards = 0; //اجمالي المكافئات
                $Total_DBODA = 0;  // اجمالي الخصم على التأخر والغياب 
                $TotalMinutesLate = 0;  // اجمالي ساعات التأخير 
                $TotalAbsents = 0;  // اجمالي الغيابات 
                $Total_Basic_salary_with_Allowances = 0; //اجمالي مجموع صافي الرواتب مع البدلات
                //بيانات الخصومات والزيادات

                $Hr_Allowances_Types = ORM::factory('Hr_Allowances_Types')->where('is_deleted', '=', NULL)->find_all();
                $Hr_Deductions_Types = ORM::factory('Hr_Deductions_Types')->where('is_deleted', '=', NULL)->find_all();
                
                foreach ($Hr_Allowances_Types as $Allowance_Types) { //لحساب المجموع لكل الصفوف
                    $AllVarName = 'Allowance' . $Allowance_Types->id;
                    $$AllVarName = 0;
                }
                
                foreach ($Hr_Deductions_Types as $Deduction_Types) { //لحساب المجموع لكل الصفوف
                    $DedVarName = 'Deduction' . $Deduction_Types->id;
                    $$DedVarName = 0;
                }


                foreach ($All_ORM->find_all() as $value) {
                    $Year = (!empty($post['year'])) ? $post['year'] : Date('Y');
                    $Month = (!empty($post['month'])) ? $post['month'] : Date('n');

                    $Salary = Model_Hr_Employment_Applications::CalculateSalarie($value, $Year, $Month);


                    $Total_net_salary += $Salary['net_salary'];
                    $Total_basic_salary += $value->basic_salary;
                    $Total_discounts += $Salary['Discounts'];
                    $Total_Rewards += $Salary['Rewards'];
                    $Total_DBODA += $Salary['DBODA'];
                    $TotalAbsents += $Salary['absent'];

                    $net_salary = $Salary['net_salary'];
                    $net_salary .= '  <button class="btn blue btn-xs explain_salary" employee="' . $value->id . '" year="' . $Year . '" month="' . $Month . '">' . Lang::__('explain') . '</button>';


                    $Final_Arr = array(
                        '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                        $value->code,
                        $value->{'name_first_' . $this->lang} . ' ' . $value->{'name_father_' . $this->lang} . ' ' . $value->{'name_grandfather_' . $this->lang} . ' ' . $value->{'name_last_' . $this->lang},
                        $Salary['DaysInThisMonth'],
                        $Salary['TotalMinutesLate'],
                        $Salary['absent'],
                        $value->basic_salary,
                        $Salary['DBODA'],
                        $net_salary,
                    );

                    //اضافة اعمدة البدلات
                    $Hr_Allowances_Types_arr = array();
                    $Basic_salary_with_Allowances = $value->basic_salary;
                    foreach ($Hr_Allowances_Types as $Allowance_Types) {
                        $AllVarName = 'Allowance' . $Allowance_Types->id;
                        $Aloo = '';
                        $Hr_Allowances_Relations = ORM::factory('Hr_Allowances_Relations')
                                ->where('type', '=', $Allowance_Types->id)
                                ->where('employee', '=', $value->id)
                                ->where('is_deleted', '=', NULL)
                                ->find();
                        if ($Hr_Allowances_Relations->loaded()) {
                            if (!empty($Allowance_Types->amount)) {
                                $Basic_salary_with_Allowances += $Allowance_Types->amount;
                                $$AllVarName += $Allowance_Types->amount;
                                $Aloo = $Allowance_Types->amount;
                            } elseif ($Allowance_Types->percentage !== NULL) {
                                $d_Amount = ($Allowance_Types->percentage * $value->basic_salary) / 100;
                                $Basic_salary_with_Allowances += $d_Amount;
                                $$AllVarName += $d_Amount;
                                $Aloo = $Allowance_Types->percentage . '% (' . $d_Amount . ')';
                            }
                        }
                        array_push($Hr_Allowances_Types_arr, $Aloo);
                    }

                    $Final_Arr = array_merge_recursive($Final_Arr, $Hr_Allowances_Types_arr);
                    array_push($Final_Arr, $Basic_salary_with_Allowances); //اضافة عمود مجموع الراتب الاساسي مع البدلات
                    $Total_Basic_salary_with_Allowances += $Basic_salary_with_Allowances;
                    //نهاية اضافة اعمدة البدلات
                    //اضافة اعمدة الخصومات
                    $Hr_Deductions_Types_arr = array();
                    foreach ($Hr_Deductions_Types as $Deduction_Types) {
                        $DedVarName = 'Deduction' . $Deduction_Types->id;
                        $Aloo = '';
                        $Hr_Deductions_Relations = ORM::factory('Hr_Deductions_Relations')
                                ->where('type', '=', $Deduction_Types->id)
                                ->where('employee', '=', $value->id)
                                ->where('is_deleted', '=', NULL)
                                ->find();
                        if ($Hr_Deductions_Relations->loaded()) {
                            if (!empty($Deduction_Types->amount)) {
                                $Aloo = $Deduction_Types->amount;
                                $$DedVarName+= $Deduction_Types->amount;
                            } elseif ($Deduction_Types->percentage !== NULL) {
                                $d_Amount = ($Deduction_Types->percentage * $value->basic_salary) / 100;
                                $$DedVarName+= $d_Amount;
                                $Aloo = $Deduction_Types->percentage . '% (' . $d_Amount . ')';
                            }
                        }
                        array_push($Hr_Deductions_Types_arr, $Aloo);
                    }

                    $Final_Arr = array_merge_recursive($Final_Arr, $Hr_Deductions_Types_arr);
                    //نهاية اضافة اعمدة الخصومات

                    $records["data"][] = $Final_Arr;
                }

                //بداية انشاء مجاميع الفوتر
                $TableFoot = '<td colspan="4" class="text-center">'.Lang::__('Total').'</td>';
                $TableFoot .= '<td class="text-center">'.$TotalMinutesLate.'</td>';
                $TableFoot .= '<td class="text-center">'.$TotalAbsents.'</td>';
                $TableFoot .= '<td class="text-center">' . $Total_basic_salary . '</td>';
                $TableFoot .= '<td class="text-center">' . $Total_DBODA . '</td>';
                $TableFoot .= '<td class="text-center">' . $Total_net_salary . '</td>';
                foreach ($Hr_Allowances_Types as $Allowance_Types) {
                    $AllVarName = 'Allowance' . $Allowance_Types->id;
                    $TableFoot .= '<td class="text-center">' . $$AllVarName . '</td>';
                }
                $TableFoot .= '<td class="text-center">' . $Total_Basic_salary_with_Allowances . '</td>'; //مجموع الراتب الاساسي مع البدلات
                foreach ($Hr_Deductions_Types as $Deduction_Types) {
                    $DedVarName = 'Deduction' . $Deduction_Types->id;
                    $TableFoot .= '<td class="text-center">'.$$DedVarName.'</td>';
                }
                //نهاية انشاء مجاميع الفوتر

                $records["TableFoot"] = $TableFoot;
            }
            if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
                $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
                $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
            }

            $records["draw"] = isset($sEcho) ? $sEcho : intval($post['draw']);
            $records["recordsTotal"] = isset($iTotalRecords) ? $iTotalRecords : 0;
            $records["recordsFiltered"] = isset($iTotalRecords) ? $iTotalRecords : 0;
            if (!isset($records["data"])) {
                $records["data"] = array();
            }
            echo json_encode($records);
        }
    }

    /*
     * ترحيل الرواتب للحسابات
     */

    public function action_Post_Salaries_Confirmation() {
        $results = array();
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        //لفحص وجود الحسابات
        $Employees_salaries_link = ORM::factory('Accounting_Links', 8);
        $Bank_of_employees_salaries_link = ORM::factory('Accounting_Links', 9);
        if ($Employees_salaries_link->loaded() && !empty($Employees_salaries_link->account_id) && $Bank_of_employees_salaries_link->loaded() && !empty($Bank_of_employees_salaries_link->account_id)) {
            $ids = !empty($Filtered_array['ids']) ? $Filtered_array['ids'] : NULL;
            $ajaxParams = !empty($Filtered_array['ajaxParams']) ? $Filtered_array['ajaxParams'] : NULL;
            $month = !empty($ajaxParams['month']) ? $ajaxParams['month'] : NULL;
            $year = !empty($ajaxParams['year']) ? $ajaxParams['year'] : NULL;
            if ($this->Post_Salaries_To_Accounts && is_array($ids) && checkdate($month, 1, $year)) {
                $Employment_Applications = ORM::factory('Hr_Employment_Applications')
                        ->where('id', 'IN', $ids)
                        ->where('app_status', '=', 1)
                        ->where('is_deleted', '=', NULL)
                        ->find_all();
                $Employees_were_paid_this_month = array(); //موظفين تم ترحيل رواتبهم مسبقا هذا الشهر
                $Employees_were_NOT_paid_this_month = array(); //موظفين لم ترحل رواتبهم لهذا الشهر
                foreach ($Employment_Applications as $Employee) {

                    $Accounting_Employees_Salary = $Employee->Accounting_Employees_Salarys
                            ->where('is_deleted', '=', NULL)
                            ->where('year', '=', $year)
                            ->where('month', '=', $month)
                            ->find();
                    if ($Accounting_Employees_Salary->loaded()) {
                        array_push($Employees_were_paid_this_month, array(
                            'employee_name' => $Employee->{'name_first_' . $this->lang} . ' ' . $Employee->{'name_father_' . $this->lang} . ' ' . $Employee->{'name_grandfather_' . $this->lang} . ' ' . $Employee->{'name_last_' . $this->lang},
                            'trans_id' => $Accounting_Employees_Salary->trans_id,
                            'basic_salary' => $Accounting_Employees_Salary->basic_salary,
                            'net_salary' => $Accounting_Employees_Salary->net_salary,
                            'Discounts' => $Accounting_Employees_Salary->discounts,
                            'Rewards' => $Accounting_Employees_Salary->rewards,
                            'allowances' => $Accounting_Employees_Salary->allowances,
                            'deductions' => $Accounting_Employees_Salary->deductions,
                            'Created_by' => $Accounting_Employees_Salary->Created_by_User->{'name_' . $this->lang},
                            'Created_date' => $Accounting_Employees_Salary->Created_date,
                            'DBODA' => $Accounting_Employees_Salary->DBODA,
                        ));
                    } else {
                        $Salary = Model_Hr_Employment_Applications::CalculateSalarie($Employee, $year, $month);

                        array_push($Employees_were_NOT_paid_this_month, array(
                            'employee_name' => $Employee->{'name_first_' . $this->lang} . ' ' . $Employee->{'name_father_' . $this->lang} . ' ' . $Employee->{'name_grandfather_' . $this->lang} . ' ' . $Employee->{'name_last_' . $this->lang},
                            'basic_salary' => $Employee->basic_salary,
                            'net_salary' => $Salary['net_salary'],
                            'Discounts' => $Salary['Discounts'],
                            'Rewards' => $Salary['Rewards'],
                            'Allowances' => $Salary['allowances'],
                            'Deductions' => $Salary['deductions'],
                            'DBODA' => $Salary['DBODA'],
                        ));
                    }
                }


                $Text = '';

                if (!empty($Employees_were_paid_this_month)) {
                    $CEmployees_were_paid_this_month = count($Employees_were_paid_this_month);
                    if ($CEmployees_were_paid_this_month == 1) {
                        $Text .= '<h4 class="bg-red bg-font-red" style="padding:10px;">' . Lang::__('The following employee will not be posted due to his salary being transferred Previously for the same month and year listed') . '</h4>';
                    } elseif ($CEmployees_were_paid_this_month > 1) {
                        $Text .= '<h4 class="bg-red bg-font-red" style="padding:10px;">' . Lang::__('The following employees will not be posted due to them salaries was transferred previous for the same month and year listed') . '</h4>';
                    }
                    $Text .= '<table class="table table-bordered table-condensed table-striped">';
                    $Text .= '<tr><th class="text-center">' . Lang::__('Name') . '</th><th class="text-center">' . Lang::__('basic_salary') . '</th><th class="text-center">' . Lang::__('Discounts') . '</th><th class="text-center">' . Lang::__('Rewards') . '</th><th class="text-center">' . Lang::__('net_salary') . '</th><th class="text-center">' . Lang::__('trans_id') . '</th><th class="text-center">' . Lang::__('deductions') . '</th><th class="text-center">' . Lang::__('allowances') . '</th><th class="text-center">' . Lang::__('DBODA') . '</th><th class="text-center">' . Lang::__('Created_by') . '</th><th class="text-center">' . Lang::__('Created_date') . '</th></tr>';
                    foreach ($Employees_were_paid_this_month as $value) {
                        $Text .= '<tr class="danger"><td class="text-center">' . $value['employee_name'] . '</td><td class="text-center">' . $value['basic_salary'] . '</td><td class="text-center">' . $value['Discounts'] . '</td><td class="text-center">' . $value['Rewards'] . '</td><td class="text-center">' . $value['net_salary'] . '</td><td class="text-center">' . $value['trans_id'] . '</td><td class="text-center">' . $value['deductions'] . '</td><td class="text-center">' . $value['allowances'] . '</td><td class="text-center">' . $value['DBODA'] . '</td><td class="text-center">' . $value['Created_by'] . '</td><td class="text-center">' . $value['Created_date'] . '</td></tr>';
                    }
                    $Text .= '</table>';
                }

                if (!empty($Employees_were_NOT_paid_this_month)) {
                    $CEmployees_were_NOT_paid_this_month = count($Employees_were_NOT_paid_this_month);
                    if ($CEmployees_were_NOT_paid_this_month == 1) {
                        $Text .= '<h4 class="bg-green bg-font-green" style="padding:10px;">' . Lang::__('The following employee will be posted') . ' ' . $month . ' ' . Lang::__('For_Year') . ' ' . $year . ':</h4>';
                    } elseif ($CEmployees_were_NOT_paid_this_month > 1) {
                        $Text .= '<h4 class="bg-green bg-font-green" style="padding:10px;">' . Lang::__('The following employees will be posted') . ' ' . $month . ' ' . Lang::__('For_Year') . ' ' . $year . ':</h4>';
                    }
                    $Text .= '<table class="table table-bordered table-condensed table-striped">';
                    $Text .= '<tr><th class="text-center">' . Lang::__('Name') . '</th><th class="text-center">' . Lang::__('basic_salary') . '</th><th class="text-center">' . Lang::__('Discounts') . '</th><th class="text-center">' . Lang::__('Rewards') . '</th><th class="text-center">' . Lang::__('Allowances') . '</th><th class="text-center">' . Lang::__('Deductions') . '</th><th class="text-center">' . Lang::__('DBODA') . '</th><th class="text-center">' . Lang::__('net_salary') . '</th></tr>';
                    $sum_basic_salary = 0;
                    $sum_Discounts = 0;
                    $sum_Rewards = 0;
                    $sum_allowances = 0;
                    $sum_deductions = 0;
                    $sum_DBODA = 0;
                    $sum_net_salary = 0;
                    foreach ($Employees_were_NOT_paid_this_month as $value) {
                        $sum_basic_salary += $value['basic_salary'];
                        $sum_Discounts += $value['Discounts'];
                        $sum_Rewards += $value['Rewards'];
                        $sum_allowances += $value['Allowances'];
                        $sum_deductions += $value['Deductions'];
                        $sum_DBODA += $value['DBODA'];
                        $sum_net_salary += $value['net_salary'];
                        $Text .= '<tr class="success"><td class="text-center">' . $value['employee_name'] . '</td><td class="text-center">' . $value['basic_salary'] . '</td><td class="text-center">' . $value['Discounts'] . '</td><td class="text-center">' . $value['Rewards'] . '</td><td class="text-center">' . $value['Allowances'] . '</td><td class="text-center">' . $value['Deductions'] . '</td><td class="text-center">' . $value['DBODA'] . '</td><td class="text-center">' . $value['net_salary'] . '</td></tr>';
                    }
                    $Text .= '<tr><th class="text-center">' . Lang::__('Total') . '</th><th class="text-center">' . $sum_basic_salary . '</th><th class="text-center">' . $sum_Discounts . '</th><th class="text-center">' . $sum_Rewards . '</th><th class="text-center">' . $sum_allowances . '</th><th class="text-center">' . $sum_deductions . '</th><th class="text-center">' . $sum_DBODA . '</th><th class="text-center">' . $sum_net_salary . '</th></tr>';
                    $Text .= '</table>';
                }
                $WillPostCount = count($Employees_were_NOT_paid_this_month); //عدد الموظفين اللي رح تترحل رواتبهم
                $results = array('Success' => array(
                        'Text' => $Text,
                        'PostButton' => ($WillPostCount > 0) ? TRUE : FALSE,
                ));
            } elseif (!$this->Post_Salaries_To_Accounts) {
                $results = array();
                $results['Error'] = array(
                    'Title' => Lang::__('Error'),
                    'Content' => Lang::__('You_dont_have_permission_to_do_this_action'),
                );
            } elseif (!checkdate($month, 1, $year)) {
                $results = array();
                $results['Error'] = array(
                    'Title' => Lang::__('Error'),
                    'Content' => Lang::__('Please specify month and year'),
                );
            }
        } else {
            if (!($Employees_salaries_link->loaded() && !empty($Employees_salaries_link->account_id) && $Bank_of_employees_salaries_link->loaded() && !empty($Bank_of_employees_salaries_link->account_id))) {
                $results['Error'] = array(
                    'Title' => Lang::__('Error'),
                    'Content' => Lang::__('In linking accounts please make sure to link') . ' ' . $Employees_salaries_link->{'name_' . $this->lang} . ' ' . Lang::__('And') . ' ' . $Bank_of_employees_salaries_link->{'name_' . $this->lang},
                );
            }
        }

        echo json_encode($results);
    }

    public function action_Post_Salaries() {
        $results = array();

        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());
        $Employees_salaries_link = ORM::factory('Accounting_Links', 8);
        $Bank_of_employees_salaries_link = ORM::factory('Accounting_Links', 9);
        if ($Employees_salaries_link->loaded() && !empty($Employees_salaries_link->account_id) && $Bank_of_employees_salaries_link->loaded() && !empty($Bank_of_employees_salaries_link->account_id)) {

            $ids = !empty($Filtered_array['ids']) ? $Filtered_array['ids'] : NULL;
            $ajaxParams = !empty($Filtered_array['ajaxParams']) ? $Filtered_array['ajaxParams'] : NULL;
            $month = !empty($ajaxParams['month']) ? $ajaxParams['month'] : NULL;
            $year = !empty($ajaxParams['year']) ? $ajaxParams['year'] : NULL;

            if ($this->Post_Salaries_To_Accounts && is_array($ids) && checkdate($month, 1, $year)) {
                $Employment_Applications = ORM::factory('Hr_Employment_Applications')
                        ->where('id', 'IN', $ids)
                        ->where('app_status', '=', 1)
                        ->where('is_deleted', '=', NULL)
                        ->find_all();
                try {
                    $Total_net_salary = 0;
                    $Total_basic_salary = 0;
                    $Total_Discounts = 0;
                    $Total_Rewards = 0;
                    $Total_allowances = 0;
                    $Total_deductions = 0;
                    $Salaries = array();
                    foreach ($Employment_Applications as $Employee) {
                        $Accounting_Employees_Salary = $Employee->Accounting_Employees_Salarys
                                ->where('is_deleted', '=', NULL)
                                ->where('year', '=', $year)
                                ->where('month', '=', $month)
                                ->find();
                        if (!$Accounting_Employees_Salary->loaded()) {

                            $Salary = Model_Hr_Employment_Applications::CalculateSalarie($Employee, $year, $month);

                            array_push($Salaries, array(
                                'trans_id' => '',
                                'employee' => $Employee->id,
                                'basic_salary' => $Employee->basic_salary,
                                'net_salary' => $Salary['net_salary'],
                                'discounts' => $Salary['Discounts'],
                                'rewards' => $Salary['Rewards'],
                                'allowances' => $Salary['allowances'],
                                'deductions' => $Salary['deductions'],
                                'DBODA' => $Salary['DBODA'],
                                'month' => $month,
                                'year' => $year,
                                'Created_by' => $this->user_online->id,
                                'Created_date' => date("Y-m-d H:i:s"),
                            ));

                            $Total_net_salary += $Salary['net_salary'];
                            $Total_basic_salary += $Employee->basic_salary;
                            $Total_Discounts += $Salary['Discounts'];
                            $Total_Rewards += $Salary['Rewards'];
                            $Total_allowances += $Salary['allowances'];
                            $Total_deductions += $Salary['deductions'];
                        }
                    }

                    $Trans_Array = array(
                        'branchno' => NULL,
                        'transno' => NULL,
                        'transYear' => Date('Y'),
                        'BranchSubno' => NULL,
                        'Gregorian_date' => date("Y-m-d"),
                        'Hijri_date' => General::ConvertDateToHegri(date("Y-m-d")),
                        'amount' => $Total_net_salary,
                        'Description' => '',
                        'Posted' => 1,
                        'Post_By' => $this->user_online->id,
                        'PostDate' => date("Y-m-d H:i:s"),
                        'Reversedno' => NULL,
                        'ReversedYear' => NULL,
                        'ReversedBranch' => NULL,
                        'CostCenterno' => NULL,
                        'Details' => array(
                            array(
                                'transYear' => Date('Y'),
                                'AccYear' => NULL,
                                'posted' => 1,
                                'TransNo' => NULL,
                                'AccNo' => ORM::factory('Accounting_Links', 9)->account_id,
                                'debit' => NULL,
                                'credit' => $Total_net_salary,
                                'Description' => NULL,
                                'PreDebitBal' => NULL,
                                'PreCreditBal' => NULL,
                                'CostCenterno' => NULL,
                            ),
                            array(
                                'transYear' => Date('Y'),
                                'AccYear' => NULL,
                                'posted' => 1,
                                'TransNo' => NULL,
                                'AccNo' => ORM::factory('Accounting_Links', 8)->account_id,
                                'debit' => $Total_net_salary,
                                'credit' => NULL,
                                'Description' => NULL,
                                'PreDebitBal' => NULL,
                                'PreCreditBal' => NULL,
                                'CostCenterno' => NULL,
                            ),
                        ),
                    );
                    $ToDB = Model_Accounting_Accounts_Trans::TransToDB($Trans_Array, NULL, $this->user_online);

                    if (array_key_exists('Success', $ToDB)) {
                        $Succ_Arr = $ToDB['Success'];
                        foreach ($Salaries as $Salarie) {
                            $ORM_Salary = ORM::factory('Accounting_Employees_Salary');
                            $ORM_Salary->trans_id = $Succ_Arr['Trans'];
                            $ORM_Salary->employee = $Salarie['employee'];
                            $ORM_Salary->basic_salary = $Salarie['basic_salary'];
                            $ORM_Salary->net_salary = $Salarie['net_salary'];
                            $ORM_Salary->discounts = $Salarie['discounts'];
                            $ORM_Salary->rewards = $Salarie['rewards'];
                            $ORM_Salary->allowances = $Salarie['allowances'];
                            $ORM_Salary->deductions = $Salarie['deductions'];
                            $ORM_Salary->month = $Salarie['month'];
                            $ORM_Salary->year = $Salarie['year'];
                            $ORM_Salary->Created_by = $Salarie['Created_by'];
                            $ORM_Salary->Created_date = $Salarie['Created_date'];
                            $ORM_Salary->save();
                        }

                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Salary was successfully migrated'),
                        );
                    } elseif (array_key_exists('Errors', $ToDB)) {
                        $results['Errors'] = $ToDB['Errors'];
                    }
                } catch (ORM_Validation_Exception $e) {
                    $errors = $e->errors('');

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            }
        } else {
            if (!($Employees_salaries_link->loaded() && !empty($Employees_salaries_link->account_id) && $Bank_of_employees_salaries_link->loaded() && !empty($Bank_of_employees_salaries_link->account_id))) {
                $results['Errors'] = array(
                    'Title' => Lang::__('Error'),
                    'Content' => Lang::__('In linking accounts please make sure to link') . ' ' . $Employees_salaries_link->{'name_' . $this->lang} . ' ' . Lang::__('And') . ' ' . $Bank_of_employees_salaries_link->{'name_' . $this->lang},
                );
            }
        }

        echo json_encode($results);
    }

    public function action_Explain_Salarie() {
        $results = array();

        if ($this->Calculation_of_salaries) {
            $req = Request::current();
            $Filtered_array = Search::action_Filtered_array($req->post());
            $employee_id = isset($Filtered_array['employee']) ? $Filtered_array['employee'] : NULL;
            $year = isset($Filtered_array['year']) ? $Filtered_array['year'] : NULL;
            $month = isset($Filtered_array['month']) ? $Filtered_array['month'] : NULL;

            $Employee = ORM::factory('Hr_Employment_Applications', $Filtered_array['employee']);

            if ($Employee->loaded() && checkdate(intval($month), 1, intval($year))) {
                $Salary = Model_Hr_Employment_Applications::CalculateSalarie($Employee, $year, $month);
                $results['Success'] = array(
                    'title' => Lang::__('Explain salary of') . ' ' . $Employee->{'name_first_' . $this->lang} . ' ' . $Employee->{'name_father_' . $this->lang} . ' ' . $Employee->{'name_grandfather_' . $this->lang} . ' ' . $Employee->{'name_last_' . $this->lang} . ' (' . Lang::__('month') . ' ' . $month . '/' . $year . ')',
                    'content' => General::ArrayToString($Salary['notes']),
                );
            }
        } else {
            $results['Error'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }





        echo json_encode($results);
    }

}
